/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.IOException;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.cassandraunit.DataLoader;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.FileDataSet;
import org.cassandraunit.dataset.ParseException;
import org.codehaus.mojo.cassandra.AbstractCqlLoadMojo;
import org.codehaus.mojo.cassandra.ConsoleScanner;
import org.codehaus.mojo.cassandra.Utils;

@Mojo(name="run", threadSafe=true)
public class RunCassandraMojo
extends AbstractCqlLoadMojo {
    @Parameter(property="cassandra.load.after.first.start", defaultValue="true")
    private boolean loadAfterFirstStart;
    @Parameter(defaultValue="${basedir}/src/test/resources/dataSet.xml")
    protected File cuDataSet;
    @Parameter(property="cassandra.cu.load.failure.ignore")
    private boolean cuLoadFailureIgnore;
    @Parameter(property="cassandra.cu.load.after.first.start", defaultValue="true")
    private boolean cuLoadAfterFirstStart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        long timeStamp = System.currentTimeMillis();
        boolean isClean = !this.cassandraDir.isDirectory();
        this.getLog().debug((CharSequence)((isClean ? "First start of Cassandra instance in " : "Re-using existing Cassandra instance in ") + this.cassandraDir.getAbsolutePath()));
        try {
            DefaultExecuteResultHandler execHandler = Utils.startCassandraServer(this.cassandraDir, this.newServiceCommandLine(), this.createEnvironmentVars(), this.getLog());
            try {
                this.getLog().info((CharSequence)"Waiting for Cassandra to start...");
                Utils.waitUntilStarted(this.rpcAddress, this.rpcPort, 0, this.getLog());
                if (isClean && this.loadAfterFirstStart) {
                    this.execCqlFile();
                }
                if (isClean && this.cuLoadAfterFirstStart && this.cuDataSet != null && this.cuDataSet.isFile()) {
                    this.getLog().info((CharSequence)("Loading CassandraUnit dataSet " + this.cuDataSet + "..."));
                    try {
                        DataLoader dataLoader = new DataLoader("cassandraUnitCluster", this.rpcAddress + ":" + this.rpcPort);
                        dataLoader.load((DataSet)new FileDataSet(this.cuDataSet.getAbsolutePath()));
                    }
                    catch (ParseException e) {
                        if (this.cuLoadFailureIgnore) {
                            this.getLog().error((CharSequence)(e.getMessage() + ". Ignoring as cuLoadFailureIgnore is true"));
                        }
                        throw new MojoExecutionException("Error while loading CassandraUnit dataSet", (Exception)((Object)e));
                    }
                    this.getLog().info((CharSequence)("Finished " + this.cuDataSet + "."));
                }
                this.getLog().info((CharSequence)("Cassandra started in " + (double)((System.currentTimeMillis() - timeStamp) / 100L) / 10.0 + "s"));
                ConsoleScanner consoleScanner = new ConsoleScanner();
                consoleScanner.start();
                this.getLog().info((CharSequence)"Hit ENTER on the console to stop Cassandra and continue the build.");
                try {
                    consoleScanner.waitForFinished();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                Utils.stopCassandraServer(this.rpcAddress, this.rpcPort, this.listenAddress, this.stopPort, this.stopKey, this.getLog());
                try {
                    execHandler.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }
}

