/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import org.apache.cassandra.thrift.Cassandra;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.cassandra.AbstractSchemaCassandraMojo;
import org.codehaus.mojo.cassandra.ThriftApiExecutionException;
import org.codehaus.mojo.cassandra.ThriftApiOperation;

@Mojo(name="drop", threadSafe=true)
public class DropColumnFamiliesMojo
extends AbstractSchemaCassandraMojo {
    @Parameter(property="cassandra.columnFamilies")
    protected String columnFamilies;
    private String[] columnFamilyList;

    @Override
    protected ThriftApiOperation buildOperation() {
        DropCfOperation dropCfOp = new DropCfOperation(this.rpcAddress, this.rpcPort);
        dropCfOp.setKeyspace(this.keyspace);
        return dropCfOp;
    }

    @Override
    protected void parseArguments() throws IllegalArgumentException {
        if (StringUtils.isNotBlank((String)this.keyspace)) {
            throw new IllegalArgumentException("The keyspace to drop column families from cannot be empty");
        }
        this.columnFamilyList = StringUtils.split((String)this.columnFamilies, (char)',');
    }

    class DropCfOperation
    extends ThriftApiOperation {
        public DropCfOperation(String rpcAddress, int rpcPort) {
            super(rpcAddress, rpcPort);
        }

        @Override
        public void executeOperation(Cassandra.Client client) throws ThriftApiExecutionException {
            try {
                if (DropColumnFamiliesMojo.this.columnFamilyList != null && DropColumnFamiliesMojo.this.columnFamilyList.length > 0) {
                    for (String s : DropColumnFamiliesMojo.this.columnFamilyList) {
                        client.system_drop_column_family(s);
                        DropColumnFamiliesMojo.this.getLog().info((CharSequence)("Dropped column family \"" + s + "\"."));
                    }
                } else {
                    client.system_drop_keyspace(DropColumnFamiliesMojo.this.keyspace);
                    DropColumnFamiliesMojo.this.getLog().info((CharSequence)("Dropped keyspace \"" + DropColumnFamiliesMojo.this.keyspace + "\"."));
                }
            }
            catch (Exception e) {
                throw new ThriftApiExecutionException(e);
            }
        }
    }
}

