/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.cassandra.AbstractCassandraMojo;
import org.codehaus.mojo.cassandra.MavenLogOutputStream;

public class RepairCassandraMojo
extends AbstractCassandraMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        try {
            Map<String, String> environment = this.createEnvironmentVars();
            CommandLine commandLine = this.newNodetoolCommandLine("repair");
            DefaultExecutor exec = new DefaultExecutor();
            exec.setWorkingDirectory(this.cassandraDir);
            exec.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
            MavenLogOutputStream stdout = new MavenLogOutputStream(this.getLog());
            MavenLogOutputStream stderr = new MavenLogOutputStream(this.getLog());
            try {
                this.getLog().debug((CharSequence)("Executing command line: " + commandLine));
                exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)stdout), (OutputStream)((Object)stderr), System.in));
                exec.execute(commandLine, environment);
                this.getLog().info((CharSequence)"Repair triggered.");
            }
            catch (ExecuteException e) {
                throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Command execution failed.", (Exception)e);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }
}

