/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.log.ScmLogDispatcher;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.AbstractSvnScmProvider;
import org.apache.maven.scm.provider.svn.command.info.SvnInfoItem;
import org.apache.maven.scm.provider.svn.command.info.SvnInfoScmResult;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

public class CreateMojo
extends AbstractMojo {
    private String urlScm;
    private String username;
    private String password;
    private File scmDirectory;
    private String buildNumberPropertyName;
    private String timestampPropertyName;
    private boolean doCheck;
    private boolean doUpdate;
    private String format;
    private File buildNumberPropertiesFileLocation;
    private List items;
    private String locale;
    private boolean useLastCommittedRevision;
    private String timestampFormat;
    private String revisionOnScmFailure;
    private Map providerImplementations;
    private ScmManager scmManager;
    private MavenProject project;
    private List reactorProjects;
    private boolean getRevisionOnlyOnce;
    protected MavenSession session;
    private ScmLogDispatcher logger;
    private String revision;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.providerImplementations != null) {
            Iterator i = this.providerImplementations.keySet().iterator();
            while (i.hasNext()) {
                String providerType = (String)i.next();
                String providerImplementation = (String)this.providerImplementations.get(providerType);
                this.getLog().info((CharSequence)("Change the default '" + providerType + "' provider implementation to '" + providerImplementation + "'."));
                this.scmManager.setScmProviderImplementation(providerType, providerImplementation);
            }
        }
        Date now = Calendar.getInstance().getTime();
        if (this.format != null) {
            Object[] itemAry = new Object[this.items.size()];
            for (int i = 0; i < this.items.size(); ++i) {
                Object item = this.items.get(i);
                if (item instanceof String) {
                    String s = (String)item;
                    if (s.equals("timestamp")) {
                        itemAry[i] = now;
                        continue;
                    }
                    if (s.startsWith("buildNumber")) {
                        File propertiesFile = this.buildNumberPropertiesFileLocation;
                        if (!propertiesFile.exists()) {
                            try {
                                propertiesFile.createNewFile();
                            }
                            catch (IOException e) {
                                throw new MojoExecutionException("Couldn't create properties file: " + propertiesFile, (Exception)e);
                            }
                        }
                        Properties properties = new Properties();
                        String buildNumberString = null;
                        try {
                            properties.load(new FileInputStream(propertiesFile));
                            buildNumberString = properties.getProperty(s);
                            if (buildNumberString == null) {
                                buildNumberString = "0";
                            }
                            int buildNumber = Integer.valueOf(buildNumberString);
                            properties.setProperty(s, String.valueOf(++buildNumber));
                            properties.store(new FileOutputStream(propertiesFile), "maven.buildNumber.plugin properties file");
                            itemAry[i] = new Integer(buildNumber);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new MojoExecutionException("Couldn't parse buildNumber in properties file to an Integer: " + buildNumberString);
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException("Couldn't load properties file: " + propertiesFile, (Exception)e);
                        }
                    }
                    itemAry[i] = item;
                    continue;
                }
                itemAry[i] = item;
            }
            this.revision = this.format(itemAry);
        } else {
            this.revision = this.project.getProperties().getProperty(this.buildNumberPropertyName);
            if (this.getRevisionOnlyOnce && this.revision != null) {
                this.getLog().debug((CharSequence)"Revision available from previous execution");
                return;
            }
            if (this.doCheck) {
                this.checkForLocalModifications();
            } else {
                this.getLog().info((CharSequence)"Checking for local modifications: skipped.");
            }
            if (this.session.getSettings().isOffline()) {
                this.getLog().info((CharSequence)"maven is executed in offline mode, Updating project files from SCM: skipped.");
            } else if (this.doUpdate) {
                List changedFiles = this.update();
                Iterator i = changedFiles.iterator();
                while (i.hasNext()) {
                    ScmFile file = (ScmFile)i.next();
                    this.getLog().info((CharSequence)("Updated: " + file));
                }
                if (changedFiles.size() == 0) {
                    this.getLog().info((CharSequence)"No files needed updating.");
                }
            } else {
                this.getLog().info((CharSequence)"Updating project files from SCM: skipped.");
            }
            this.revision = this.getRevision();
        }
        if (this.project != null) {
            String timestamp = String.valueOf(now.getTime());
            if (this.timestampFormat != null) {
                timestamp = MessageFormat.format(this.timestampFormat, now);
            }
            this.getLog().info((CharSequence)MessageFormat.format("Storing buildNumber: {0} at timestamp: {1}", this.revision, timestamp));
            if (this.revision != null) {
                this.project.getProperties().put(this.buildNumberPropertyName, this.revision);
            }
            this.project.getProperties().put(this.timestampPropertyName, timestamp);
            if (this.getRevisionOnlyOnce && this.reactorProjects != null) {
                Iterator projIter = this.reactorProjects.iterator();
                while (projIter.hasNext()) {
                    MavenProject nextProj = (MavenProject)projIter.next();
                    nextProj.getProperties().put(this.buildNumberPropertyName, this.revision);
                    nextProj.getProperties().put(this.timestampPropertyName, timestamp);
                }
            }
        }
    }

    private String format(Object[] arguments) {
        Locale l = Locale.getDefault();
        if (this.locale != null) {
            String[] parts = this.locale.split("_", 3);
            l = parts.length <= 1 ? new Locale(this.locale) : (parts.length == 2 ? new Locale(parts[0], parts[1]) : new Locale(parts[0], parts[1], parts[2]));
        }
        return new MessageFormat(this.format, l).format(arguments);
    }

    private void checkForLocalModifications() throws MojoExecutionException {
        List changedFiles;
        this.getLog().info((CharSequence)"Verifying there are no local modifications ...");
        try {
            changedFiles = this.getStatus();
        }
        catch (ScmException e) {
            throw new MojoExecutionException("An error has occurred while checking scm status.", (Exception)((Object)e));
        }
        if (!changedFiles.isEmpty()) {
            StringBuffer message = new StringBuffer();
            Iterator i = changedFiles.iterator();
            while (i.hasNext()) {
                ScmFile file = (ScmFile)i.next();
                message.append(file.toString());
                message.append("\n");
            }
            throw new MojoExecutionException("Cannot create the build number because you have local modifications : \n" + message);
        }
    }

    public List update() throws MojoExecutionException {
        try {
            ScmRepository repository = this.getScmRepository();
            ScmProvider scmProvider = this.scmManager.getProviderByRepository(repository);
            UpdateScmResult result = scmProvider.update(repository, new ScmFileSet(this.scmDirectory));
            this.checkResult((ScmResult)result);
            if (scmProvider instanceof AbstractSvnScmProvider) {
                String revision = ((UpdateScmResultWithRevision)result).getRevision();
                this.getLog().info((CharSequence)("Got a revision during update: " + revision));
                this.revision = revision;
            }
            return result.getUpdatedFiles();
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Couldn't update project.", (Exception)((Object)e));
        }
    }

    public List getStatus() throws ScmException {
        ScmRepository repository = this.getScmRepository();
        ScmProvider scmProvider = this.scmManager.getProviderByRepository(repository);
        StatusScmResult result = scmProvider.status(repository, new ScmFileSet(this.scmDirectory));
        this.checkResult((ScmResult)result);
        return result.getChangedFiles();
    }

    public String getRevision() throws MojoExecutionException {
        if (this.format != null) {
            return this.revision;
        }
        try {
            ScmRepository repository = this.getScmRepository();
            SvnInfoScmResult scmResult = this.info(repository, new ScmFileSet(this.scmDirectory));
            this.checkResult((ScmResult)scmResult);
            SvnInfoItem info = (SvnInfoItem)scmResult.getInfoItems().get(0);
            if (this.useLastCommittedRevision) {
                return info.getLastChangedRevision();
            }
            return info.getRevision();
        }
        catch (ScmException e) {
            if (!StringUtils.isEmpty((String)this.revisionOnScmFailure)) {
                this.getLog().warn((CharSequence)("Cannot get the revision information from the scm repository, proceeding with revision of " + this.revisionOnScmFailure + " : \n" + e.getLocalizedMessage()));
                this.setDoCheck(false);
                this.setDoUpdate(false);
                return this.revisionOnScmFailure;
            }
            throw new MojoExecutionException("Cannot get the revision information from the scm repository : \n" + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public SvnInfoScmResult info(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        AbstractSvnScmProvider abstractSvnScmProvider = (AbstractSvnScmProvider)this.scmManager.getProviderByType("svn");
        return abstractSvnScmProvider.info(repository.getProviderRepository(), fileSet, null);
    }

    private ScmLogger getLogger() {
        if (this.logger == null) {
            this.logger = new ScmLogDispatcher();
        }
        return this.logger;
    }

    private ScmRepository getScmRepository() throws ScmException {
        ScmRepository repository = this.scmManager.makeScmRepository(this.urlScm);
        ScmProviderRepository scmRepo = repository.getProviderRepository();
        if (!StringUtils.isEmpty((String)this.username)) {
            scmRepo.setUser(this.username);
        }
        if (!StringUtils.isEmpty((String)this.password)) {
            scmRepo.setPassword(this.password);
        }
        return repository;
    }

    private void checkResult(ScmResult result) throws ScmException {
        if (!result.isSuccess()) {
            System.err.println("Provider message:");
            System.err.println(result.getProviderMessage());
            System.err.println("Command output:");
            System.err.println(result.getCommandOutput());
            throw new ScmException("Error!");
        }
    }

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }

    public void setUrlScm(String urlScm) {
        this.urlScm = urlScm;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDoCheck(boolean doCheck) {
        String doCheckSystemProperty = System.getProperty("maven.buildNumber.doCheck");
        this.doCheck = doCheckSystemProperty != null ? Boolean.valueOf(doCheckSystemProperty) : doCheck;
    }

    public void setDoUpdate(boolean doUpdate) {
        String doUpdateSystemProperty = System.getProperty("maven.buildNumber.doUpdate");
        this.doUpdate = doUpdateSystemProperty != null ? Boolean.valueOf(doUpdateSystemProperty) : doUpdate;
    }

    void setFormat(String format) {
        this.format = format;
    }

    void setLocale(String locale) {
        this.locale = locale;
    }

    void setItems(List items) {
        this.items = items;
    }

    public void setBuildNumberPropertiesFileLocation(File buildNumberPropertiesFileLocation) {
        this.buildNumberPropertiesFileLocation = buildNumberPropertiesFileLocation;
    }

    public void setScmDirectory(File scmDirectory) {
        this.scmDirectory = scmDirectory;
    }

    public void setRevisionOnScmFailure(String revisionOnScmFailure) {
        this.revisionOnScmFailure = revisionOnScmFailure;
    }
}

