/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.codehaus.plexus.util.StringInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InfoScmResult
extends ScmResult {
    public InfoScmResult(String commandLine, String commandOutput) {
        this(commandLine, null, commandOutput, true);
    }

    public InfoScmResult(String commandLine, String providerMessage, String commandOutput, boolean success) {
        super(commandLine, providerMessage, commandOutput, success);
    }

    public String getRevision(boolean commitRevision) throws ScmException {
        return InfoScmResult.getRevision(this.getCommandOutput(), commitRevision);
    }

    public static String getRevision(String scmCommandOutput, boolean commitRevision) throws ScmException {
        try {
            NodeList commitNodes;
            Element entryElement;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse((InputStream)new StringInputStream(scmCommandOutput));
            Node revisionNode = entryElement = (Element)document.getDocumentElement().getElementsByTagName("entry").item(0);
            if (commitRevision && (commitNodes = entryElement.getElementsByTagName("commit")) != null && commitNodes.getLength() != 0) {
                revisionNode = commitNodes.item(0);
            }
            Node node = revisionNode.getAttributes().getNamedItem("revision");
            return node.getNodeValue();
        }
        catch (ParserConfigurationException e) {
            throw new ScmException("Couldn't locate xml parser.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ScmException("Couldn't parse XML.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ScmException("Couldn't parse XML.", (Throwable)e);
        }
    }
}

