/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.codehaus.mojo.build.InfoScmResult;
import org.codehaus.mojo.build.SvnInfoConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnInfoCommand
extends AbstractCommand
implements SvnCommand {
    protected InfoScmResult executeInfoCommand(ScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        Process process;
        Commandline cl;
        try {
            cl = SvnInfoCommand.createCommandline((SvnScmProviderRepository)repo, fileSet.getBasedir());
        }
        catch (Exception e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        SvnInfoConsumer stdin = new SvnInfoConsumer(this.getLogger());
        System.out.println("Executing: " + cl);
        System.out.println("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        try {
            String line;
            process = cl.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                stdin.consumeLine(line);
            }
            br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = br.readLine()) != null) {
                stderr.consumeLine(line);
            }
            process.waitFor();
        }
        catch (CommandLineException e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        if (process != null && process.exitValue() != 0) {
            process.destroy();
            return new InfoScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        process.destroy();
        return new InfoScmResult(cl.toString(), stdin.getCommandOutput());
    }

    private static Commandline createCommandline(SvnScmProviderRepository repository, File workingDirectory) throws Exception {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine((File)workingDirectory, (SvnScmProviderRepository)repository);
        String svnexe = System.getProperty("pathToSvnExecutable");
        if (svnexe != null) {
            cl.setExecutable(svnexe);
        }
        cl.createArgument().setValue("info");
        cl.createArgument().setValue("--xml");
        return cl;
    }

    protected ScmResult executeCommand(ScmProviderRepository scmProviderRepository, ScmFileSet scmFileSet, CommandParameters commandParameters) throws ScmException {
        return this.executeInfoCommand(scmProviderRepository, scmFileSet);
    }
}

