/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.GeneratorConfiguration;
import org.codehaus.mojo.appassembler.model.JvmSettings;

public class Daemon
implements Serializable {
    private String id;
    private String mainClass;
    private Classpath classpath;
    private List commandLineArguments;
    private JvmSettings jvmSettings;
    private String environmentSetupFileName;
    private boolean showConsoleWindow = true;
    private List generatorConfigurations;
    private String repositoryName = "repo";
    private String licenseHeaderFile;
    private String wrapperLogFile;
    private String modelEncoding = "UTF-8";

    public void addCommandLineArgument(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("Daemon.addCommandLineArguments(string) parameter must be instanceof " + String.class.getName());
        }
        this.getCommandLineArguments().add(string);
    }

    public void addGeneratorConfiguration(GeneratorConfiguration generatorConfiguration) {
        if (!(generatorConfiguration instanceof GeneratorConfiguration)) {
            throw new ClassCastException("Daemon.addGeneratorConfigurations(generatorConfiguration) parameter must be instanceof " + GeneratorConfiguration.class.getName());
        }
        this.getGeneratorConfigurations().add(generatorConfiguration);
    }

    public Classpath getClasspath() {
        return this.classpath;
    }

    public List getCommandLineArguments() {
        if (this.commandLineArguments == null) {
            this.commandLineArguments = new ArrayList();
        }
        return this.commandLineArguments;
    }

    public String getEnvironmentSetupFileName() {
        return this.environmentSetupFileName;
    }

    public List getGeneratorConfigurations() {
        if (this.generatorConfigurations == null) {
            this.generatorConfigurations = new ArrayList();
        }
        return this.generatorConfigurations;
    }

    public String getId() {
        return this.id;
    }

    public JvmSettings getJvmSettings() {
        return this.jvmSettings;
    }

    public String getLicenseHeaderFile() {
        return this.licenseHeaderFile;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getWrapperLogFile() {
        return this.wrapperLogFile;
    }

    public boolean isShowConsoleWindow() {
        return this.showConsoleWindow;
    }

    public void removeCommandLineArgument(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("Daemon.removeCommandLineArguments(string) parameter must be instanceof " + String.class.getName());
        }
        this.getCommandLineArguments().remove(string);
    }

    public void removeGeneratorConfiguration(GeneratorConfiguration generatorConfiguration) {
        if (!(generatorConfiguration instanceof GeneratorConfiguration)) {
            throw new ClassCastException("Daemon.removeGeneratorConfigurations(generatorConfiguration) parameter must be instanceof " + GeneratorConfiguration.class.getName());
        }
        this.getGeneratorConfigurations().remove(generatorConfiguration);
    }

    public void setClasspath(Classpath classpath) {
        this.classpath = classpath;
    }

    public void setCommandLineArguments(List commandLineArguments) {
        this.commandLineArguments = commandLineArguments;
    }

    public void setEnvironmentSetupFileName(String environmentSetupFileName) {
        this.environmentSetupFileName = environmentSetupFileName;
    }

    public void setGeneratorConfigurations(List generatorConfigurations) {
        this.generatorConfigurations = generatorConfigurations;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setJvmSettings(JvmSettings jvmSettings) {
        this.jvmSettings = jvmSettings;
    }

    public void setLicenseHeaderFile(String licenseHeaderFile) {
        this.licenseHeaderFile = licenseHeaderFile;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setShowConsoleWindow(boolean showConsoleWindow) {
        this.showConsoleWindow = showConsoleWindow;
    }

    public void setWrapperLogFile(String wrapperLogFile) {
        this.wrapperLogFile = wrapperLogFile;
    }

    public List getAllClasspathElements() {
        if (this.classpath == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList elements = new ArrayList(this.classpath.getDependencies().size() + this.classpath.getDirectories().size());
        elements.addAll(this.classpath.getDirectories());
        elements.addAll(this.classpath.getDependencies());
        return elements;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

