/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.IOUtil;

public class FormattedProperties {
    private static final Pattern LIST_KEY_PATTERN = Pattern.compile("^(.*)\\.[0-9]+$");
    private final Properties properties = new Properties();
    private Map<String, Integer> propertyLines;
    private List<String> fileLines;
    private Map<String, List<String>> listProperties = new HashMap<String, List<String>>();
    private Map<String, List<String>> afterProperties = new HashMap<String, List<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, String value) {
        Properties properties = this.properties;
        synchronized (properties) {
            this.properties.setProperty(key, value);
            Matcher m = LIST_KEY_PATTERN.matcher(key);
            if (m.matches()) {
                String listKey = m.group(1);
                List<String> p = this.listProperties.get(listKey);
                if (p == null) {
                    p = new ArrayList<String>();
                    this.listProperties.put(listKey, p);
                }
                p.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String key) {
        Properties properties = this.properties;
        synchronized (properties) {
            return this.properties.getProperty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String key, String defaultValue) {
        Properties properties = this.properties;
        synchronized (properties) {
            return this.properties.getProperty(key, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(String key) {
        Properties properties = this.properties;
        synchronized (properties) {
            this.properties.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream inputStream) throws IOException {
        Properties properties = this.properties;
        synchronized (properties) {
            this.fileLines = new ArrayList<String>();
            this.propertyLines = new HashMap<String, Integer>();
            BufferedReader r = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            try {
                int lineNo = 1;
                String line = r.readLine();
                while (line != null) {
                    String[] pair = line.split("=", 2);
                    String key = pair[0];
                    if (pair.length > 1) {
                        Matcher m;
                        String value = pair[1].trim();
                        boolean commented = false;
                        if (key.startsWith("#")) {
                            commented = true;
                            key = key.substring(1);
                        }
                        key = key.trim();
                        if (!commented) {
                            this.setProperty(key, value);
                        }
                        if ((m = LIST_KEY_PATTERN.matcher(key)).matches()) {
                            key = m.group(1);
                        }
                        this.propertyLines.put(key, new Integer(lineNo));
                    }
                    this.fileLines.add(line);
                    line = r.readLine();
                    ++lineNo;
                }
            }
            finally {
                IOUtil.close((Reader)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream outputStream) {
        Properties properties = this.properties;
        synchronized (properties) {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream));
            try {
                HashSet<String> writtenProperties = new HashSet<String>();
                for (int i = 0; i < this.fileLines.size(); ++i) {
                    String string = this.fileLines.get(i);
                    if (string.trim().length() > 0) {
                        List<String> p;
                        Matcher m;
                        String value;
                        String[] pair = string.split("=", 2);
                        String key = pair[0];
                        if (key.startsWith("#")) {
                            key = key.substring(1);
                            writer.println(string);
                        }
                        if (new Integer(i + 1).equals(this.propertyLines.get(key = key.trim())) && (value = this.properties.getProperty(key)) != null) {
                            writer.println(key + "=" + value);
                            writtenProperties.add(key);
                        }
                        if (this.afterProperties.containsKey(key)) {
                            List<String> p2 = this.afterProperties.get(key);
                            for (String pKey : p2) {
                                String value2 = this.properties.getProperty(pKey);
                                if (value2 == null || writtenProperties.contains(pKey)) continue;
                                writer.println(pKey + "=" + value2);
                                writtenProperties.add(pKey);
                            }
                        }
                        if (!(m = LIST_KEY_PATTERN.matcher(key)).matches() || !new Integer(i + 1).equals(this.propertyLines.get(key = m.group(1))) || (p = this.listProperties.get(key)) == null) continue;
                        for (String itemKey : p) {
                            String value3;
                            if (writtenProperties.contains(itemKey) || (value3 = this.properties.getProperty(itemKey)) == null) continue;
                            writer.println(itemKey + "=" + value3);
                            writtenProperties.add(itemKey);
                        }
                        continue;
                    }
                    writer.println(string);
                }
                for (String string : this.properties.keySet()) {
                    String value;
                    if (writtenProperties.contains(string) || (value = this.properties.getProperty(string)) == null) continue;
                    writer.println(string + "=" + value);
                }
            }
            finally {
                IOUtil.close((Writer)writer);
            }
        }
    }

    public void setPropertyAfter(String key, String value, String afterProperty) {
        List<String> p = this.afterProperties.get(afterProperty);
        if (p == null) {
            p = new ArrayList<String>();
            this.afterProperties.put(afterProperty, p);
        }
        p.add(key);
        this.setProperty(key, value);
    }
}

