/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.appassembler.AbstractScriptGeneratorMojo;
import org.codehaus.mojo.appassembler.Program;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.script.Platform;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.Directory;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.mojo.appassembler.util.DependencyFactory;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="assemble", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class AssembleMojo
extends AbstractScriptGeneratorMojo {
    @Parameter(property="assembleDirectory", defaultValue="${project.build.directory}/appassembler", required=true)
    private File assembleDirectory;
    @Parameter
    protected Map<String, String> binFileExtensions;
    @Parameter(defaultValue="bin")
    private String binFolder;
    @Parameter
    private String extraJvmArguments;
    @Parameter(defaultValue="true")
    private boolean includeConfigurationDirectoryInClasspath;
    @Parameter
    private Set<String> platforms;
    @Parameter(required=true)
    private Set<Program> programs;
    @Parameter(defaultValue="false")
    private boolean projectArtifactFirstInClassPath;
    @Parameter(defaultValue="repo")
    private String repositoryName;
    @Parameter(defaultValue="true")
    private boolean showConsoleWindow;
    @Parameter(defaultValue="false")
    private boolean useAllProjectDependencies;
    private static final Set<String> VALID_PLATFORMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("unix", "windows")));

    private void validate(Set<String> defaultPlatforms) throws MojoFailureException, MojoExecutionException {
        ArrayList<String> programNames = new ArrayList<String>();
        for (Program program : this.programs) {
            if (program.getName() != null) {
                program.setId(program.getName());
                this.getLog().warn((CharSequence)("The usage of program name (" + program.getName() + ") is deprecated. Please use program.id instead."));
            }
            if (program.getMainClass() == null || program.getMainClass().trim().equals("")) {
                throw new MojoFailureException("Missing main class in Program configuration");
            }
            if (programNames.contains(program.getId())) {
                throw new MojoFailureException("The program id: " + program.getId() + " exists more than once!");
            }
            programNames.add(program.getId());
            program.setPlatforms(this.validatePlatforms(program.getPlatforms(), defaultPlatforms));
        }
    }

    public void checkDeprecatedParameterAndFailIfOneOfThemIsUsed() throws MojoExecutionException {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<String> defaultPlatforms = this.validatePlatforms(this.platforms, VALID_PLATFORMS);
        this.checkDeprecatedParameterAndFailIfOneOfThemIsUsed();
        this.validate(defaultPlatforms);
        if (this.useWildcardClassPath && !this.repositoryLayout.equalsIgnoreCase("flat")) {
            throw new MojoExecutionException("useWildcardClassPath works only in combination with repositoryLayout flat.");
        }
        this.setBinFileExtensions();
        ArtifactRepositoryLayout artifactRepositoryLayout = this.getArtifactRepositoryLayout();
        if (this.useAllProjectDependencies) {
            Set dependencyArtifacts = this.mavenProject.getDependencyArtifacts();
            this.artifacts = new ArrayList();
            for (Artifact artifact : dependencyArtifacts) {
                this.artifacts.add(artifact);
            }
        }
        super.installDependencies(this.assembleDirectory.getAbsolutePath(), this.repositoryName);
        this.setUpWorkingArea();
        for (Program program : this.programs) {
            if (program.getName() != null) {
                program.setId(program.getName());
            }
            Set<String> validatedPlatforms = this.validatePlatforms(program.getPlatforms(), defaultPlatforms);
            for (String platform : validatedPlatforms) {
                Daemon daemon = this.programToDaemon(program, artifactRepositoryLayout);
                DaemonGenerationRequest request = new DaemonGenerationRequest(daemon, this.mavenProject, this.localRepository, this.assembleDirectory, this.binFolder);
                request.setStubDaemon(request.getDaemon());
                request.setPlatform(platform);
                try {
                    this.daemonGeneratorService.generateDaemon(request);
                }
                catch (DaemonGeneratorException e) {
                    throw new MojoExecutionException("Error while generating script for the program '" + program.getId() + "' for the platform '" + platform + "': " + e.getMessage(), (Exception)e);
                }
            }
        }
        if (this.copyConfigurationDirectory) {
            this.doCopyConfigurationDirectory(this.assembleDirectory.getAbsolutePath());
        }
        this.doCreateExtraDirectories(this.assembleDirectory);
    }

    private Daemon programToDaemon(Program program, ArtifactRepositoryLayout artifactRepositoryLayout) {
        Daemon daemon = new Daemon();
        if (program.getName() == null) {
            daemon.setId(program.getId());
        } else {
            daemon.setId(program.getName());
        }
        daemon.setMainClass(program.getMainClass());
        daemon.setShowConsoleWindow(this.showConsoleWindow);
        daemon.setCommandLineArguments(program.getCommandLineArguments());
        if (program.getLicenseHeaderFile() != null) {
            this.getLog().debug((CharSequence)("Using the program specific license header. :" + program.getLicenseHeaderFile()));
            daemon.setLicenseHeaderFile(program.getLicenseHeaderFile().getPath());
        } else {
            this.getLog().debug((CharSequence)("Using the global defined license header. :" + this.licenseHeaderFile));
            if (this.licenseHeaderFile != null) {
                daemon.setLicenseHeaderFile(this.licenseHeaderFile.getAbsolutePath());
            } else {
                daemon.setLicenseHeaderFile(null);
            }
        }
        ArrayList<Directory> directories = new ArrayList<Directory>();
        if (this.includeConfigurationDirectoryInClasspath) {
            Directory directory = new Directory();
            directory.setRelativePath(this.configurationDirectory);
            directories.add(directory);
        }
        if (daemon.getClasspath() == null) {
            daemon.setClasspath(new Classpath());
        }
        daemon.getClasspath().setDirectories(directories);
        daemon.setRepositoryName(this.repositoryName);
        daemon.setEndorsedDir(this.endorsedDir);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (this.useWildcardClassPath) {
            Dependency dependency = new Dependency();
            dependency.setGroupId("");
            dependency.setArtifactId("");
            dependency.setVersion("");
            dependency.setRelativePath("*");
            dependencies.add(dependency);
        } else {
            ArrayList<Artifact> classPathArtifacts = new ArrayList<Artifact>();
            if (this.projectArtifactFirstInClassPath) {
                classPathArtifacts.add(this.projectArtifact);
                classPathArtifacts.addAll(this.artifacts);
            } else {
                classPathArtifacts.addAll(this.artifacts);
                classPathArtifacts.add(this.projectArtifact);
            }
            for (Artifact artifact : classPathArtifacts) {
                dependencies.add(DependencyFactory.create(artifact, artifactRepositoryLayout, this.useTimestampInSnapshotFileName, this.outputFileNameMapping));
            }
        }
        daemon.getClasspath().setDependencies(dependencies);
        daemon.setJvmSettings(this.convertToJvmSettingsWithDefaultHandling(program));
        daemon.setEnvironmentSetupFileName(this.environmentSetupFileName);
        if (this.unixScriptTemplate != null) {
            daemon.setUnixScriptTemplate(this.unixScriptTemplate);
        }
        if (this.windowsScriptTemplate != null) {
            daemon.setWindowsScriptTemplate(this.windowsScriptTemplate);
        }
        return daemon;
    }

    private JvmSettings convertToJvmSettingsWithDefaultHandling(Program program) {
        JvmSettings jvmSettings = new JvmSettings();
        if (program.getJvmSettings() != null) {
            jvmSettings = program.getJvmSettings();
        } else if (StringUtils.isNotBlank((String)this.extraJvmArguments)) {
            jvmSettings.setExtraArguments(AssembleMojo.parseTokens(this.extraJvmArguments));
        }
        return jvmSettings;
    }

    private void setUpWorkingArea() throws MojoFailureException {
        boolean success;
        File binDir = new File(this.assembleDirectory.getAbsolutePath(), this.binFolder.toString());
        if (!binDir.exists() && !(success = binDir.mkdirs())) {
            throw new MojoFailureException("Failed to create directory for bin files.");
        }
    }

    private Set<String> validatePlatforms(Set<String> platformsToValidate, Set<String> defaultPlatforms) throws MojoFailureException {
        if (platformsToValidate == null) {
            return defaultPlatforms;
        }
        if (platformsToValidate.size() == 1 && platformsToValidate.iterator().next().equals("all")) {
            return VALID_PLATFORMS;
        }
        if (!VALID_PLATFORMS.containsAll(platformsToValidate)) {
            throw new MojoFailureException("Non-valid default platform declared, supported types are: " + VALID_PLATFORMS);
        }
        return platformsToValidate;
    }

    public static List<String> parseTokens(String arg) {
        ArrayList<String> extraJvmArguments = new ArrayList<String>();
        if (StringUtils.isEmpty((String)arg)) {
            return extraJvmArguments;
        }
        StringTokenizer tokenizer = new StringTokenizer(arg);
        String argument = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (argument != null) {
                if (token.length() == 0) continue;
                int length = token.length();
                if (token.charAt(length - 1) == '\"') {
                    extraJvmArguments.add(argument + " " + token.substring(0, length - 1));
                    argument = null;
                    continue;
                }
                argument = argument + " " + token;
                continue;
            }
            if (token.charAt(0) == '\"') {
                argument = token.substring(1);
                continue;
            }
            extraJvmArguments.add(token);
        }
        return extraJvmArguments;
    }

    private void setBinFileExtensions() throws MojoFailureException {
        if (this.binFileExtensions != null) {
            for (String platformName : this.binFileExtensions.keySet()) {
                if (!VALID_PLATFORMS.contains(platformName)) {
                    this.getLog().warn((CharSequence)("Bin file extension configured for a non-valid platform (" + platformName + "), supported platforms are: " + VALID_PLATFORMS));
                    continue;
                }
                try {
                    Platform platform = Platform.getInstance(platformName);
                    platform.setBinFileExtension(this.binFileExtensions.get(platformName));
                }
                catch (DaemonGeneratorException e) {
                    this.getLog().warn((CharSequence)("Unable to set the bin file extension for " + platformName), (Throwable)e);
                }
            }
        }
    }
}

