package org.codehaus.mojo.appassembler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on appassembler-maven-plugin.<br/> Call <pre>  mvn appassembler:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Wed Dec 18 20:32:10 CET 2013
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.9)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:appassembler-maven-plugin:1.7", 0 );
        append( sb, "", 0 );

        append( sb, "Appassembler :: Maven Plug-In", 0 );
        append( sb, "A Mojo for generating bin scripts for Java applications.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 4 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "assemble".equals( goal ) )
        {
            append( sb, "appassembler:assemble", 0 );
            append( sb, "Assembles the artifacts and generates bin scripts for the configured applications", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assembleDirectory (Default: ${project.build.directory}/appassembler)", 2 );
                append( sb, "The directory that will be used to assemble the artifacts in and place the bin scripts.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${assembleDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "binFileExtensions", 2 );
                append( sb, "The file extensions to use for bin files. The file extensions are stored in a Map that uses the platform name as key. To change the file extension for Unix bin files to \'.sh\' use this configuration:\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<binFileExtensions>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<unix>.sh</unix>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</binFileExtensions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "binFolder (Default: bin)", 2 );
                append( sb, "Define the name of binary folder.", 3 );
                append( sb, "", 0 );

                append( sb, "configurationDirectory (Default: etc)", 2 );
                append( sb, "The name of the target directory for configuration files. Prior to version 1.7 this value defaults to \'conf\' for assemble goal and \'etc\' for generate-daemons", 3 );
                append( sb, "", 0 );

                append( sb, "configurationSourceDirectory (Default: src/main/config)", 2 );
                append( sb, "The name of the source directory for configuration files.", 3 );
                append( sb, "", 0 );

                append( sb, "copyConfigurationDirectory (Default: false)", 2 );
                append( sb, "If the source configuration directory should be copied to the configured configurationDirectory.", 3 );
                append( sb, "", 0 );

                append( sb, "endorsedDir", 2 );
                append( sb, "Location under base directory where all of files non-recursively are added before the generated classpath. Java 6+ only since it uses wildcard classpath format. This is a convenient way to have user to add artifacts that not possible to be part of final assembly such as LGPL/GPL artifacts", 3 );
                append( sb, "", 0 );

                append( sb, "environmentSetupFileName", 2 );
                append( sb, "Setup file in $BASEDIR/bin to be called prior to execution.\nNote: only for the jsw platform. If this optional environment file also sets up WRAPPER_CONF_OVERRIDES variable, it will be passed into JSW native launcher\'s command line arguments to override wrapper.conf\'s properties. See http://wrapper.tanukisoftware.com/doc/english/props-command-line.html for details.\n", 3 );
                append( sb, "", 0 );

                append( sb, "extraJvmArguments", 2 );
                append( sb, "Extra arguments that will be given to the JVM verbatim. If you define JvmSettings on the Program.setJvmSettings() level this part will be overwritten by the given parameters on program level. Otherwise if Program.setJvmSettings() is not given these settings will be used instead. This can be used to define some default values whereas by using the Program.setJvmSettings() to overwrite the default settings. This is only valid for the extraJvmArguments not for the rest of the JvmSettings. Since 1.2 it\'s possible to use place holders @BASEDIR@ and @REPO@ which will be expanded based on the platform for which the appropriate scripts will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "generateRepository (Default: true)", 2 );
                append( sb, "Set to false to skip repository generation.", 3 );
                append( sb, "", 0 );

                append( sb, "includeConfigurationDirectoryInClasspath (Default: true)", 2 );
                append( sb, "If the configurationDirectory (etc by default) should be included in the beginning of the classpath in the generated bin files.", 3 );
                append( sb, "", 0 );

                append( sb, "licenseHeaderFile", 2 );
                append( sb, "You can define a license header file which will be used instead the default header in the generated scripts.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFileNameMapping", 2 );
                append( sb, "The file name mapping to use when copying libraries to the repository. If no file mapping is set (default) the files are copied with their standard names.\nNote: if you use this parameter, then the useTimestampInSnapshotFileName parameter will be ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "platforms", 2 );
                append( sb, "The default platforms the plugin will generate bin files for. Configure with string values - \'all\'(default/empty) | \'windows\' | \'unix\'.", 3 );
                append( sb, "", 0 );

                append( sb, "programs", 2 );
                append( sb, "The set of Programs that bin files will be generated for.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "projectArtifactFirstInClassPath (Default: false)", 2 );
                append( sb, "This can be used to put the project artifact as the first entry in the classpath after the configuration folder ( etc by default). The default behavior is to have the project artifact at the last position in classpath.", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryLayout (Default: default)", 2 );
                append( sb, "The layout of the generated Maven repository. Supported types - \'default\' (Maven2) | \'legacy\' (Maven1) | \'flat\' (flat lib/ style). The style \'legacy\' is only supported if you are running under Maven 2.2.1 and before.", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryName (Default: repo)", 2 );
                append( sb, "Path (relative to assembleDirectory) of the desired output repository.", 3 );
                append( sb, "", 0 );

                append( sb, "showConsoleWindow (Default: true)", 2 );
                append( sb, "Show console window when execute this application. When false, the generated java command runs in background. This works best for Swing application where the command line invocation is not blocked.", 3 );
                append( sb, "", 0 );

                append( sb, "unixScriptTemplate", 2 );
                append( sb, "The unix template of the generated script. It can be a file or resource path. If not given, an internal one is used. Use with care since it is not guaranteed to be compatible with new plugin release.", 3 );
                append( sb, "Expression: ${unixScriptTemplate}", 3 );
                append( sb, "", 0 );

                append( sb, "useAllDependencies (Default: false)", 2 );
                append( sb, "Deprecated. Use useAllProjectDependencies instead otherwise your build will fail.", 3 );
                append( sb, "", 0 );
                append( sb, "The following can be used to use all dependencies instead of the default behavior which represents runtime dependencies only.", 3 );
                append( sb, "", 0 );

                append( sb, "useAllProjectDependencies (Default: false)", 2 );
                append( sb, "The following can be used to use all project dependencies instead of the default behavior which represents runtime dependencies only.", 3 );
                append( sb, "", 0 );

                append( sb, "useAsterikClassPath (Default: false)", 2 );
                append( sb, "Deprecated. Use useWildcardClassPath instead otherwise your build will fail.", 3 );
                append( sb, "", 0 );
                append( sb, "Sometimes it happens that you have many dependencies which means in other words having a very long classpath. And sometimes the classpath becomes too long (in particular on Windows based platforms). This option can help in such situation. If you activate that your classpath contains only a classpath wildcard (REPO/*). But be aware that this works only in combination with Java 1.6 and with repositoryLayout flat. Otherwise this configuration will not work.", 3 );
                append( sb, "", 0 );

                append( sb, "useTimestampInSnapshotFileName (Default: true)", 2 );
                append( sb, "For those snapshots downloaded from a remote repo, replace the timestamp part with \'SNAPSHOT\' instead.", 3 );
                append( sb, "", 0 );

                append( sb, "useWildcardClassPath (Default: false)", 2 );
                append( sb, "Sometimes it happens that you have many dependencies which means in other words having a very long classpath. And sometimes the classpath becomes too long (in particular on Windows based platforms). This option can help in such situation. If you activate that your classpath contains only a classpath wildcard (REPO/*). But be aware that this works only in combination with Java 1.6 and above and with repositoryLayout flat. Otherwise this configuration will not work.", 3 );
                append( sb, "", 0 );

                append( sb, "windowsScriptTemplate", 2 );
                append( sb, "The windows template of the generated script. It can be a file or resource path. If not given, an internal one is used. Use with care since it is not guaranteed to be compatible with new plugin release.", 3 );
                append( sb, "Expression: ${windowsScriptTemplate}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "create-repository".equals( goal ) )
        {
            append( sb, "appassembler:create-repository", 0 );
            append( sb, "Creates an appassembler repository. Note that this is deliberately a bit more specific than the assembly plugin version - if that could generate a flat layout and exclude JARs, it may be a suitable replacement.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "assembleDirectory", 2 );
                append( sb, "The directory that will be used to assemble the artifacts in and place the bin scripts.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.directory}/appassembler", 3 );
                append( sb, "", 0 );

                append( sb, "installBooterArtifacts (Default: false)", 2 );
                append( sb, "Whether to install the booter artifacts into the repository. This may be needed if you are using the Shell script generators.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFileNameMapping", 2 );
                append( sb, "The file name mapping to use when copying libraries to the repository. If no file mapping is set (default) the files are copied with their standard names.\nNote: if you use this parameter, then the useTimestampInSnapshotFileName parameter will be ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "repoPath (Default: repo)", 2 );
                append( sb, "Deprecated. Use repositoryName instead.", 3 );
                append( sb, "", 0 );
                append( sb, "The directory that will be used for the dependencies, relative to assembleDirectory.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryLayout (Default: default)", 2 );
                append( sb, "The layout of the generated Maven repository. Supported types - \'default\' (Maven2) | \'legacy\' (Maven1) | \'flat\' (flat lib/ style). The style \'legacy\' is only supported if you are running under Maven 2.2.1 and before.", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryName (Default: repo)", 2 );
                append( sb, "Path (relative to assembleDirectory) of the desired output repository.", 3 );
                append( sb, "", 0 );

                append( sb, "useTimestampInSnapshotFileName (Default: true)", 2 );
                append( sb, "For those snapshots downloaded from a remote repo, replace the timestamp part with \'SNAPSHOT\' instead.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generate-daemons".equals( goal ) )
        {
            append( sb, "appassembler:generate-daemons", 0 );
            append( sb, "Generates JSW based daemon wrappers.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "The base directory of the project.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${basedir}", 3 );
                append( sb, "", 0 );

                append( sb, "configurationDirectory (Default: etc)", 2 );
                append( sb, "The name of the target directory for configuration files. Prior to version 1.7 this value defaults to \'conf\' for assemble goal and \'etc\' for generate-daemons", 3 );
                append( sb, "", 0 );

                append( sb, "configurationSourceDirectory (Default: src/main/config)", 2 );
                append( sb, "The name of the source directory for configuration files.", 3 );
                append( sb, "", 0 );

                append( sb, "copyConfigurationDirectory (Default: false)", 2 );
                append( sb, "If the source configuration directory should be copied to the configured configurationDirectory.", 3 );
                append( sb, "", 0 );

                append( sb, "daemons", 2 );
                append( sb, "Set of Daemons to generate.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "defaultJvmSettings", 2 );
                append( sb, "JvmSettings describing min/max memory and stack size, system properties and extra arguments.", 3 );
                append( sb, "", 0 );

                append( sb, "endorsedDir", 2 );
                append( sb, "Location under base directory where all of files non-recursively are added before the generated classpath. Java 6+ only since it uses wildcard classpath format. This is a convenient way to have user to add artifacts that not possible to be part of final assembly such as LGPL/GPL artifacts", 3 );
                append( sb, "", 0 );

                append( sb, "environmentSetupFileName", 2 );
                append( sb, "Setup file in $BASEDIR/bin to be called prior to execution.\nNote: only for the jsw platform. If this optional environment file also sets up WRAPPER_CONF_OVERRIDES variable, it will be passed into JSW native launcher\'s command line arguments to override wrapper.conf\'s properties. See http://wrapper.tanukisoftware.com/doc/english/props-command-line.html for details.\n", 3 );
                append( sb, "", 0 );

                append( sb, "externalDeltaPackDirectory", 2 );
                append( sb, "Use this option to override the current built-in delta pack binary. You will need to unpack your delta pack version to a known location set by this option", 3 );
                append( sb, "Expression: ${externalDeltaPackDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "generateRepository (Default: true)", 2 );
                append( sb, "Set to false to skip repository generation.", 3 );
                append( sb, "", 0 );

                append( sb, "licenseHeaderFile", 2 );
                append( sb, "You can define a license header file which will be used instead the default header in the generated scripts.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFileNameMapping", 2 );
                append( sb, "The file name mapping to use when copying libraries to the repository. If no file mapping is set (default) the files are copied with their standard names.\nNote: if you use this parameter, then the useTimestampInSnapshotFileName parameter will be ignored.\n", 3 );
                append( sb, "", 0 );

                append( sb, "preWrapperConf", 2 );
                append( sb, "Use this option to pre insert a content of a known file into the generated wrapper config file. For example: $include ../conf/another-wrapper.conf", 3 );
                append( sb, "Expression: ${preWrapperConf}", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryLayout (Default: default)", 2 );
                append( sb, "The layout of the generated Maven repository. Supported types - \'default\' (Maven2) | \'legacy\' (Maven1) | \'flat\' (flat lib/ style). The style \'legacy\' is only supported if you are running under Maven 2.2.1 and before.", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryName (Default: lib)", 2 );
                append( sb, "Path (relative to assembleDirectory) of the desired output repository.", 3 );
                append( sb, "", 0 );

                append( sb, "target (Default: ${project.build.directory}/generated-resources/appassembler)", 2 );
                append( sb, "Target directory for generated daemons.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "unixScriptTemplate", 2 );
                append( sb, "The unix template of the generated script. It can be a file or resource path. If not given, an internal one is used. Use with care since it is not guaranteed to be compatible with new plugin release.", 3 );
                append( sb, "Expression: ${unixScriptTemplate}", 3 );
                append( sb, "", 0 );

                append( sb, "useDaemonIdAsWrapperConfName (Default: false)", 2 );
                append( sb, "When enable, name wrapper configuration file as wrapper-${daemon.id}.conf", 3 );
                append( sb, "", 0 );

                append( sb, "useTimestampInSnapshotFileName (Default: true)", 2 );
                append( sb, "For those snapshots downloaded from a remote repo, replace the timestamp part with \'SNAPSHOT\' instead.", 3 );
                append( sb, "", 0 );

                append( sb, "useWildcardClassPath (Default: false)", 2 );
                append( sb, "Sometimes it happens that you have many dependencies which means in other words having a very long classpath. And sometimes the classpath becomes too long (in particular on Windows based platforms). This option can help in such situation. If you activate that your classpath contains only a classpath wildcard (REPO/*). But be aware that this works only in combination with Java 1.6 and above and with repositoryLayout flat. Otherwise this configuration will not work.", 3 );
                append( sb, "", 0 );

                append( sb, "windowsScriptTemplate", 2 );
                append( sb, "The windows template of the generated script. It can be a file or resource path. If not given, an internal one is used. Use with care since it is not guaranteed to be compatible with new plugin release.", 3 );
                append( sb, "Expression: ${windowsScriptTemplate}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "appassembler:help", 0 );
            append( sb, "Display help information on appassembler-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0appassembler:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
