package org.codehaus.mojo.appassembler.daemon;

/*
 * The MIT License
 *
 * Copyright (c) 2006-2012, The Codehaus
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/**
 * @author <a href="mailto:trygvis@inamo.no">Trygve Laugst&oslash;l</a>
 * @version $Id: DaemonGeneratorException.java 20469 2015-03-18 06:12:15Z dantran $
 */
public class DaemonGeneratorException
    extends Exception
{
    /**
     *
     */
    private static final long serialVersionUID = 6989317744526360832L;

    /**
     * Exception with message.
     *
     * @param message The message for the execption.
     */
    public DaemonGeneratorException( String message )
    {
        super( message );
    }

    /**
     * The exception with an appropriate message and the cause of the failure.
     *
     * @param message The message to show.
     * @param cause The root cause.
     */
    public DaemonGeneratorException( String message, Throwable cause )
    {
        super( message, cause );
    }
}
