/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.Daemon;
import org.codehaus.mojo.appassembler.JvmSettings;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorService;
import org.codehaus.plexus.util.StringUtils;

public class GenerateDaemonsMojo
extends AbstractMojo {
    private Set daemons;
    private JvmSettings defaultJvmSettings;
    private File basedir;
    private File target;
    private MavenProject project;
    private ArtifactRepository localRepository;
    private DaemonGeneratorService daemonGeneratorService;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Iterator it = this.daemons.iterator();
            while (it.hasNext()) {
                Daemon daemon = (Daemon)it.next();
                File descriptor = null;
                if (!StringUtils.isEmpty((String)daemon.getDescriptor())) {
                    descriptor = new File(this.basedir, daemon.getDescriptor());
                }
                org.codehaus.mojo.appassembler.model.JvmSettings modelJvmSettings = null;
                if (this.defaultJvmSettings != null) {
                    modelJvmSettings = this.convertJvmSettings(this.defaultJvmSettings);
                }
                org.codehaus.mojo.appassembler.model.Daemon modelDaemon = new org.codehaus.mojo.appassembler.model.Daemon();
                modelDaemon.setId(daemon.getId());
                modelDaemon.setMainClass(daemon.getMainClass());
                modelDaemon.setCommandLineArguments(daemon.getCommandLineArguments());
                if (daemon.getJvmSettings() != null) {
                    modelDaemon.setJvmSettings(this.convertJvmSettings(daemon.getJvmSettings()));
                } else {
                    modelDaemon.setJvmSettings(modelJvmSettings);
                }
                Iterator it2 = daemon.getPlatforms().iterator();
                while (it2.hasNext()) {
                    String platform = (String)it2.next();
                    File output = new File(new File(this.target, "generated-resources"), platform);
                    this.daemonGeneratorService.generateDaemon(platform, descriptor, modelDaemon, output, this.project, this.localRepository);
                }
            }
        }
        catch (DaemonGeneratorException e) {
            throw new MojoExecutionException("Error while generating daemon.", (Exception)e);
        }
    }

    private org.codehaus.mojo.appassembler.model.JvmSettings convertJvmSettings(JvmSettings jvmSettings) {
        org.codehaus.mojo.appassembler.model.JvmSettings modelJvmSettings = new org.codehaus.mojo.appassembler.model.JvmSettings();
        modelJvmSettings.setInitialMemorySize(jvmSettings.getInitialMemorySize());
        modelJvmSettings.setMaxMemorySize(jvmSettings.getMaxMemorySize());
        modelJvmSettings.setMaxStackSize(jvmSettings.getMaxStackSize());
        return modelJvmSettings;
    }
}

