/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.repository.layout.LegacyRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.appassembler.repository.FlatRepositoryLayout;

public class CreateRepositoryMojo
extends AbstractMojo {
    private File assembleDirectory;
    private String repoPath;
    private String repositoryLayout;
    private Set artifacts;
    private ArtifactRepository localRepository;
    private String artifactFinalName;
    private Artifact projectArtifact;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactInstaller artifactInstaller;
    private ArtifactRepository artifactRepository;
    private ArtifactRepositoryLayout artifactRepositoryLayout;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.repositoryLayout == null || this.repositoryLayout.equals("default")) {
            this.artifactRepositoryLayout = new DefaultRepositoryLayout();
        } else if (this.repositoryLayout.equals("legacy")) {
            this.artifactRepositoryLayout = new LegacyRepositoryLayout();
        } else if (this.repositoryLayout.equals("flat")) {
            this.artifactRepositoryLayout = new FlatRepositoryLayout();
        } else {
            throw new MojoFailureException("Unknown repository layout '" + this.repositoryLayout + "'.");
        }
        this.artifactRepository = this.artifactRepositoryFactory.createDeploymentArtifactRepository("appassembler", "file://" + this.assembleDirectory.getAbsolutePath() + "/" + this.repoPath, this.artifactRepositoryLayout, false);
        this.installArtifact(this.projectArtifact);
        Iterator it = this.artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            this.installArtifact(artifact);
        }
    }

    private void installArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            artifact.isSnapshot();
            this.artifactInstaller.install(artifact.getFile(), artifact, this.artifactRepository);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Failed to copy artifact.", (Exception)((Object)e));
        }
    }
}

