/*
 * $Id$
 */

package org.codehaus.mojo.antlr.options;

/**
 * A Grammar parameter.
 * 
 * @version $Revision$ $Date$
 */
public class Grammar implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field glib
     */
    private String glib;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof Grammar) )
        {
            return false;
        }
        
        Grammar that = (Grammar) other;
        boolean result = true;
        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        result = result && ( getGlib() == null ? that.getGlib() == null : getGlib().equals( that.getGlib() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get Colon separated or semicolon separated supergrammar file
     * names.
     */
    public String getGlib()
    {
        return this.glib;
    } //-- String getGlib() 

    /**
     * Get The grammar file name.
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        result = 37 * result + ( glib != null ? glib.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set Colon separated or semicolon separated supergrammar file
     * names.
     * 
     * @param glib
     */
    public void setGlib(String glib)
    {
        this.glib = glib;
    } //-- void setGlib(String) 

    /**
     * Set The grammar file name.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "name = '" );
        buf.append( getName() + "'" );
        buf.append( "\n" ); 
        buf.append( "glib = '" );
        buf.append( getGlib() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
