/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xsd;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.inject.Named;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.xsd.XsdModelHelper;
import org.codehaus.modello.plugin.xsd.metadata.XsdClassMetadata;
import org.codehaus.modello.plugins.xml.AbstractXmlGenerator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

@Named(value="xsd")
public class XsdGenerator
extends AbstractXmlGenerator {
    private static final String ANY_NAME = "*";
    protected static final String LS = System.getProperty("line.separator");

    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateXsd(parameters);
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating xsd.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateXsd(Properties parameters) throws IOException, ModelloException {
        Model objectModel = this.getModel();
        File directory = this.getOutputDirectory();
        if (this.isPackageWithVersion()) {
            directory = new File(directory, this.getGeneratedVersion().toString());
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String xsdFileName = parameters.getProperty("modello.output.xsd.file");
        boolean enforceMandatoryElements = Boolean.parseBoolean(parameters.getProperty("modello.xsd.enforce.mandatory.element"));
        File f = new File(directory, objectModel.getId() + "-" + this.getGeneratedVersion() + ".xsd");
        if (xsdFileName != null) {
            f = new File(directory, xsdFileName);
        }
        try (XmlStreamWriter writer = new XmlStreamWriter(f);){
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
            writer.append("<?xml version=\"1.0\"?>").write(LS);
            this.initHeader((XMLWriter)w);
            w.startElement("xs:schema");
            w.addAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
            w.addAttribute("elementFormDefault", "qualified");
            ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
            String namespace = XsdModelHelper.getNamespace(root.getModel(), this.getGeneratedVersion());
            w.addAttribute("xmlns", namespace);
            String targetNamespace = XsdModelHelper.getTargetNamespace(root.getModel(), this.getGeneratedVersion(), namespace);
            if (StringUtils.isNotBlank((String)targetNamespace)) {
                w.addAttribute("targetNamespace", targetNamespace);
            }
            w.startElement("xs:element");
            String tagName = this.resolveTagName(root);
            w.addAttribute("name", tagName);
            w.addAttribute("type", root.getName());
            XsdGenerator.writeClassDocumentation((XMLWriter)w, root);
            w.endElement();
            int initialCapacity = objectModel.getClasses(this.getGeneratedVersion()).size();
            this.writeComplexTypeDescriptor((XMLWriter)w, objectModel, root, new HashSet<ModelClass>(initialCapacity), enforceMandatoryElements);
            w.endElement();
        }
    }

    private static void writeClassDocumentation(XMLWriter w, ModelClass modelClass) {
        XsdGenerator.writeDocumentation(w, modelClass.getVersionRange().toString(), modelClass.getDescription());
    }

    private static void writeFieldDocumentation(XMLWriter w, ModelField field) {
        XsdGenerator.writeDocumentation(w, field.getVersionRange().toString(), field.getDescription());
    }

    private static void writeDocumentation(XMLWriter w, String version, String description) {
        if (version != null || description != null) {
            w.startElement("xs:annotation");
            if (version != null) {
                w.startElement("xs:documentation");
                w.addAttribute("source", "version");
                w.writeText(version);
                w.endElement();
            }
            if (description != null) {
                w.startElement("xs:documentation");
                w.addAttribute("source", "description");
                w.writeText(description);
                w.endElement();
            }
            w.endElement();
        }
    }

    private void writeComplexTypeDescriptor(XMLWriter w, Model objectModel, ModelClass modelClass, Set<ModelClass> written, boolean enforceMandatoryElements) {
        written.add(modelClass);
        w.startElement("xs:complexType");
        w.addAttribute("name", modelClass.getName());
        List fields = this.getFieldsForXml(modelClass, this.getGeneratedVersion());
        ModelField contentField = this.getContentField(fields);
        boolean hasContentField = contentField != null;
        List attributeFields = this.getXmlAttributeFields(fields);
        fields.removeAll(attributeFields);
        if (hasContentField) {
            w.startElement("xs:simpleContent");
            w.startElement("xs:extension");
            w.addAttribute("base", XsdGenerator.getXsdType(contentField.getType()));
        }
        XsdGenerator.writeClassDocumentation(w, modelClass);
        HashSet<ModelClass> toWrite = new HashSet<ModelClass>();
        if (fields.size() > 0) {
            XsdClassMetadata xsdClassMetadata = (XsdClassMetadata)modelClass.getMetadata(XsdClassMetadata.ID);
            boolean compositorAll = "all".equals(xsdClassMetadata.getCompositor());
            if (!hasContentField) {
                if (compositorAll) {
                    w.startElement("xs:all");
                } else {
                    w.startElement("xs:sequence");
                }
            }
            for (ModelField field : fields) {
                XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
                String fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
                if (!hasContentField) {
                    if (fieldTagName.equals(ANY_NAME)) {
                        w.startElement("xs:any");
                        w.addAttribute("minOccurs", "0");
                        w.addAttribute("maxOccurs", "unbounded");
                        w.addAttribute("processContents", "skip");
                        w.endElement();
                        continue;
                    }
                    w.startElement("xs:element");
                    if (!enforceMandatoryElements || !field.isRequired()) {
                        w.addAttribute("minOccurs", "0");
                    }
                }
                String xsdType = XsdGenerator.getXsdType(field.getType());
                if ("Date".equals(field.getType()) && "long".equals(xmlFieldMetadata.getFormat())) {
                    xsdType = XsdGenerator.getXsdType("long");
                }
                if (!xmlFieldMetadata.isContent()) {
                    ModelAssociation association;
                    if (xsdType != null || "char".equals(field.getType()) || "Character".equals(field.getType())) {
                        w.addAttribute("name", fieldTagName);
                        if (xsdType != null) {
                            w.addAttribute("type", xsdType);
                        }
                        if (field.getDefaultValue() != null && field.getDefaultValue() != "\u0000") {
                            w.addAttribute("default", field.getDefaultValue());
                        }
                        XsdGenerator.writeFieldDocumentation(w, field);
                        if (xsdType == null) {
                            XsdGenerator.writeCharElement(w);
                        }
                    } else if (this.isInnerAssociation(field)) {
                        association = (ModelAssociation)field;
                        ModelClass fieldModelClass = objectModel.getClass(association.getTo(), this.getGeneratedVersion());
                        toWrite.add(fieldModelClass);
                        if (association.isManyMultiplicity()) {
                            XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                            if (xmlAssociationMetadata.isWrappedItems()) {
                                w.addAttribute("name", fieldTagName);
                                XsdGenerator.writeFieldDocumentation(w, field);
                                this.writeListElement(w, xmlFieldMetadata, xmlAssociationMetadata, field, fieldModelClass.getName());
                            } else {
                                if (compositorAll) {
                                    throw new IllegalStateException(field.getName() + " field is declared as xml.listStyle=\"flat\" then class " + modelClass.getName() + " MUST be declared as xsd.compositor=\"sequence\"");
                                }
                                w.addAttribute("name", this.resolveTagName(fieldTagName, xmlAssociationMetadata));
                                w.addAttribute("type", fieldModelClass.getName());
                                w.addAttribute("maxOccurs", "unbounded");
                                XsdGenerator.writeFieldDocumentation(w, field);
                            }
                        } else {
                            w.addAttribute("name", fieldTagName);
                            w.addAttribute("type", fieldModelClass.getName());
                            XsdGenerator.writeFieldDocumentation(w, field);
                        }
                    } else {
                        w.addAttribute("name", fieldTagName);
                        XsdGenerator.writeFieldDocumentation(w, field);
                        if (List.class.getName().equals(field.getType()) || Set.class.getName().equals(field.getType())) {
                            association = (ModelAssociation)field;
                            XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                            this.writeListElement(w, xmlFieldMetadata, xmlAssociationMetadata, field, XsdGenerator.getXsdType("String"));
                        } else if (Properties.class.getName().equals(field.getType()) || "DOM".equals(field.getType())) {
                            XsdGenerator.writePropertiesElement(w);
                        } else {
                            throw new IllegalStateException("Non-association field of a non-primitive type '" + field.getType() + "' for '" + field.getName() + "' in '" + modelClass.getName() + "' model class");
                        }
                    }
                }
                if (hasContentField) continue;
                w.endElement();
            }
            if (!hasContentField) {
                w.endElement();
            }
        }
        for (ModelField field : attributeFields) {
            XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            w.startElement("xs:attribute");
            String xsdType = XsdGenerator.getXsdType(field.getType());
            String tagName = this.resolveTagName(field, xmlFieldMetadata);
            w.addAttribute("name", tagName);
            if (xsdType != null) {
                w.addAttribute("type", xsdType);
            }
            if (field.getDefaultValue() != null) {
                w.addAttribute("default", field.getDefaultValue());
            }
            w.addAttribute("use", field.isRequired() ? "required" : "optional");
            XsdGenerator.writeFieldDocumentation(w, field);
            if ("char".equals(field.getType()) || "Character".equals(field.getType())) {
                XsdGenerator.writeCharElement(w);
            } else if (xsdType == null) {
                throw new IllegalStateException("Attribute field of a non-primitive type '" + field.getType() + "' for '" + field.getName() + "' in '" + modelClass.getName() + "' model class");
            }
            w.endElement();
        }
        if (hasContentField) {
            w.endElement();
            w.endElement();
        }
        w.endElement();
        for (ModelClass fieldModelClass : toWrite) {
            if (written.contains(fieldModelClass)) continue;
            this.writeComplexTypeDescriptor(w, objectModel, fieldModelClass, written, enforceMandatoryElements);
        }
    }

    private static void writeCharElement(XMLWriter w) {
        w.startElement("xs:simpleType");
        w.startElement("xs:restriction");
        w.addAttribute("base", "xs:string");
        w.startElement("xs:length");
        w.addAttribute("value", "1");
        w.addAttribute("fixed", "true");
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private static void writePropertiesElement(XMLWriter w) {
        w.startElement("xs:complexType");
        w.startElement("xs:sequence");
        w.startElement("xs:any");
        w.addAttribute("minOccurs", "0");
        w.addAttribute("maxOccurs", "unbounded");
        w.addAttribute("processContents", "skip");
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private void writeListElement(XMLWriter w, XmlFieldMetadata xmlFieldMetadata, XmlAssociationMetadata xmlAssociationMetadata, ModelField field, String type) {
        String fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
        String valuesTagName = this.resolveTagName(fieldTagName, xmlAssociationMetadata);
        w.startElement("xs:complexType");
        w.startElement("xs:sequence");
        if (valuesTagName.equals(ANY_NAME)) {
            w.startElement("xs:any");
            w.addAttribute("processContents", "skip");
        } else {
            w.startElement("xs:element");
            w.addAttribute("type", type);
            w.addAttribute("name", valuesTagName);
        }
        w.addAttribute("minOccurs", "0");
        w.addAttribute("maxOccurs", "unbounded");
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private static String getXsdType(String type) {
        if ("String".equals(type)) {
            return "xs:string";
        }
        if ("boolean".equals(type) || "Boolean".equals(type)) {
            return "xs:boolean";
        }
        if ("byte".equals(type) || "Byte".equals(type)) {
            return "xs:byte";
        }
        if ("short".equals(type) || "Short".equals(type)) {
            return "xs:short";
        }
        if ("int".equals(type) || "Integer".equals(type)) {
            return "xs:int";
        }
        if ("long".equals(type) || "Long".equals(type)) {
            return "xs:long";
        }
        if ("float".equals(type) || "Float".equals(type)) {
            return "xs:float";
        }
        if ("double".equals(type) || "Double".equals(type)) {
            return "xs:double";
        }
        if ("Date".equals(type)) {
            return "xs:dateTime";
        }
        return null;
    }
}

