/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xpp3;

import javax.inject.Named;
import org.codehaus.modello.model.ModelType;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.xpp3.Xpp3WriterGenerator;

@Named(value="xpp3-extended-writer")
public class Xpp3ExtendedWriterGenerator
extends Xpp3WriterGenerator {
    @Override
    protected boolean isLocationTracking() {
        return true;
    }

    @Override
    protected void prepareLocationTracking(JClass jClass) {
        String packageName = this.locationTracker.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
        jClass.addImport(packageName + '.' + this.locationTracker.getName() + "Tracker");
        this.addModelImport(jClass, (ModelType)this.locationTracker, null);
        this.createLocationTrackingMethod(jClass);
        if (this.requiresDomSupport && this.domAsXpp3) {
            this.createXpp3DomToSerializerMethod(jClass);
        }
    }

    private void createLocationTrackingMethod(JClass jClass) {
        JMethod method = new JMethod("writeLocationTracking");
        method.getModifiers().makePrivate();
        method.addParameter(new JParameter(new JType(this.locationTracker.getName() + "Tracker"), "locationTracker"));
        method.addParameter(new JParameter((JType)new JClass("Object"), "key"));
        method.addParameter(new JParameter((JType)new JClass("XmlSerializer"), "serializer"));
        method.addException(new JClass("java.io.IOException"));
        JSourceCode sc = method.getSourceCode();
        sc.add(this.locationTracker.getName() + " location = ( locationTracker == null ) ? null : locationTracker.getLocation( key );");
        sc.add("if ( location != null )");
        sc.add("{");
        sc.addIndented("serializer.comment( toString( location ) );");
        sc.add("}");
        jClass.addMethod(method);
        JField field = new JField(new JType(this.locationTracker.getName() + ".StringFormatter"), "stringFormatter");
        field.getModifiers().makeProtected();
        jClass.addField(field);
        method = new JMethod("setStringFormatter", null, null);
        method.addParameter(new JParameter(new JType(this.locationTracker.getName() + ".StringFormatter"), "stringFormatter"));
        sc = method.getSourceCode();
        sc.add("this.stringFormatter = stringFormatter;");
        jClass.addMethod(method);
        method = new JMethod("toString", new JType("String"), null);
        method.getModifiers().makeProtected();
        method.addParameter(new JParameter(new JType(this.locationTracker.getName()), "location"));
        sc = method.getSourceCode();
        sc.add("if ( stringFormatter != null )");
        sc.add("{");
        sc.addIndented("return stringFormatter.toString( location );");
        sc.add("}");
        sc.add("return ' ' + " + (this.sourceTracker == null ? "" : "location.getSource().toString() + ':' + ") + "location.getLineNumber() + ' ';");
        jClass.addMethod(method);
    }

    private void createXpp3DomToSerializerMethod(JClass jClass) {
        JMethod method = new JMethod("writeXpp3DomToSerializer");
        method.getModifiers().makeProtected();
        method.addParameter(new JParameter((JType)new JClass("Xpp3Dom"), "dom"));
        method.addParameter(new JParameter((JType)new JClass("XmlSerializer"), "serializer"));
        method.addException(new JClass("java.io.IOException"));
        JSourceCode sc = method.getSourceCode();
        sc.add("serializer.startTag( NAMESPACE, dom.getName() );");
        sc.add("");
        sc.add("String[] attributeNames = dom.getAttributeNames();");
        sc.add("for ( String attributeName : attributeNames )");
        sc.add("{");
        sc.addIndented("serializer.attribute( NAMESPACE, attributeName, dom.getAttribute( attributeName ) );");
        sc.add("}");
        sc.add("for ( Xpp3Dom aChild : dom.getChildren() )");
        sc.add("{");
        sc.addIndented("writeXpp3DomToSerializer( aChild, serializer );");
        sc.add("}");
        sc.add("");
        sc.add("String value = dom.getValue();");
        sc.add("if ( value != null )");
        sc.add("{");
        sc.addIndented("serializer.text( value );");
        sc.add("}");
        sc.add("");
        sc.add("serializer.endTag( NAMESPACE, dom.getName() );");
        sc.add("");
        sc.add("if ( dom.getInputLocation() != null && dom.getChildCount() == 0 )");
        sc.add("{");
        sc.addIndented("serializer.comment( toString( (InputLocation) dom.getInputLocation() ) );");
        sc.add("}");
        jClass.addMethod(method);
    }
}

