/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.velocity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.modello.ModelloRuntimeException;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.Version;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlClassMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;
import org.codehaus.plexus.util.StringUtils;

public class Helper {
    private final Version version;

    public Helper(Version version) {
        this.version = version;
    }

    public String capitalise(String str) {
        return StringUtils.isEmpty((String)str) ? str : Character.toTitleCase(str.charAt(0)) + str.substring(1);
    }

    public String uncapitalise(String str) {
        return StringUtils.isEmpty((String)str) ? str : Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public String singular(String str) {
        return AbstractModelloGenerator.singular((String)str);
    }

    public List<ModelClass> ancestors(ModelClass clazz) {
        ArrayList<ModelClass> ancestors = new ArrayList<ModelClass>();
        ModelClass cl = clazz;
        while (cl != null) {
            ancestors.add(0, cl);
            cl = cl.getSuperClass() != null ? cl.getModel().getClass(cl.getSuperClass(), this.version) : null;
        }
        return ancestors;
    }

    public XmlClassMetadata xmlClassMetadata(ModelClass clazz) {
        return (XmlClassMetadata)clazz.getMetadata(XmlClassMetadata.ID);
    }

    public XmlFieldMetadata xmlFieldMetadata(ModelField field) {
        return (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
    }

    public XmlAssociationMetadata xmAssociationMetadata(ModelField field) {
        return (XmlAssociationMetadata)((ModelAssociation)field).getAssociationMetadata(XmlAssociationMetadata.ID);
    }

    public boolean isFlatItems(ModelField field) {
        return field instanceof ModelAssociation && this.xmAssociationMetadata(field).isFlatItems();
    }

    public List<ModelField> xmlFields(ModelClass modelClass) {
        ArrayList<ModelClass> classes = new ArrayList<ModelClass>();
        while (modelClass != null) {
            classes.add(modelClass);
            String superClass = modelClass.getSuperClass();
            if (superClass != null) {
                modelClass = modelClass.getModel().getClass(superClass, this.version, true);
                continue;
            }
            modelClass = null;
        }
        ArrayList<Object> fields = new ArrayList<ModelField>();
        for (int i = classes.size() - 1; i >= 0; --i) {
            modelClass = (ModelClass)classes.get(i);
            Iterator parentIter = fields.iterator();
            fields = new ArrayList();
            for (ModelField field : modelClass.getFields(this.version)) {
                XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
                if (xmlFieldMetadata.isTransient()) continue;
                if (xmlFieldMetadata.getInsertParentFieldsUpTo() != null) {
                    boolean found = false;
                    while (!found && parentIter.hasNext()) {
                        ModelField parentField = (ModelField)parentIter.next();
                        fields.add(parentField);
                        found = parentField.getName().equals(xmlFieldMetadata.getInsertParentFieldsUpTo());
                    }
                    if (!found) {
                        throw new ModelloRuntimeException("parent field not found: class " + modelClass.getName() + " xml.insertParentFieldUpTo='" + xmlFieldMetadata.getInsertParentFieldsUpTo() + "'");
                    }
                }
                fields.add(field);
            }
            while (parentIter.hasNext()) {
                fields.add((ModelField)parentIter.next());
            }
        }
        return fields;
    }
}

