/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.store;

import java.io.File;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.Version;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.store.tool.JavaTool;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.velocity.VelocityComponent;

public abstract class AbstractVelocityModelloGenerator
extends AbstractModelloGenerator {
    private VelocityComponent velocity;

    protected static Context makeStubVelocityContext(Model model, Version version) {
        String packageName = AbstractVelocityModelloGenerator.getGeneratedPackage(model, version);
        return AbstractVelocityModelloGenerator.makeStubVelocityContext(model, version, packageName);
    }

    private static String getGeneratedPackage(Model model, Version version) {
        return model.getDefaultPackageName(false, version);
    }

    protected static Context makeStubVelocityContext(Model model, Version version, String packageName) {
        List classes = model.getClasses(version);
        HashMap<String, List> classFields = new HashMap<String, List>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            ModelClass modelClass = (ModelClass)it.next();
            List fields = modelClass.getFields(version);
            classFields.put(modelClass.getName(), fields);
        }
        VelocityContext context = new VelocityContext();
        context.put("version", (Object)version);
        context.put("model", (Object)model);
        context.put("classes", (Object)classes);
        context.put("classFields", classFields);
        context.put("javaTool", (Object)new JavaTool());
        context.put("package", (Object)packageName);
        return context;
    }

    protected void writeClass(String templateName, File basedir, String packageName, String className, Context context) throws ModelloException {
        File packageFile = new File(this.getOutputDirectory(), packageName.replace('.', File.separatorChar));
        File file = new File(packageFile, className + ".java");
        this.writeTemplate(templateName, file, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTemplate(String templateName, File file, Context context) throws ModelloException {
        Template template = this.getTemplate(templateName);
        if (template == null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                template = this.getTemplate(templateName);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        if (template == null) {
            throw new ModelloException("Could not find the template '" + templateName + "'.");
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new ModelloException("Error while creating parent directories for '" + file.getAbsolutePath() + "'.");
        }
        try {
            Writer writer = this.getEncoding() == null ? WriterFactory.newPlatformWriter((File)file) : WriterFactory.newWriter((File)file, (String)this.getEncoding());
            template.merge(context, writer);
            writer.close();
        }
        catch (Exception e) {
            throw new ModelloException("Error while generating code.", (Throwable)e);
        }
    }

    private Template getTemplate(String name) throws ModelloException {
        try {
            return this.velocity.getEngine().getTemplate(name);
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
        catch (ParseErrorException e) {
            throw new ModelloException("Could not parse the template '" + name + "'.", (Throwable)e);
        }
        catch (Exception e) {
            throw new ModelloException("Error while loading template '" + name + "'.", (Throwable)e);
        }
    }
}

