/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.stax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.modello.model.ModelAssociation;

class GeneratorNode {
    private final String to;
    private boolean referencableChildren;
    private List<GeneratorNode> children = new LinkedList<GeneratorNode>();
    private ModelAssociation association;
    private boolean referencable;
    private Map<String, GeneratorNode> nodesWithReferencableChildren = new HashMap<String, GeneratorNode>();
    private List<String> chain;

    GeneratorNode(String to, GeneratorNode parent) {
        this(to, parent, null);
    }

    GeneratorNode(ModelAssociation association, GeneratorNode parent) {
        this(association.getTo(), parent, association);
    }

    private GeneratorNode(String to, GeneratorNode parent, ModelAssociation association) {
        this.to = to;
        this.association = association;
        this.chain = parent != null ? new ArrayList<String>(parent.getChain()) : new ArrayList();
        this.chain.add(to);
    }

    public boolean isReferencableChildren() {
        return this.referencableChildren;
    }

    public void setReferencableChildren(boolean referencableChildren) {
        this.referencableChildren = referencableChildren;
    }

    public void addChild(GeneratorNode child) {
        this.children.add(child);
        if (child.referencableChildren) {
            this.nodesWithReferencableChildren.put(child.to, child);
        }
    }

    public List<GeneratorNode> getChildren() {
        return this.children;
    }

    public String toString() {
        return "to = " + this.to + "; referencableChildren = " + this.referencableChildren + "; children = " + this.children;
    }

    public String getTo() {
        return this.to;
    }

    public ModelAssociation getAssociation() {
        return this.association;
    }

    public void setAssociation(ModelAssociation association) {
        this.association = association;
    }

    public void setReferencable(boolean referencable) {
        this.referencable = referencable;
    }

    public boolean isReferencable() {
        return this.referencable;
    }

    public Map<String, GeneratorNode> getNodesWithReferencableChildren() {
        return this.nodesWithReferencableChildren;
    }

    public void addNodesWithReferencableChildren(Map<String, GeneratorNode> allChildNodes) {
        this.nodesWithReferencableChildren.putAll(allChildNodes);
    }

    public List<String> getChain() {
        return this.chain;
    }
}

