/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.jackson;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.jackson.AbstractJacksonGenerator;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JConstructor;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;

@Named(value="jackson-writer")
public class JacksonWriterGenerator
extends AbstractJacksonGenerator {
    private boolean requiresDomSupport;

    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        this.requiresDomSupport = true;
        try {
            this.generateJacksonWriter();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating JSON Jackson Writer.", (Throwable)ex);
        }
    }

    private void generateJacksonWriter() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = objectModel.getDefaultPackageName(this.isPackageWithVersion(), this.getGeneratedVersion()) + ".io.jackson";
        String marshallerName = this.getFileName("JacksonWriter");
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, marshallerName);
        JClass jClass = new JClass(packageName + '.' + marshallerName);
        this.initHeader(jClass);
        jClass.addImport("com.fasterxml.jackson.core.JsonFactory");
        jClass.addImport("com.fasterxml.jackson.core.JsonGenerator");
        jClass.addImport("com.fasterxml.jackson.core.JsonGenerator.Feature");
        jClass.addImport("java.io.IOException");
        jClass.addImport("java.io.OutputStream");
        jClass.addImport("java.io.OutputStreamWriter");
        jClass.addImport("java.io.Writer");
        this.addModelImports(jClass, null);
        JField factoryField = new JField((JType)new JClass("JsonFactory"), "factory");
        factoryField.getModifiers().setFinal(true);
        factoryField.setInitString("new JsonFactory()");
        jClass.addField(factoryField);
        String root = objectModel.getRoot(this.getGeneratedVersion());
        JConstructor jacksonWriterConstructor = new JConstructor(jClass);
        JSourceCode sc = jacksonWriterConstructor.getSourceCode();
        sc.add("factory.enable( Feature.AUTO_CLOSE_JSON_CONTENT );");
        sc.add("factory.enable( Feature.AUTO_CLOSE_TARGET );");
        sc.add("factory.enable( Feature.ESCAPE_NON_ASCII );");
        sc.add("factory.enable( Feature.FLUSH_PASSED_TO_STREAM );");
        sc.add("factory.enable( Feature.QUOTE_FIELD_NAMES );");
        sc.add("factory.enable( Feature.QUOTE_NON_NUMERIC_NUMBERS );");
        sc.add("factory.disable( Feature.WRITE_NUMBERS_AS_STRINGS );");
        jClass.addConstructor(jacksonWriterConstructor);
        this.writeAllClasses(objectModel, jClass);
        if (this.requiresDomSupport) {
            jClass.addImport("com.fasterxml.jackson.databind.ObjectMapper");
            sc.add("factory.setCodec( new ObjectMapper() );");
        }
        JMethod marshall = new JMethod("write");
        String rootElementParameterName = JacksonWriterGenerator.uncapitalise((String)root);
        marshall.addParameter(new JParameter((JType)new JClass("Writer"), "writer"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("IOException"));
        sc = marshall.getSourceCode();
        sc.add("JsonGenerator generator = factory.createGenerator( writer );");
        sc.add("generator.useDefaultPrettyPrinter();");
        sc.add("write" + root + "( " + rootElementParameterName + ", generator );");
        sc.add("generator.close();");
        jClass.addMethod(marshall);
        marshall = new JMethod("write");
        marshall.addParameter(new JParameter((JType)new JClass("OutputStream"), "stream"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("IOException"));
        sc = marshall.getSourceCode();
        sc.add("write( new OutputStreamWriter( stream, " + rootElementParameterName + ".getModelEncoding() ), " + rootElementParameterName + " );");
        jClass.addMethod(marshall);
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void writeAllClasses(Model objectModel, JClass jClass) throws ModelloException {
        for (ModelClass clazz : this.getClasses(objectModel)) {
            this.writeClass(clazz, jClass);
        }
    }

    private void writeClass(ModelClass modelClass, JClass jClass) throws ModelloException {
        String className = modelClass.getName();
        String uncapClassName = JacksonWriterGenerator.uncapitalise((String)className);
        JMethod marshall = new JMethod("write" + className);
        marshall.addParameter(new JParameter((JType)new JClass(className), uncapClassName));
        marshall.addParameter(new JParameter((JType)new JClass("JsonGenerator"), "generator"));
        marshall.addException(new JClass("IOException"));
        marshall.getModifiers().makePrivate();
        JSourceCode sc = marshall.getSourceCode();
        sc.add("generator.writeStartObject();");
        List modelFields = this.getFieldsForXml(modelClass, this.getGeneratedVersion());
        boolean useJava5 = this.hasJavaSourceSupport(5);
        for (ModelField field : modelFields) {
            XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            String fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
            String type = field.getType();
            String value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (field instanceof ModelAssociation) {
                ModelAssociation association = (ModelAssociation)field;
                if (association.isOneMultiplicity()) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.addIndented("generator.writeFieldName( \"" + fieldTagName + "\" );");
                    sc.addIndented("write" + association.getTo() + "( (" + association.getTo() + ") " + value + ", generator );");
                    sc.add("}");
                    continue;
                }
                XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                type = association.getType();
                String toType = association.getTo();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    sc.add("generator.writeArrayFieldStart( \"" + fieldTagName + "\" );");
                    if (useJava5) {
                        sc.add("for ( " + toType + " o : " + value + " )");
                    } else {
                        sc.add("for ( java.util.Iterator it = " + value + ".iterator(); it.hasNext(); )");
                    }
                    sc.add("{");
                    sc.indent();
                    if (!useJava5) {
                        sc.add(toType + " o = (" + toType + " ) it.next();");
                    }
                    if (this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        sc.add("write" + toType + "( o, generator );");
                    } else {
                        sc.add("generator.writeObject( o ); ");
                    }
                    sc.unindent();
                    sc.add("}");
                    sc.add("generator.writeEndArray();");
                    sc.unindent();
                    sc.add("}");
                    continue;
                }
                sc.add(this.getValueChecker(type, value, field));
                sc.add("{");
                sc.indent();
                if (xmlAssociationMetadata.isMapExplode()) {
                    sc.add("generator.writeArrayFieldStart( \"" + fieldTagName + "\" );");
                } else {
                    sc.add("generator.writeObjectFieldStart( \"" + fieldTagName + "\" );");
                }
                StringBuilder entryTypeBuilder = new StringBuilder("java.util.Map.Entry");
                if (useJava5) {
                    entryTypeBuilder.append('<');
                    if (association.getType().equals("java.util.Properties")) {
                        entryTypeBuilder.append("Object, Object");
                    } else {
                        entryTypeBuilder.append("String, ").append(association.getTo());
                    }
                    entryTypeBuilder.append('>');
                }
                if (useJava5) {
                    sc.add("for ( " + entryTypeBuilder + " entry : " + value + ".entrySet() )");
                } else {
                    sc.add("for ( java.util.Iterator it = " + value + ".entrySet().iterator(); it.hasNext(); )");
                }
                sc.add("{");
                sc.indent();
                if (!useJava5) {
                    sc.add(entryTypeBuilder + " entry = (" + entryTypeBuilder + ") it.next();");
                }
                sc.add("final String key = String.valueOf( entry.getKey() );");
                sc.add("final String value = String.valueOf( entry.getValue() );");
                if (xmlAssociationMetadata.isMapExplode()) {
                    sc.add("generator.writeStartObject();");
                    sc.add("generator.writeStringField( \"key\", key );");
                    sc.add("generator.writeStringField( \"value\", value );");
                    sc.add("generator.writeEndObject();");
                } else {
                    sc.add("generator.writeStringField( key, value );");
                }
                sc.unindent();
                sc.add("}");
                if (xmlAssociationMetadata.isMapExplode()) {
                    sc.add("generator.writeEndArray();");
                } else {
                    sc.add("generator.writeEndObject();");
                }
                sc.unindent();
                sc.add("}");
                continue;
            }
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            if ("DOM".equals(field.getType())) {
                if (this.domAsXpp3) {
                    this.getLogger().warn("Xpp3Dom not supported for " + modelClass.getName() + "#" + field.getName() + ", it will be treated as a regular Java Object.");
                }
                this.requiresDomSupport = true;
                sc.addIndented("generator.writeObjectField( \"" + fieldTagName + "\", " + value + " );");
            } else {
                sc.addIndented("generator.writeObjectField( \"" + fieldTagName + "\", " + value + " );");
            }
            sc.add("}");
        }
        sc.add("generator.writeEndObject();");
        jClass.addMethod(marshall);
    }
}

