package org.codehaus.modello.maven;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on modello-maven-plugin.<br/> Call <pre>  mvn modello:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Jun 11 00:06:02 CEST 2009
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.4.3)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.modello:modello-maven-plugin:1.0.2", 0 );
        append( sb, "", 0 );

        append( sb, "Modello Maven Plugin 1.0.2", 0 );
        append( sb, "Modello Maven Plugin enables the use of Modello in Maven builds.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 13 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "converters".equals( goal ) )
        {
            append( sb, "modello:converters", 0 );
            append( sb, "Creates classes that can convert between different versions of the model.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated Java beans.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "dom4j-reader".equals( goal ) )
        {
            append( sb, "modello:dom4j-reader", 0 );
            append( sb, "Creates a DOM4J reader from the model.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated DOM4J reader.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "dom4j-writer".equals( goal ) )
        {
            append( sb, "modello:dom4j-writer", 0 );
            append( sb, "Creates a DOM4J writer from the model.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated DOM4J reader.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generate".equals( goal ) )
        {
            append( sb, "modello:generate", 0 );
            append( sb, "ModelloGenerateMojo - A dynamic way to use generators and modello plugins.\n\nExample Usage:\n\n<plugin>\n<groupId>org.codehaus.modello</groupId>\n<artifactId>modello-maven-plugin</artifactId>\n<version>1.0-alpha-15-SNAPSHOT</version>\n<dependencies>\n<dependency>\n<groupId>org.codehaus.modello</groupId>\n<artifactId>modello-plugin-jpa</artifactId>\n<version>1.0.0-SNAPSHOT</version>\n</dependency>\n</dependencies>\n<configuration>\n<version>1.0.0</version>\n<packageWithVersion>false</packageWithVersion>\n<models>\n<model>src/main/mdo/project-model.xml</model>\n</models>\n</configuration>\n<executions>\n<execution>\n<id>java</id>\n<goals>\n<goal>generate</goal>\n</goals>\n<configuration>\n<generatorId>java</generatorId>\n</configuration>\n</execution>\n<execution>\n<id>jpa</id>\n<goals>\n<goal>generate</goal>\n</goals>\n<configuration>\n<generatorId>jpa-mapping</generatorId>\n</configuration>\n</execution>\n</executions>\n</plugin>\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "generatorId (Default: java)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated source files.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "modello:help", 0 );
            append( sb, "Display help information on modello-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0modello:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "java".equals( goal ) )
        {
            append( sb, "modello:java", 0 );
            append( sb, "Creates Java beans from the Modello model.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated Java beans.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jdom-writer".equals( goal ) )
        {
            append( sb, "modello:jdom-writer", 0 );
            append( sb, "Creates a jdom writer from the model that is capable of preserving element ordering and comments. In future it should also preserve whitespace.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated jdom writer.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "stax-reader".equals( goal ) )
        {
            append( sb, "modello:stax-reader", 0 );
            append( sb, "Creates an StAX reader from the model.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated StAX reader.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "stax-writer".equals( goal ) )
        {
            append( sb, "modello:stax-writer", 0 );
            append( sb, "Creates an StAX writer from the model.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated StAX writer.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "xdoc".equals( goal ) )
        {
            append( sb, "modello:xdoc", 0 );
            append( sb, "Creates documentation for the model in xdoc format.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "firstVersion", 2 );
                append( sb, "The first version of the model. This is used to decide whether or not to show the since column. If this is not specified, it defaults to the version of the model, which in turn means that the since column will not be shown.", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );

                append( sb, "xdocFileName", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "xpp3-reader".equals( goal ) )
        {
            append( sb, "modello:xpp3-reader", 0 );
            append( sb, "Creates an XPP3 reader from the model.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated XPP reader.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "xpp3-writer".equals( goal ) )
        {
            append( sb, "modello:xpp3-writer", 0 );
            append( sb, "Creates an XPP3 writer from the model.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated XPP writer.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "xsd".equals( goal ) )
        {
            append( sb, "modello:xsd", 0 );
            append( sb, "Creates an XML schema from the model.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir", 2 );
                append( sb, "Base directory of the project.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The encoding to use when generating Java source files.", 3 );
                append( sb, "", 0 );

                append( sb, "models", 2 );
                append( sb, "List of relative paths to mdo files containing the models.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory of the generated XML Schema. Hint: if you want to publish the schema automatically with the site, configure this parameter to ${basedir}/target/generated-site/resources/xsd.", 3 );
                append( sb, "", 0 );

                append( sb, "packageWithVersion (Default: false)", 2 );
                append( sb, "True if the generated package names should include the version.", 3 );
                append( sb, "", 0 );

                append( sb, "packagedVersions", 2 );
                append( sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "The Maven project instance for the executing project.", 3 );
                append( sb, "", 0 );

                append( sb, "useJava5 (Default: false)", 2 );
                append( sb, "Generate Java 5 sources, with generic collections.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the model we will be working on.", 3 );
                append( sb, "", 0 );

                append( sb, "xsdFileName", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
