/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.core.ModelloCore;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelValidationException;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractModelloGeneratorMojo
extends AbstractMojo {
    private String basedir;
    private String model;
    private String version;
    private boolean packageWithVersion;
    private ModelloCore modelloCore;
    private MavenProject project;
    private List packagedVersions = Collections.EMPTY_LIST;

    protected abstract String getGeneratorType();

    public abstract File getOutputDirectory();

    protected boolean producesCompilableResult() {
        return true;
    }

    protected Properties createParameters() {
        return new Properties();
    }

    protected void customizeParameters(Properties parameters) {
    }

    public void execute() throws MojoExecutionException {
        String outputDirectory = this.getOutputDirectory().getAbsolutePath();
        this.getLog().info((CharSequence)("outputDirectory: " + outputDirectory));
        Properties parameters = this.createParameters();
        parameters.setProperty("modello.output.directory", outputDirectory);
        parameters.setProperty("modello.version", this.version);
        parameters.setProperty("modello.package.with.version", Boolean.toString(this.packageWithVersion));
        parameters.setProperty("modello.all.versions", StringUtils.join(this.packagedVersions.iterator(), (String)","));
        this.customizeParameters(parameters);
        try {
            FileReader fileReader = new FileReader(new File(this.basedir, this.model));
            Model model = this.modelloCore.loadModel((Reader)fileReader);
            this.getLog().info((CharSequence)("Generating current version: " + this.version));
            this.modelloCore.generate(model, this.getGeneratorType(), parameters);
            Iterator i = this.packagedVersions.iterator();
            while (i.hasNext()) {
                String version = (String)i.next();
                parameters.setProperty("modello.version", version);
                parameters.setProperty("modello.package.with.version", Boolean.toString(true));
                this.getLog().info((CharSequence)("Generating packaged version: " + version));
                this.modelloCore.generate(model, this.getGeneratorType(), parameters);
            }
            if (this.producesCompilableResult() && this.project != null) {
                this.project.addCompileSourceRoot(outputDirectory);
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Couldn't find file.", (Exception)e);
        }
        catch (ModelloException e) {
            throw new MojoExecutionException("Error generating.", (Exception)((Object)e));
        }
        catch (ModelValidationException e) {
            throw new MojoExecutionException("Error generating.", (Exception)((Object)e));
        }
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean getPackageWithVersion() {
        return this.packageWithVersion;
    }

    public void setPackageWithVersion(boolean packageWithVersion) {
        this.packageWithVersion = packageWithVersion;
    }

    public ModelloCore getModelloCore() {
        return this.modelloCore;
    }

    public void setModelloCore(ModelloCore modelloCore) {
        this.modelloCore = modelloCore;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setPackagedVersions(List packagedVersions) {
        this.packagedVersions = Collections.unmodifiableList(packagedVersions);
    }
}

