/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.mutable;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.codehaus.httpcache4j.Conditionals;
import org.codehaus.httpcache4j.Tag;

public class MutableConditionals {
    private Conditionals conditionals;

    public MutableConditionals() {
        this(new Conditionals());
    }

    MutableConditionals(Conditionals conditionals) {
        this.conditionals = Objects.requireNonNull(conditionals, "Conditionals may not be null");
    }

    public void addIfMatch(Tag tag) {
        this.conditionals = this.conditionals.addIfMatch(tag);
    }

    public void addIfNoneMatch(Tag tag) {
        this.conditionals = this.conditionals.addIfNoneMatch(tag);
    }

    public void ifModifiedSince(LocalDateTime time) {
        this.conditionals = this.conditionals.ifModifiedSince(time);
    }

    public void ifUnModifiedSince(LocalDateTime time) {
        this.conditionals = this.conditionals.ifUnModifiedSince(time);
    }

    public List<Tag> getMatch() {
        return this.conditionals.getMatch();
    }

    public List<Tag> getNoneMatch() {
        return this.conditionals.getNoneMatch();
    }

    public LocalDateTime getModifiedSince() {
        return this.conditionals.getModifiedSince().orElse(null);
    }

    public LocalDateTime getUnModifiedSince() {
        return this.conditionals.getUnModifiedSince().orElse(null);
    }

    public boolean isUnconditional() {
        return this.conditionals.isUnconditional();
    }

    public Conditionals toConditionals() {
        return this.conditionals;
    }
}

