/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.BasicAuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.DefaultSchemeRegistry;
import org.codehaus.httpcache4j.auth.DigestAuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.NullAuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.SchemeRegistry;
import org.codehaus.httpcache4j.util.Pair;

class AuthenticatorBase {
    private final List<AuthenticatorStrategy> strategies;
    protected final SchemeRegistry registry = new DefaultSchemeRegistry();

    public AuthenticatorBase() {
        this(AuthenticatorBase.defaultStrategies());
    }

    public AuthenticatorBase(List<AuthenticatorStrategy> strategies) {
        ArrayList<AuthenticatorStrategy> s = new ArrayList<AuthenticatorStrategy>(strategies);
        this.strategies = Collections.unmodifiableList(s);
    }

    protected static List<AuthenticatorStrategy> defaultStrategies() {
        return Arrays.asList(new DigestAuthenticatorStrategy(), new BasicAuthenticatorStrategy());
    }

    protected Pair<AuthenticatorStrategy, AuthScheme> select(List<AuthScheme> authScheme) {
        AuthenticatorStrategy selected = null;
        AuthScheme selectedScheme = null;
        block0: for (AuthenticatorStrategy strategy : this.strategies) {
            for (AuthScheme scheme : authScheme) {
                if (!strategy.supports(scheme)) continue;
                selected = strategy;
                selectedScheme = scheme;
                continue block0;
            }
        }
        if (selected == null) {
            selected = new NullAuthenticatorStrategy();
        }
        return Pair.of(selected, selectedScheme);
    }

    public boolean canAuthenticatePreemptively(HTTPHost host) {
        return this.registry.matches(host);
    }

    protected List<AuthScheme> toAuthSchemes(HTTPResponse response, String name) {
        List<Header> authenticateHeader = response.getHeaders().getHeaders(name);
        return authenticateHeader.stream().flatMap(h -> h.getDirectives().stream()).map(AuthScheme::new).collect(Collectors.toList());
    }
}

