/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class ConstantExpression
extends Expression {
    public static final ConstantExpression NULL = new ConstantExpression(null);
    public static final ConstantExpression TRUE = new ConstantExpression(Boolean.TRUE);
    public static final ConstantExpression FALSE = new ConstantExpression(Boolean.FALSE);
    public static final ConstantExpression EMPTY_STRING = new ConstantExpression("");
    public static final ConstantExpression VOID;
    public static final ConstantExpression EMTPY_EXPRESSION;
    private Object value;
    private String constantName;
    static /* synthetic */ Class class$java$lang$Void;

    public ConstantExpression(Object value) {
        this.value = value;
        if (this.value != null) {
            this.setType(ClassHelper.make(value.getClass()));
        }
    }

    public String toString() {
        return "ConstantExpression[" + this.value + "]";
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitConstantExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public String getText() {
        return this.value == null ? "null" : this.value.toString();
    }

    public String getConstantName() {
        return this.constantName;
    }

    public void setConstantName(String constantName) {
        this.constantName = constantName;
    }

    public boolean isNullExpression() {
        return this.value == null;
    }

    public boolean isTrueExpression() {
        return Boolean.TRUE.equals(this.value);
    }

    public boolean isFalseExpression() {
        return Boolean.FALSE.equals(this.value);
    }

    public boolean isEmptyStringExpression() {
        return "".equals(this.value);
    }

    static {
        Class<?> clazz = class$java$lang$Void;
        if (clazz == null) {
            clazz = class$java$lang$Void = new Void[0].getClass().getComponentType();
        }
        VOID = new ConstantExpression(clazz);
        EMTPY_EXPRESSION = new ConstantExpression(null);
    }
}

