/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc.antlr4;

import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.LinkArgument;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyAbstractableElementDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyConstructorDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyExecutableMemberDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyFieldDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyMethodDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyParameter;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyType;

public class GroovydocJavaVisitor
extends VoidVisitorAdapter<Object> {
    private final List<LinkArgument> links;
    private SimpleGroovyClassDoc currentClassDoc = null;
    private Map<String, GroovyClassDoc> classDocs = new HashMap<String, GroovyClassDoc>();
    private String packagePath;
    private final Map<String, String> aliases = new HashMap<String, String>();
    private List<String> imports = new ArrayList<String>();
    private static final String FS = "/";

    public GroovydocJavaVisitor(String packagePath, List<LinkArgument> links) {
        this.packagePath = packagePath;
        this.links = links;
    }

    public void visit(ImportDeclaration n, Object arg) {
        Optional qualPath = n.getName().getQualifier();
        String qual = qualPath.map(value -> value.asString().replaceAll("\\.", FS) + FS).orElse("");
        String id = n.getName().getIdentifier();
        String name = qual + id;
        this.imports.add(name);
        this.aliases.put(id, name);
        super.visit(n, arg);
    }

    public void visit(AnnotationDeclaration n, Object arg) {
        List<String> imports = this.getImports();
        this.currentClassDoc = new SimpleGroovyClassDoc(imports, this.aliases, n.getNameAsString(), this.links);
        this.setModifiers((NodeList<Modifier>)n.getModifiers(), this.currentClassDoc);
        this.currentClassDoc.setTokenType(64);
        this.currentClassDoc.setFullPathName(this.withSlashes(this.packagePath + FS + n.getNameAsString()));
        n.getJavadocComment().ifPresent(javadocComment -> this.currentClassDoc.setRawCommentText(javadocComment.getContent()));
        this.classDocs.put(this.currentClassDoc.getFullPathName(), this.currentClassDoc);
        super.visit(n, arg);
    }

    private List<String> getImports() {
        ArrayList<String> imports = new ArrayList<String>(this.imports);
        imports.add(this.packagePath + "/*");
        for (String pkg : ResolveVisitor.DEFAULT_IMPORTS) {
            imports.add(pkg.replace('.', '/') + "*");
        }
        return imports;
    }

    public void visit(EnumDeclaration n, Object arg) {
        List<String> imports = this.getImports();
        this.currentClassDoc = new SimpleGroovyClassDoc(imports, this.aliases, n.getNameAsString(), this.links);
        this.setModifiers((NodeList<Modifier>)n.getModifiers(), this.currentClassDoc);
        this.currentClassDoc.setTokenType(61);
        this.currentClassDoc.setFullPathName(this.withSlashes(this.packagePath + FS + n.getNameAsString()));
        n.getJavadocComment().ifPresent(javadocComment -> this.currentClassDoc.setRawCommentText(javadocComment.getContent()));
        this.classDocs.put(this.currentClassDoc.getFullPathName(), this.currentClassDoc);
        super.visit(n, arg);
    }

    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        List<String> imports = this.getImports();
        SimpleGroovyClassDoc parent = this.currentClassDoc;
        String name = n.getNameAsString();
        boolean nested = n.isNestedType();
        if (nested) {
            name = parent.simpleTypeName() + "." + name;
        }
        this.currentClassDoc = new SimpleGroovyClassDoc(imports, this.aliases, name, this.links);
        if (nested) {
            parent.addNested(this.currentClassDoc);
        }
        this.setModifiers((NodeList<Modifier>)n.getModifiers(), this.currentClassDoc);
        if (n.isInterface()) {
            this.currentClassDoc.setTokenType(14);
        }
        n.getExtendedTypes().forEach(et -> {
            if (n.isInterface()) {
                this.currentClassDoc.addInterfaceName(et.getNameAsString());
            } else {
                this.currentClassDoc.setSuperClassName(et.getNameAsString());
            }
        });
        n.getImplementedTypes().forEach(classOrInterfaceType -> this.currentClassDoc.addInterfaceName(classOrInterfaceType.getNameAsString()));
        this.currentClassDoc.setFullPathName(this.packagePath + FS + name);
        this.currentClassDoc.setNameWithTypeArgs(name);
        n.getJavadocComment().ifPresent(javadocComment -> this.currentClassDoc.setRawCommentText(javadocComment.getContent()));
        this.classDocs.put(this.currentClassDoc.getFullPathName(), this.currentClassDoc);
        super.visit(n, arg);
        if (nested) {
            this.currentClassDoc = parent;
        }
    }

    private void setModifiers(NodeList<Modifier> modifiers, SimpleGroovyAbstractableElementDoc elementDoc) {
        if (modifiers.contains((Node)Modifier.publicModifier())) {
            elementDoc.setPublic(true);
        }
        if (modifiers.contains((Node)Modifier.staticModifier())) {
            elementDoc.setStatic(true);
        }
        if (modifiers.contains((Node)Modifier.abstractModifier())) {
            elementDoc.setAbstract(true);
        }
        if (modifiers.contains((Node)Modifier.finalModifier())) {
            elementDoc.setFinal(true);
        }
        if (modifiers.contains((Node)Modifier.protectedModifier())) {
            elementDoc.setProtected(true);
        }
        if (modifiers.contains((Node)Modifier.privateModifier())) {
            elementDoc.setPrivate(true);
        }
    }

    private String withSlashes(String s) {
        return s.replaceAll("\\.", FS).replaceAll("\\$", ".");
    }

    public void visit(MethodDeclaration m, Object arg) {
        SimpleGroovyMethodDoc meth = new SimpleGroovyMethodDoc(m.getNameAsString(), this.currentClassDoc);
        meth.setReturnType(this.makeType(m.getType()));
        this.setConstructorOrMethodCommon((CallableDeclaration<? extends CallableDeclaration>)m, meth);
        this.currentClassDoc.add(meth);
        super.visit(m, arg);
    }

    private SimpleGroovyType makeType(Type t) {
        return new SimpleGroovyType(this.withSlashes(t.asString()));
    }

    public void visit(ConstructorDeclaration c, Object arg) {
        SimpleGroovyConstructorDoc meth = new SimpleGroovyConstructorDoc(c.getNameAsString(), this.currentClassDoc);
        this.setConstructorOrMethodCommon((CallableDeclaration<? extends CallableDeclaration>)c, meth);
        this.currentClassDoc.add(meth);
        super.visit(c, arg);
    }

    private void setConstructorOrMethodCommon(CallableDeclaration<? extends CallableDeclaration> n, SimpleGroovyExecutableMemberDoc methOrCons) {
        n.getJavadocComment().ifPresent(javadocComment -> methOrCons.setRawCommentText(javadocComment.getContent()));
        this.setModifiers((NodeList<Modifier>)n.getModifiers(), methOrCons);
        for (Parameter param : n.getParameters()) {
            SimpleGroovyParameter p = new SimpleGroovyParameter(param.getNameAsString());
            p.setType(this.makeType(param.getType()));
            methOrCons.add(p);
        }
    }

    public void visit(FieldDeclaration f, Object arg) {
        String name = f.getVariable(0).getNameAsString();
        SimpleGroovyFieldDoc field = new SimpleGroovyFieldDoc(name, this.currentClassDoc);
        field.setType(this.makeType(f.getVariable(0).getType()));
        this.setModifiers((NodeList<Modifier>)f.getModifiers(), field);
        f.getJavadocComment().ifPresent(javadocComment -> field.setRawCommentText(javadocComment.getContent()));
        this.currentClassDoc.add(field);
        super.visit(f, arg);
    }

    public Map<String, GroovyClassDoc> getGroovyClassDocs() {
        return this.classDocs;
    }
}

