/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.core.JavaModelManager;

public class ModuleNodeMapper {
    private static final ModuleNodeMapper INSTANCE = new ModuleNodeMapper();
    private final Map<JavaModelManager.PerWorkingCopyInfo, ModuleNodeInfo> infoToModuleMap = new HashMap<JavaModelManager.PerWorkingCopyInfo, ModuleNodeInfo>();
    private final ReentrantLock lock = new ReentrantLock(true);

    static ModuleNodeMapper getInstance() {
        return INSTANCE;
    }

    public static boolean isEmpty() {
        return ModuleNodeMapper.INSTANCE.infoToModuleMap.isEmpty();
    }

    public static int size() {
        return ModuleNodeMapper.INSTANCE.infoToModuleMap.size();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    ModuleNodeInfo get(JavaModelManager.PerWorkingCopyInfo info) {
        this.lock.lock();
        try {
            this.sweepAndPurgeModuleNodes();
            ModuleNodeInfo moduleNodeInfo = this.infoToModuleMap.get(info);
            return moduleNodeInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    ModuleNodeInfo put(JavaModelManager.PerWorkingCopyInfo info, ModuleNodeInfo tuple) {
        this.lock.lock();
        try {
            this.sweepAndPurgeModuleNodes();
            ModuleNodeInfo moduleNodeInfo = this.infoToModuleMap.put(info, tuple);
            return moduleNodeInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    ModuleNodeInfo remove(JavaModelManager.PerWorkingCopyInfo info) {
        this.lock.lock();
        try {
            this.sweepAndPurgeModuleNodes();
            ModuleNodeInfo moduleNodeInfo = this.infoToModuleMap.remove(info);
            return moduleNodeInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void maybeCacheModuleNode(final JavaModelManager.PerWorkingCopyInfo info, final GroovyCompilationUnitDeclaration gcud) {
        if (info == null || gcud == null) return;
        if (this.lock.tryLock()) {
            try {
                ModuleNode module = gcud.getModuleNode();
                if (module == null) return;
                this.put(info, new ModuleNodeInfo(module, (JDTResolver)gcud.getCompilationUnit().getResolveVisitor(), gcud.compilationResult()));
                return;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            new Job("Cache module node"){

                @Override
                protected IStatus run(IProgressMonitor monitor) {
                    ModuleNodeMapper.this.maybeCacheModuleNode(info, gcud);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void sweepAndPurgeModuleNodes() {
        Iterator<JavaModelManager.PerWorkingCopyInfo> it = this.infoToModuleMap.keySet().iterator();
        while (it.hasNext()) {
            JavaModelManager.PerWorkingCopyInfo info = it.next();
            Integer useCount = (Integer)ReflectionUtils.getPrivateField(JavaModelManager.PerWorkingCopyInfo.class, "useCount", info);
            if (useCount == null || useCount > 0) continue;
            it.remove();
        }
    }

    public static class ModuleNodeInfo {
        public final ModuleNode module;
        public final JDTResolver resolver;
        public final CompilationResult result;

        public ModuleNodeInfo(ModuleNode module, JDTResolver resolver) {
            this(module, resolver, null);
        }

        public ModuleNodeInfo(ModuleNode module, JDTResolver resolver, CompilationResult result) {
            this.module = module;
            this.resolver = resolver;
            this.result = result;
        }

        public final boolean isEmpty() {
            if (!(this.module.getClasses().size() <= 1 && this.module.getMethods().isEmpty() && this.module.getImports().isEmpty() && this.module.getStaticImports().isEmpty() && this.module.getStarImports().isEmpty() && this.module.getStaticStarImports().isEmpty() && (this.module.getPackage() == null || this.module.getPackage().getAnnotations().isEmpty()))) {
                return false;
            }
            return this.module.getClasses().isEmpty() || this.module.getClasses().get(0).isScript() && this.module.getClasses().get(0).getFields().stream().noneMatch(f -> f.getEnd() > 0) && (this.module.getStatementBlock().isEmpty() || ModuleNodeInfo.isNullReturn(this.module.getStatementBlock()));
        }

        private static boolean isNullReturn(BlockStatement blockStatement) {
            ReturnStatement returnStatement;
            List<Statement> statements = blockStatement.getStatements();
            if (statements.size() == 1 && statements.get(0) instanceof ReturnStatement && (returnStatement = (ReturnStatement)statements.get(0)).getExpression() instanceof ConstantExpression) {
                return ((ConstantExpression)returnStatement.getExpression()).isNullExpression();
            }
            return false;
        }
    }
}

