/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration.internal;

import java.util.regex.Pattern;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.eclipse.jdt.groovy.core.util.CharArraySequence;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.util.CommentRecorderParser;
import org.eclipse.jdt.internal.core.util.Util;

class MultiplexingCommentRecorderParser
extends CommentRecorderParser {
    private final GroovyParser groovyParser;
    private static final Pattern GROOVY_SOURCE_DISCRIMINATOR = Pattern.compile("\\A(/\\*.*?\\*/\\s*)?package\\s+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\s*\\.\\s*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*\\s++(?!;)", 32);

    MultiplexingCommentRecorderParser(Object requestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean optimizeStringLiterals) {
        this(requestor, compilerOptions, problemReporter, optimizeStringLiterals, true);
    }

    MultiplexingCommentRecorderParser(Object requestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean optimizeStringLiterals, boolean allowTransforms) {
        super(problemReporter, optimizeStringLiterals);
        this.groovyParser = new GroovyParser(requestor, compilerOptions, problemReporter, allowTransforms, true);
    }

    @Override
    public CompilationUnitDeclaration dietParse(ICompilationUnit compilationUnit, CompilationResult compilationResult) {
        if (ContentTypeUtils.isGroovyLikeFileName(compilationUnit.getFileName()) || MultiplexingCommentRecorderParser.isGroovySource(compilationUnit)) {
            if (this.scanner != null) {
                this.scanner.setSource(compilationUnit.getContents());
            }
            return this.groovyParser.dietParse(compilationUnit, compilationResult);
        }
        return super.dietParse(compilationUnit, compilationResult);
    }

    private static boolean isGroovySource(ICompilationUnit compilationUnit) {
        if ((compilationUnit.getFileName() == null || !ContentTypeUtils.isJavaLikeButNotGroovyLikeFileName(new CharArraySequence(compilationUnit.getFileName()))) && GROOVY_SOURCE_DISCRIMINATOR.matcher(new CharArraySequence(compilationUnit.getContents())).find()) {
            Util.log(1, "Identified a Groovy source unit through inspection of its contents: " + String.valueOf(compilationUnit.getContents(), 0, Math.min(250, compilationUnit.getContents().length)));
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.groovyParser.reset();
    }
}

