/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.groovy.core.Activator;

public class ReflectionUtils {
    private static final Object[] NO_ARGS = new Object[0];
    private static final Class<?>[] NO_TYPES = new Class[0];
    private static final Map<String, Field> FIELDS = new HashMap<String, Field>();

    private ReflectionUtils() {
    }

    public static Class<?>[] getAllInterfaces(Class<?> clazz) {
        LinkedHashSet interfaces = new LinkedHashSet();
        do {
            Collections.addAll(interfaces, clazz.getInterfaces());
        } while ((clazz = clazz.getSuperclass()) != null);
        return interfaces.toArray(NO_TYPES);
    }

    public static <T> Constructor<T> getConstructor(Class<T> instanceType, Class<?> ... parameterTypes) {
        try {
            Constructor<T> ctor = instanceType.getDeclaredConstructor(parameterTypes);
            if (!ctor.isAccessible()) {
                ctor.setAccessible(true);
            }
            return ctor;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeConstructor(Constructor<T> ctor, Object ... args) {
        try {
            return ctor.newInstance(args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeConstructor(Class<T> instanceType, Class<?>[] parameterTypes, Object[] args) {
        try {
            return ReflectionUtils.invokeConstructor(ReflectionUtils.getConstructor(instanceType, parameterTypes), args);
        }
        catch (RuntimeException e) {
            ReflectionUtils.log("Error executing private constructor for '" + instanceType.getName() + "' on class " + instanceType, e);
            return null;
        }
    }

    public static <R, T> R getPrivateField(Class<? extends T> clazz, String fieldName, T target) {
        try {
            return ReflectionUtils.throwableGetPrivateField(clazz, fieldName, target);
        }
        catch (Exception e) {
            ReflectionUtils.log("Error getting private field '" + fieldName + "' on class " + clazz, e);
            return null;
        }
    }

    public static <T> void setPrivateField(Class<? extends T> clazz, String fieldName, T target, Object value) {
        try {
            ReflectionUtils.throwableSetPrivateField(clazz, fieldName, target, value);
        }
        catch (Exception e) {
            ReflectionUtils.log("Error setting private field '" + fieldName + "' on class " + clazz, e);
        }
    }

    public static <R, T> R executePrivateMethod(Class<? extends T> clazz, String methodName, T target) {
        return ReflectionUtils.executePrivateMethod(clazz, methodName, NO_TYPES, target, NO_ARGS);
    }

    public static <R, T> R executePrivateMethod(Class<? extends T> clazz, String methodName, Class<?>[] paramTypes, T target, Object[] args) {
        try {
            Method method = ReflectionUtils.getDeclaredMethod(clazz, methodName, paramTypes);
            Object result = method.invoke(target, args);
            return (R)result;
        }
        catch (Exception e) {
            ReflectionUtils.log("Error executing private method '" + methodName + "' on class " + clazz, e);
            return null;
        }
    }

    public static <R, T> R throwableExecutePrivateMethod(Class<? extends T> clazz, String methodName, Class<?>[] paramTypes, T target, Object[] args) throws Exception {
        Method method = ReflectionUtils.getDeclaredMethod(clazz, methodName, paramTypes);
        Object result = method.invoke(target, args);
        return (R)result;
    }

    public static <R, T> R throwableGetPrivateField(Class<? extends T> clazz, String fieldName, T target) throws Exception {
        Field field = ReflectionUtils.getDeclaredField(clazz, fieldName);
        Object result = field.get(target);
        return (R)result;
    }

    public static <T> void throwableSetPrivateField(Class<? extends T> clazz, String fieldName, T target, Object value) throws Exception {
        Field field = ReflectionUtils.getDeclaredField(clazz, fieldName);
        field.set(target, value);
    }

    private static Field getDeclaredField(Class<?> clazz, String field) throws Exception {
        try {
            return FIELDS.computeIfAbsent(String.valueOf(clazz.getCanonicalName()) + field, k -> {
                try {
                    Field f = clazz.getDeclaredField(field);
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    return f;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getClass() == RuntimeException.class && e.getCause() != null) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    private static Method getDeclaredMethod(Class<?> clazz, String method, Class<?> ... paramTypes) throws Exception {
        Method m = clazz.getDeclaredMethod(method, paramTypes);
        if (!m.isAccessible()) {
            m.setAccessible(true);
        }
        return m;
    }

    private static void log(String message, Throwable throwable) {
        Activator.getDefault().getLog().log(new Status(4, "org.eclipse.jdt.groovy.core", message, throwable));
    }
}

