/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration.internal;

import java.util.Collections;
import org.codehaus.jdt.groovy.integration.internal.GroovyIndexingVisitor;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementNotifier;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.search.indexing.IndexingParser;
import org.eclipse.jdt.internal.core.util.Util;

public class MultiplexingIndexingParser
extends IndexingParser {
    SourceElementNotifier notifier = (SourceElementNotifier)ReflectionUtils.getPrivateField(SourceElementParser.class, "notifier", this);
    boolean groovyReportReferenceInfo;
    ISourceElementRequestor requestor;

    public MultiplexingIndexingParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals, boolean useSourceJavadocParser) {
        super(requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals, useSourceJavadocParser);
        this.groovyReportReferenceInfo = reportLocalDeclarations;
        this.requestor = requestor;
    }

    @Override
    public void setRequestor(ISourceElementRequestor requestor) {
        super.setRequestor(requestor);
        this.requestor = requestor;
    }

    @Override
    public CompilationUnitDeclaration parseCompilationUnit(ICompilationUnit unit, boolean fullParse, IProgressMonitor pm) {
        if (!ContentTypeUtils.isGroovyLikeFileName(unit.getFileName())) {
            return super.parseCompilationUnit(unit, fullParse, pm);
        }
        CompilationResult compilationResult = new CompilationResult(unit, 0, 0, this.options.maxProblemsPerUnit);
        GroovyCompilationUnitDeclaration cud = new GroovyParser(this.options, this.problemReporter, false, true).dietParse(unit, compilationResult);
        if (cud.getModuleNode() != null) {
            try {
                GroovyIndexingVisitor visitor = new GroovyIndexingVisitor(this.requestor);
                visitor.visitModule(cud.getModuleNode());
            }
            catch (RuntimeException e) {
                Util.log(e);
            }
        }
        this.notifier.notifySourceElementRequestor(cud, 0, unit.getContents().length, this.groovyReportReferenceInfo, cud.sourceEnds, Collections.EMPTY_MAP);
        return cud;
    }
}

