/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.groovy.core.SystemPropertyCleaner;
import org.eclipse.jdt.internal.core.util.Util;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.jdt.groovy.core";
    private static Activator plugin;
    private IEclipsePreferences instanceScope;
    public static final String GROOVY_CHECK_FOR_COMPILER_MISMATCH = "groovy.check.for.compiler.mismatch";
    public static final String GROOVY_SCRIPT_FILTERS = "groovy.script.filters";
    public static final String GROOVY_SCRIPT_FILTERS_ENABLED = "groovy.script.filters.enabled";
    public static final String DEFAULT_GROOVY_SCRIPT_FILTER = "**/*.dsld,y,scripts/**/*.groovy,y,src/main/resources/**/*.groovy,y,src/test/resources/**/*.groovy,y";
    public static final String USING_PROJECT_PROPERTIES = "org.codehaus.groovy.eclipse.preferences.compiler.project";
    public static final String GROOVY_COMPILER_LEVEL = "groovy.compiler.level";

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        SystemPropertyCleaner.clean();
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void setPreference(IEclipsePreferences preferences, String key, List<String> vals) {
        String concat;
        if (preferences == null) {
            preferences = this.getProjectOrWorkspacePreferences(null);
        }
        if (vals == null) {
            concat = "";
        } else {
            StringBuilder sb = new StringBuilder();
            Iterator<String> valIter = vals.iterator();
            while (valIter.hasNext()) {
                sb.append(valIter.next());
                if (!valIter.hasNext()) continue;
                sb.append(",");
            }
            concat = sb.toString();
        }
        preferences.put(key, concat);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Util.log(e);
        }
    }

    public void setPreference(IEclipsePreferences preferences, String key, String val) {
        if (val == null) {
            val = "";
        }
        if (preferences == null) {
            preferences = this.getProjectOrWorkspacePreferences(null);
        }
        preferences.put(key, val);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Util.log(e);
        }
    }

    public List<String> getListStringPreference(IEclipsePreferences preferences, String key, String def) {
        String result;
        if (preferences == null) {
            preferences = this.getProjectOrWorkspacePreferences(null);
        }
        if ((result = preferences.get(key, def)) == null) {
            result = "";
        }
        String[] splits = result.split(",");
        return Arrays.asList(splits);
    }

    public String getStringPreference(IEclipsePreferences preferences, String key, String def) {
        if (preferences == null) {
            preferences = this.getProjectOrWorkspacePreferences(null);
        }
        return preferences.get(key, def);
    }

    public IEclipsePreferences getProjectOrWorkspacePreferences(IProject project) {
        IEclipsePreferences projectPreferences = this.getProjectScope(project);
        if (projectPreferences != null && projectPreferences.getBoolean(USING_PROJECT_PROPERTIES, false)) {
            return projectPreferences;
        }
        if (this.instanceScope == null) {
            this.instanceScope = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        }
        return this.instanceScope;
    }

    private IEclipsePreferences getProjectScope(IProject project) {
        if (project == null) {
            return null;
        }
        ProjectScope projectScope = new ProjectScope(project);
        return projectScope.getNode(PLUGIN_ID);
    }

    public String getGroovyCompilerLevel(IProject project) {
        IEclipsePreferences projectPreferences = this.getProjectScope(project);
        if (projectPreferences != null) {
            return projectPreferences.get(GROOVY_COMPILER_LEVEL, null);
        }
        return null;
    }

    public void setGroovyCompilerLevel(IProject project, String level) {
        IEclipsePreferences projectPreferences = this.getProjectScope(project);
        if (projectPreferences != null) {
            projectPreferences.put(GROOVY_COMPILER_LEVEL, level);
            try {
                projectPreferences.flush();
            }
            catch (BackingStoreException e) {
                Util.log(e);
            }
        }
    }

    public boolean getBooleanPreference(IEclipsePreferences preferences, String key, boolean def) {
        if (preferences == null) {
            preferences = this.getProjectOrWorkspacePreferences(null);
        }
        return preferences.getBoolean(key, def);
    }
}

