/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.FileBundleEntry;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirBundleFile
extends BundleFile {
    private static final String POINTER_SAME_DIRECTORY_1 = "/.";
    private static final String POINTER_SAME_DIRECTORY_2 = "//";
    private static final String POINTER_UPPER_DIRECTORY = "..";
    private final boolean enableStrictBundleEntryPath;

    public DirBundleFile(File basefile, boolean enableStrictBundleEntryPath) throws IOException {
        super(DirBundleFile.getBaseFile(basefile, enableStrictBundleEntryPath));
        if (!BundleFile.secureAction.exists(basefile) || !BundleFile.secureAction.isDirectory(basefile)) {
            throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_EXCEPTION, basefile));
        }
        this.enableStrictBundleEntryPath = enableStrictBundleEntryPath;
    }

    private static File getBaseFile(File basefile, boolean enableStrictBundleEntryPath) throws IOException {
        return enableStrictBundleEntryPath ? secureAction.getCanonicalFile(basefile) : basefile;
    }

    @Override
    public File getFile(String path, boolean nativeCode) {
        File canonicalFile;
        File file;
        boolean checkInBundle;
        block13: {
            checkInBundle = path != null && path.indexOf(POINTER_UPPER_DIRECTORY) >= 0;
            file = new File(this.basefile, path);
            if (!BundleFile.secureAction.exists(file)) {
                return null;
            }
            if (!this.enableStrictBundleEntryPath) {
                if (checkInBundle) {
                    try {
                        if (!BundleFile.secureAction.getCanonicalPath(file).startsWith(BundleFile.secureAction.getCanonicalPath(this.basefile))) {
                            return null;
                        }
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
                return file;
            }
            boolean normalize = false;
            boolean isBundleRoot = false;
            if (path != null && !(isBundleRoot = path.equals("/"))) {
                normalize = checkInBundle || path.indexOf(POINTER_SAME_DIRECTORY_1) >= 0 || path.indexOf(POINTER_SAME_DIRECTORY_2) >= 0;
            }
            try {
                String absolutePath;
                String canonicalPath;
                canonicalFile = BundleFile.secureAction.getCanonicalFile(file);
                if (isBundleRoot) break block13;
                File absoluteFile = BundleFile.secureAction.getAbsoluteFile(file);
                if (normalize) {
                    canonicalPath = canonicalFile.toURI().getPath();
                    absolutePath = absoluteFile.toURI().normalize().getPath();
                } else {
                    canonicalPath = canonicalFile.getPath();
                    absolutePath = absoluteFile.getPath();
                }
                if (canonicalPath.equals(absolutePath)) break block13;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (checkInBundle && !canonicalFile.getPath().startsWith(this.basefile.getPath())) {
            return null;
        }
        return file;
    }

    @Override
    public BundleEntry getEntry(String path) {
        File filePath = this.getFile(path, false);
        if (filePath == null) {
            return null;
        }
        return new FileBundleEntry(filePath, path);
    }

    @Override
    public boolean containsDir(String dir) {
        File dirPath = this.getFile(dir, false);
        return dirPath != null && BundleFile.secureAction.isDirectory(dirPath);
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        File pathFile;
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if ((pathFile = this.getFile(path, false)) == null || !BundleFile.secureAction.isDirectory(pathFile)) {
            return null;
        }
        final String[] fileList = BundleFile.secureAction.list(pathFile);
        if (fileList == null || fileList.length == 0) {
            return null;
        }
        final String dirPath = path.length() == 0 || path.charAt(path.length() - 1) == '/' ? path : String.valueOf(path) + '/';
        return new Enumeration<String>(){
            int cur = 0;

            @Override
            public boolean hasMoreElements() {
                return fileList != null && this.cur < fileList.length;
            }

            @Override
            public String nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                File childFile = new File(pathFile, fileList[this.cur]);
                StringBuffer sb = new StringBuffer(dirPath).append(fileList[this.cur++]);
                if (BundleFile.secureAction.isDirectory(childFile)) {
                    sb.append("/");
                }
                return sb.toString();
            }
        };
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }
}

