/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.ToString;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.transform.AbstractASTTransformUtil;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.CanonicalASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ToStringASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = ToString.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode STRINGBUILDER_TYPE = ClassHelper.make(StringBuilder.class);
    private static final ClassNode INVOKER_TYPE = ClassHelper.make(InvokerHelper.class);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            boolean includePackage;
            ClassNode cNode = (ClassNode)parent;
            this.checkNotInterface(cNode, MY_TYPE_NAME);
            boolean includeSuper = this.memberHasValue(anno, "includeSuper", true);
            if (includeSuper && cNode.getSuperClass().getName().equals("java.lang.Object")) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: includeSuper=true but '" + cNode.getName() + "' has no super class.", anno);
            }
            boolean includeNames = this.memberHasValue(anno, "includeNames", true);
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            List<String> excludes = this.getMemberList(anno, "excludes");
            List<String> includes = this.getMemberList(anno, "includes");
            boolean ignoreNulls = this.memberHasValue(anno, "ignoreNulls", true);
            boolean bl = includePackage = !this.memberHasValue(anno, "includePackage", false);
            if (this.hasAnnotation(cNode, CanonicalASTTransformation.MY_TYPE)) {
                AnnotationNode canonical = cNode.getAnnotations(CanonicalASTTransformation.MY_TYPE).get(0);
                if (excludes == null || excludes.isEmpty()) {
                    excludes = this.getMemberList(canonical, "excludes");
                }
                if (includes == null || includes.isEmpty()) {
                    includes = this.getMemberList(canonical, "includes");
                }
            }
            if (includes != null && !includes.isEmpty() && excludes != null && !excludes.isEmpty()) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: Only one of 'includes' and 'excludes' should be supplied not both.", anno);
            }
            ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, includePackage);
        }
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes, includeNames, false);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames, boolean ignoreNulls) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, true);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames, boolean ignoreNulls, boolean includePackage) {
        boolean hasExistingToString = AbstractASTTransformUtil.hasDeclaredMethod(cNode, "toString", 0);
        if (hasExistingToString && AbstractASTTransformUtil.hasDeclaredMethod(cNode, "_toString", 0)) {
            return;
        }
        BlockStatement body = new BlockStatement();
        VariableExpression result = new VariableExpression("_result");
        ConstructorCallExpression init = new ConstructorCallExpression(STRINGBUILDER_TYPE, MethodCallExpression.NO_ARGUMENTS);
        body.addStatement(AbstractASTTransformUtil.declStatement(result, init));
        VariableExpression first = new VariableExpression("$toStringFirst");
        body.addStatement(AbstractASTTransformUtil.declStatement(first, ConstantExpression.TRUE));
        String className = includePackage ? cNode.getName() : cNode.getNameWithoutPackage();
        body.addStatement(ToStringASTTransformation.append(result, new ConstantExpression(className + "(")));
        List<PropertyNode> pList = AbstractASTTransformUtil.getInstanceProperties(cNode);
        for (PropertyNode pNode : pList) {
            if (ToStringASTTransformation.shouldSkip(pNode.getName(), excludes, includes)) continue;
            String getterName = "get" + Verifier.capitalize(pNode.getName());
            MethodCallExpression getter = new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, getterName, MethodCallExpression.NO_ARGUMENTS);
            ToStringASTTransformation.appendValue(body, result, first, getter, pNode.getName(), includeNames, ignoreNulls);
        }
        if (includeFields) {
            ArrayList<FieldNode> fList = new ArrayList<FieldNode>();
            fList.addAll(AbstractASTTransformUtil.getInstanceNonPropertyFields(cNode));
            for (FieldNode fNode : fList) {
                if (ToStringASTTransformation.shouldSkip(fNode.getName(), excludes, includes)) continue;
                ToStringASTTransformation.appendValue(body, result, first, new VariableExpression(fNode), fNode.getName(), includeNames, ignoreNulls);
            }
        }
        if (includeSuper) {
            ToStringASTTransformation.appendCommaIfNotFirst(body, result, first);
            ToStringASTTransformation.appendPrefix(body, result, "super", includeNames);
            body.addStatement(ToStringASTTransformation.append(result, new MethodCallExpression((Expression)VariableExpression.SUPER_EXPRESSION, "toString", MethodCallExpression.NO_ARGUMENTS)));
        }
        body.addStatement(ToStringASTTransformation.append(result, new ConstantExpression(")")));
        MethodCallExpression toString = new MethodCallExpression((Expression)result, "toString", MethodCallExpression.NO_ARGUMENTS);
        toString.setImplicitThis(false);
        body.addStatement(new ReturnStatement(toString));
        cNode.addMethod(new MethodNode(hasExistingToString ? "_toString" : "toString", hasExistingToString ? 2 : 1, ClassHelper.STRING_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body));
    }

    private static void appendValue(BlockStatement body, Expression result, VariableExpression first, Expression value, String name, boolean includeNames, boolean ignoreNulls) {
        BlockStatement thenBlock = new BlockStatement();
        Statement appendValue = ignoreNulls ? new IfStatement(AbstractASTTransformUtil.notNullExpr(value), thenBlock, EmptyStatement.INSTANCE) : thenBlock;
        ToStringASTTransformation.appendCommaIfNotFirst(thenBlock, result, first);
        ToStringASTTransformation.appendPrefix(thenBlock, result, name, includeNames);
        thenBlock.addStatement(new IfStatement(AbstractASTTransformUtil.identicalExpr(value, VariableExpression.THIS_EXPRESSION), ToStringASTTransformation.append(result, new ConstantExpression("(this)")), ToStringASTTransformation.append(result, new StaticMethodCallExpression(INVOKER_TYPE, "toString", value))));
        body.addStatement(appendValue);
    }

    private static void appendCommaIfNotFirst(BlockStatement body, Expression result, VariableExpression first) {
        body.addStatement(new IfStatement(new BooleanExpression(first), AbstractASTTransformUtil.assignStatement(first, ConstantExpression.FALSE), ToStringASTTransformation.append(result, new ConstantExpression(", "))));
    }

    private static void appendPrefix(BlockStatement body, Expression result, String name, boolean includeNames) {
        if (includeNames) {
            body.addStatement(ToStringASTTransformation.toStringPropertyName(result, name));
        }
    }

    private static Statement toStringPropertyName(Expression result, String fName) {
        BlockStatement body = new BlockStatement();
        body.addStatement(ToStringASTTransformation.append(result, new ConstantExpression(fName + ":")));
        return body;
    }

    private static ExpressionStatement append(Expression result, Expression expr) {
        MethodCallExpression append = new MethodCallExpression(result, "append", expr);
        append.setImplicitThis(false);
        return new ExpressionStatement(append);
    }

    private static boolean shouldSkip(String name, List<String> excludes, List<String> includes) {
        return excludes != null && excludes.contains(name) || name.contains("$") || includes != null && !includes.isEmpty() && !includes.contains(name);
    }
}

