/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ImportNodeCompatibilityWrapper;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.search.AssignmentStorer;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.ITypeLookupExtension;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.ITypeResolver;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.util.Util;

public class TypeInferencingVisitorWithRequestor
extends ClassCodeVisitorSupport {
    public boolean DEBUG = false;
    private static final Set<String> dgmClosureMethods = new HashSet<String>();
    private static final Set<String> dgmClosureIdentityMethods;
    private static final Set<String> dgmClosureMaybeMap;
    private static final Map<String, ClassNode> dgmClosureMethodsMap;
    private final GroovyCompilationUnit unit;
    private final Stack<VariableScope> scopes;
    private final ITypeLookup[] lookups;
    private ITypeRequestor requestor;
    private IJavaElement enclosingElement;
    private ASTNode enclosingDeclarationNode;
    private BinaryExpression enclosingAssignment;
    private ConstructorCallExpression enclosingConstructorCall;
    private Stack<ASTNode> completeExpressionStack;
    private Stack<ClassNode> primaryTypeStack;
    private Stack<ClassNode> dependentDeclaringTypeStack;
    private Stack<ClassNode> dependentTypeStack;
    private final JDTResolver resolver;
    private final AssignmentStorer assignmentStorer = new AssignmentStorer();

    static {
        dgmClosureMethods.add("find");
        dgmClosureMethods.add("each");
        dgmClosureMethods.add("reverseEach");
        dgmClosureMethods.add("eachWithIndex");
        dgmClosureMethods.add("unique");
        dgmClosureMethods.add("every");
        dgmClosureMethods.add("collect");
        dgmClosureMethods.add("collectEntries");
        dgmClosureMethods.add("collectNested");
        dgmClosureMethods.add("collectMany");
        dgmClosureMethods.add("findAll");
        dgmClosureMethods.add("groupBy");
        dgmClosureMethods.add("groupEntriesBy");
        dgmClosureMethods.add("inject");
        dgmClosureMethods.add("count");
        dgmClosureMethods.add("countBy");
        dgmClosureMethods.add("findResult");
        dgmClosureMethods.add("findResults");
        dgmClosureMethods.add("grep");
        dgmClosureMethods.add("split");
        dgmClosureMethods.add("sum");
        dgmClosureMethods.add("any");
        dgmClosureMethods.add("flatten");
        dgmClosureMethods.add("findIndexOf");
        dgmClosureMethods.add("findIndexValues");
        dgmClosureMethods.add("findLastIndexOf");
        dgmClosureMethods.add("collectAll");
        dgmClosureMethods.add("min");
        dgmClosureMethods.add("max");
        dgmClosureMethods.add("eachPermutation");
        dgmClosureMethods.add("sort");
        dgmClosureMethods.add("withDefault");
        dgmClosureMethods.add("identity");
        dgmClosureMethods.add("times");
        dgmClosureMethods.add("upto");
        dgmClosureMethods.add("downto");
        dgmClosureMethods.add("step");
        dgmClosureMethods.add("eachFile");
        dgmClosureMethods.add("eachDir");
        dgmClosureMethods.add("eachFileRecurse");
        dgmClosureMethods.add("eachDirRecurse");
        dgmClosureMethods.add("traverse");
        dgmClosureIdentityMethods = new HashSet<String>();
        dgmClosureIdentityMethods.add("with");
        dgmClosureIdentityMethods.add("addShutdownHook");
        dgmClosureMaybeMap = new HashSet<String>();
        dgmClosureMaybeMap.add("any");
        dgmClosureMaybeMap.add("every");
        dgmClosureMaybeMap.add("each");
        dgmClosureMaybeMap.add("collect");
        dgmClosureMaybeMap.add("collectEntries");
        dgmClosureMaybeMap.add("findResult");
        dgmClosureMaybeMap.add("findResults");
        dgmClosureMaybeMap.add("findAll");
        dgmClosureMaybeMap.add("groupBy");
        dgmClosureMaybeMap.add("groupEntriesBy");
        dgmClosureMaybeMap.add("inject");
        dgmClosureMaybeMap.add("withDefault");
        dgmClosureMethodsMap = new HashMap<String, ClassNode>();
        dgmClosureMethodsMap.put("eachLine", VariableScope.STRING_CLASS_NODE);
        dgmClosureMethodsMap.put("splitEachLine", VariableScope.STRING_CLASS_NODE);
        dgmClosureMethodsMap.put("withObjectOutputStream", VariableScope.OBJECT_OUTPUT_STREAM);
        dgmClosureMethodsMap.put("withObjectInputStream", VariableScope.OBJECT_INPUT_STREAM);
        dgmClosureMethodsMap.put("withDataOutputStream", VariableScope.DATA_OUTPUT_STREAM_CLASS);
        dgmClosureMethodsMap.put("withDataInputStream", VariableScope.DATA_INPUT_STREAM_CLASS);
        dgmClosureMethodsMap.put("withOutputStream", VariableScope.OUTPUT_STREAM_CLASS);
        dgmClosureMethodsMap.put("withInputStream", VariableScope.INPUT_STREAM_CLASS);
        dgmClosureMethodsMap.put("withStream", VariableScope.OUTPUT_STREAM_CLASS);
        dgmClosureMethodsMap.put("metaClass", ClassHelper.METACLASS_TYPE);
        dgmClosureMethodsMap.put("eachFileMatch", VariableScope.FILE_CLASS_NODE);
        dgmClosureMethodsMap.put("eachDirMatch", VariableScope.FILE_CLASS_NODE);
        dgmClosureMethodsMap.put("withReader", VariableScope.BUFFERED_READER_CLASS_NODE);
        dgmClosureMethodsMap.put("withWriter", VariableScope.BUFFERED_WRITER_CLASS_NODE);
        dgmClosureMethodsMap.put("withWriterAppend", VariableScope.BUFFERED_WRITER_CLASS_NODE);
        dgmClosureMethodsMap.put("withPrintWriter", VariableScope.PRINT_WRITER_CLASS_NODE);
        dgmClosureMethodsMap.put("transformChar", VariableScope.STRING_CLASS_NODE);
        dgmClosureMethodsMap.put("transformLine", VariableScope.STRING_CLASS_NODE);
        dgmClosureMethodsMap.put("filterLine", VariableScope.STRING_CLASS_NODE);
        dgmClosureMethodsMap.put("eachMatch", VariableScope.STRING_CLASS_NODE);
    }

    TypeInferencingVisitorWithRequestor(GroovyCompilationUnit unit, ITypeLookup[] lookups) {
        this.unit = unit;
        ModuleNodeMapper.ModuleNodeInfo info = this.createModuleNode(unit);
        this.enclosingDeclarationNode = info != null ? info.module : null;
        this.resolver = info != null ? info.resolver : null;
        this.lookups = lookups;
        this.scopes = new Stack();
        this.completeExpressionStack = new Stack();
        this.primaryTypeStack = new Stack();
        this.dependentTypeStack = new Stack();
        this.dependentDeclaringTypeStack = new Stack();
    }

    public void visitCompilationUnit(ITypeRequestor requestor) {
        block10: {
            if (this.enclosingDeclarationNode == null) {
                return;
            }
            this.requestor = requestor;
            this.enclosingElement = this.unit;
            VariableScope topLevelScope = new VariableScope(null, this.enclosingDeclarationNode, false);
            this.scopes.push(topLevelScope);
            ITypeLookup[] iTypeLookupArray = this.lookups;
            int n = this.lookups.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeLookup lookup = iTypeLookupArray[n2];
                if (lookup instanceof ITypeResolver) {
                    ((ITypeResolver)((Object)lookup)).setResolverInformation((ModuleNode)this.enclosingDeclarationNode, this.resolver);
                }
                lookup.initialize(this.unit, topLevelScope);
                ++n2;
            }
            try {
                this.visitPackage(((ModuleNode)this.enclosingDeclarationNode).getPackage());
                this.visitImports((ModuleNode)this.enclosingDeclarationNode);
                try {
                    IType[] types;
                    IType[] iTypeArray = types = this.unit.getTypes();
                    int n3 = types.length;
                    n = 0;
                    while (n < n3) {
                        IType type = iTypeArray[n];
                        this.visitJDT(type, requestor);
                        ++n;
                    }
                }
                catch (JavaModelException e) {
                    Util.log(e, "Error getting types for " + this.unit.getElementName());
                }
                this.scopes.pop();
            }
            catch (VisitCompleted e) {
            }
            catch (Exception e) {
                Util.log(e, "Error in inferencing engine for " + this.unit.getElementName());
                if (!this.DEBUG) break block10;
                System.err.println("Excpetion thrown from inferencing engine");
                e.printStackTrace();
            }
        }
        if (this.DEBUG) {
            this.postVisitSanityCheck();
        }
    }

    public void visitPackage(PackageNode p) {
    }

    public void visitJDT(IType type, ITypeRequestor requestor) {
        IJavaElement oldEnclosing = this.enclosingElement;
        ASTNode oldEnclosingNode = this.enclosingDeclarationNode;
        this.enclosingElement = type;
        ClassNode node = this.findClassWithName(this.createName(type));
        if (node == null) {
            return;
        }
        try {
            try {
                this.scopes.push(new VariableScope(this.scopes.peek(), node, false));
                this.enclosingDeclarationNode = node;
                this.visitClassInternal(node);
                try {
                    ConstructorNode defConstructor;
                    boolean isEnum = type.isEnum();
                    IJavaElement[] iJavaElementArray = type.getChildren();
                    int n = iJavaElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement child = iJavaElementArray[n2];
                        if (!isEnum || !this.shouldFilterEnumMember(child)) {
                            switch (child.getElementType()) {
                                case 9: {
                                    this.visitJDT((IMethod)child, requestor);
                                    break;
                                }
                                case 8: {
                                    this.visitJDT((IField)child, requestor);
                                    break;
                                }
                                case 7: {
                                    this.visitJDT((IType)child, requestor);
                                    break;
                                }
                            }
                        }
                        ++n2;
                    }
                    if (!type.getMethod(type.getElementName(), new String[0]).exists() && (defConstructor = this.findDefaultConstructor(node)) != null) {
                        this.visitConstructorOrMethod(defConstructor, true);
                    }
                }
                catch (JavaModelException e) {
                    Util.log(e, "Error getting children of " + type.getFullyQualifiedName());
                }
            }
            catch (VisitCompleted vc) {
                if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                    throw vc;
                }
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
            }
        }
        finally {
            this.enclosingElement = oldEnclosing;
            this.enclosingDeclarationNode = oldEnclosingNode;
            this.scopes.pop();
        }
    }

    private ConstructorNode findDefaultConstructor(ClassNode node) {
        List<ConstructorNode> constructors = node.getDeclaredConstructors();
        for (ConstructorNode constructor : constructors) {
            if (constructor.getParameters() != null && constructor.getParameters().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private boolean shouldFilterEnumMember(IJavaElement child) {
        int type = child.getElementType();
        String name = child.getElementName();
        if (name.indexOf(36) >= 0) {
            return true;
        }
        return type == 9 ? (name.equals("next") || name.equals("previous")) && ((IMethod)child).getNumberOfParameters() == 0 : type == 9 && (name.equals("MIN_VALUE") || name.equals("MAX_VALUE"));
    }

    private String createName(IType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getElementName());
        while (type.getParent().getElementType() == 7) {
            sb.insert(0, '$');
            type = (IType)type.getParent();
            sb.insert(0, type.getElementName());
        }
        return sb.toString();
    }

    public void visitJDT(IField field, ITypeRequestor requestor) {
        List<MethodNode> lazyMethods;
        FieldNode fieldNode;
        ASTNode oldEnclosingNode;
        IJavaElement oldEnclosing;
        block14: {
            oldEnclosing = this.enclosingElement;
            oldEnclosingNode = this.enclosingDeclarationNode;
            this.enclosingElement = field;
            this.requestor = requestor;
            fieldNode = this.findFieldNode(field);
            if (fieldNode == null) {
                return;
            }
            this.enclosingDeclarationNode = fieldNode;
            this.scopes.push(new VariableScope(this.scopes.peek(), fieldNode, fieldNode.isStatic()));
            try {
                try {
                    this.visitField(fieldNode);
                }
                catch (VisitCompleted vc) {
                    if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                        throw vc;
                    }
                    this.enclosingDeclarationNode = oldEnclosingNode;
                    this.enclosingElement = oldEnclosing;
                    this.scopes.pop();
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.enclosingElement = oldEnclosing;
                this.scopes.pop();
                throw throwable;
            }
            this.enclosingDeclarationNode = oldEnclosingNode;
            this.enclosingElement = oldEnclosing;
            this.scopes.pop();
        }
        if (this.isLazy(fieldNode) && (lazyMethods = ((ClassNode)this.enclosingDeclarationNode).getDeclaredMethods("set$" + field.getElementName())).size() > 0) {
            MethodNode lazyMethod = lazyMethods.get(0);
            this.enclosingDeclarationNode = lazyMethod;
            this.requestor = requestor;
            this.scopes.push(new VariableScope(this.scopes.peek(), lazyMethod, lazyMethod.isStatic()));
            try {
                try {
                    this.visitConstructorOrMethod(lazyMethod, lazyMethod instanceof ConstructorNode);
                }
                catch (VisitCompleted vc) {
                    if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                        throw vc;
                    }
                    this.enclosingElement = oldEnclosing;
                    this.enclosingDeclarationNode = oldEnclosingNode;
                    this.scopes.pop();
                }
            }
            finally {
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
            }
        }
    }

    public void visitJDT(IMethod method, ITypeRequestor requestor) {
        IJavaElement oldEnclosing = this.enclosingElement;
        ASTNode oldEnclosingNode = this.enclosingDeclarationNode;
        this.enclosingElement = method;
        MethodNode methodNode = this.findMethodNode(method);
        if (methodNode == null) {
            return;
        }
        this.enclosingDeclarationNode = methodNode;
        this.requestor = requestor;
        this.scopes.push(new VariableScope(this.scopes.peek(), methodNode, methodNode.isStatic()));
        try {
            try {
                this.visitConstructorOrMethod(methodNode, method.isConstructor());
            }
            catch (VisitCompleted vc) {
                if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                    throw vc;
                }
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
            }
            catch (JavaModelException e) {
                Util.log(e, "Exception visiting method " + method.getElementName() + " in class " + method.getParent().getElementName());
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
            }
        }
        finally {
            this.enclosingElement = oldEnclosing;
            this.enclosingDeclarationNode = oldEnclosingNode;
            this.scopes.pop();
        }
    }

    private void visitClassInternal(ClassNode node) {
        if (this.resolver != null) {
            this.resolver.currentClass = node;
        }
        VariableScope scope = this.scopes.peek();
        scope.addVariable("this", node, node);
        this.visitAnnotations(node);
        TypeLookupResult result = null;
        result = new TypeLookupResult(node, node, node, TypeLookupResult.TypeConfidence.EXACT, scope);
        ITypeRequestor.VisitStatus status = this.notifyRequestor(node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                break;
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
        if (!node.isEnum()) {
            this.visitGenerics(node);
            this.visitClassReference(node.getUnresolvedSuperClass());
        }
        ClassNode[] classNodeArray = node.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode intr = classNodeArray[n2];
            this.visitClassReference(intr);
            ++n2;
        }
        VariableScope currentScope = scope;
        MethodNode clinit = node.getMethod("<clinit>", new Parameter[0]);
        if (clinit != null && clinit.getCode() instanceof BlockStatement) {
            for (Statement element : ((BlockStatement)clinit.getCode()).getStatements()) {
                FieldNode f;
                BinaryExpression bexpr;
                if (!(element instanceof ExpressionStatement) || !(((ExpressionStatement)element).getExpression() instanceof BinaryExpression) || !((bexpr = (BinaryExpression)((ExpressionStatement)element).getExpression()).getLeftExpression() instanceof FieldExpression) || (f = ((FieldExpression)bexpr.getLeftExpression()).getField()) == null || !f.isStatic() || bexpr.getRightExpression() == null) continue;
                VariableScope fieldScope = new VariableScope(currentScope, f, true);
                this.scopes.push(fieldScope);
                try {
                    bexpr.getRightExpression().visit(this);
                }
                finally {
                    this.scopes.pop();
                }
            }
        }
        for (Statement element : node.getObjectInitializerStatements()) {
            element.visit(this);
        }
        for (ConstructorNode constructor : node.getDeclaredConstructors()) {
            if (!constructor.isSynthetic() || constructor.getParameters() != null && constructor.getParameters().length != 0) continue;
            this.visitConstructor(constructor);
        }
    }

    public void visitField(FieldNode node) {
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        this.assignmentStorer.storeField(node, scope);
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        scope.setPrimaryNode(false);
        ITypeRequestor.VisitStatus status = this.notifyRequestor(node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                ClassNode fieldType = node.getType();
                if (fieldType != node.getDeclaringClass()) {
                    this.visitClassReference(fieldType);
                }
                this.visitAnnotations(node);
                Expression init = node.getInitialExpression();
                if (init != null) {
                    init.visit(this);
                }
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    private void visitClassReference(ClassNode node) {
        if (node.isGenericsPlaceHolder()) {
            return;
        }
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        scope.setPrimaryNode(false);
        ITypeRequestor.VisitStatus status = this.notifyRequestor(node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                if (!node.isEnum()) {
                    this.visitGenerics(node);
                }
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    private void visitGenerics(ClassNode node) {
        if (node.isUsingGenerics() && node.getGenericsTypes() != null) {
            GenericsType[] genericsTypeArray = node.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gen = genericsTypeArray[n2];
                if (gen.getLowerBound() != null) {
                    this.visitClassReference(gen.getLowerBound());
                }
                if (gen.getUpperBounds() != null) {
                    ClassNode[] classNodeArray = gen.getUpperBounds();
                    int n3 = classNodeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ClassNode upper = classNodeArray[n4];
                        if (!upper.getName().equals(node.getName())) {
                            this.visitClassReference(upper);
                        }
                        ++n4;
                    }
                }
                if (gen.getType() != null && gen.getName().charAt(0) != '?') {
                    this.visitClassReference(gen.getType());
                }
                ++n2;
            }
        }
    }

    public void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        scope.setPrimaryNode(false);
        ITypeRequestor.VisitStatus status = this.notifyRequestor(node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                ASTNode[] aSTNodeArray;
                GenericsType[] gens = node.getGenericsTypes();
                if (gens != null) {
                    aSTNodeArray = gens;
                    int n3 = gens.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ASTNode gen = aSTNodeArray[n4];
                        if (((GenericsType)gen).getLowerBound() != null) {
                            this.visitClassReference(((GenericsType)gen).getLowerBound());
                        }
                        if (((GenericsType)gen).getUpperBounds() != null) {
                            ClassNode[] classNodeArray = ((GenericsType)gen).getUpperBounds();
                            int n5 = classNodeArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                ClassNode upper = classNodeArray[n6];
                                this.visitClassReference(upper);
                                ++n6;
                            }
                        }
                        if (((GenericsType)gen).getType() != null && ((GenericsType)gen).getType().getName().charAt(0) != '?') {
                            this.visitClassReference(((GenericsType)gen).getType());
                        }
                        ++n4;
                    }
                }
                this.visitClassReference(node.getReturnType());
                if (node.getExceptions() != null) {
                    aSTNodeArray = node.getExceptions();
                    int n7 = aSTNodeArray.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        ASTNode e = aSTNodeArray[n8];
                        this.visitClassReference((ClassNode)e);
                        ++n8;
                    }
                }
                if (this.handleParameterList(node.getParameters())) {
                    super.visitConstructorOrMethod(node, isConstructor);
                }
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    public void visitAnnotations(AnnotatedNode node) {
        for (AnnotationNode annotation : node.getAnnotations()) {
            this.visitAnnotation(annotation);
        }
        super.visitAnnotations(node);
    }

    public void visitImports(ModuleNode node) {
        block11: for (ImportNode imp : new ImportNodeCompatibilityWrapper(node).getAllImportNodes()) {
            TypeLookupResult result = null;
            IJavaElement oldEnclosingElement = this.enclosingElement;
            this.visitAnnotations(imp);
            ClassNode type = imp.getType();
            if (type != null) {
                String importName = String.valueOf(imp.getClassName().replace('$', '.')) + (imp.getFieldName() != null ? "." + imp.getFieldName() : "");
                this.enclosingElement = this.unit.getImport(importName);
                if (!this.enclosingElement.exists()) {
                    this.enclosingElement = oldEnclosingElement;
                }
            }
            try {
                VariableScope scope = this.scopes.peek();
                scope.setPrimaryNode(false);
                this.assignmentStorer.storeImport(imp, scope);
                ITypeLookup[] iTypeLookupArray = this.lookups;
                int n = this.lookups.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeLookup lookup = iTypeLookupArray[n2];
                    TypeLookupResult candidate = lookup.lookupType(imp, scope);
                    if (candidate != null) {
                        if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                            result = candidate;
                        }
                        if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
                    }
                    ++n2;
                }
                ITypeRequestor.VisitStatus status = this.notifyRequestor(imp, this.requestor, result);
                switch (status) {
                    case CONTINUE: {
                        try {
                            if (type == null) continue block11;
                            this.visitClassReference(type);
                            this.completeExpressionStack.push(imp);
                            if (imp.getFieldNameExpr() != null) {
                                this.primaryTypeStack.push(type);
                                imp.getFieldNameExpr().visit(this);
                                this.dependentDeclaringTypeStack.pop();
                                this.dependentTypeStack.pop();
                            }
                            this.completeExpressionStack.pop();
                            continue block11;
                        }
                        catch (VisitCompleted e) {
                            if (e.status != ITypeRequestor.VisitStatus.STOP_VISIT) continue block11;
                            throw e;
                        }
                    }
                    case CANCEL_BRANCH: 
                    case CANCEL_MEMBER: {
                        return;
                    }
                    case STOP_VISIT: {
                        throw new VisitCompleted(status);
                    }
                }
            }
            finally {
                this.enclosingElement = oldEnclosingElement;
            }
        }
    }

    public void visitVariableExpression(VariableExpression node) {
        this.scopes.peek().setCurrentNode(node);
        this.visitAnnotations(node);
        if (node.getAccessedVariable() == node) {
            this.visitClassReference(node.getType());
        }
        this.handleSimpleExpression(node);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitArgumentlistExpression(ArgumentListExpression node) {
        this.visitTupleExpression(node);
    }

    public void visitArrayExpression(ArrayExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitArrayExpression(node);
        }
    }

    public void visitAttributeExpression(AttributeExpression node) {
        this.visitPropertyExpression(node);
    }

    public void visitBinaryExpression(BinaryExpression node) {
        Expression toVisitDependent;
        Expression toVisitPrimary;
        if (this.isDependentExpression(node)) {
            this.primaryTypeStack.pop();
        }
        if (node.getEnd() == 0) {
            return;
        }
        this.visitAnnotations(node);
        boolean isAssignment = node.getOperation().getType() == 100;
        BinaryExpression oldEnclosingAssignment = this.enclosingAssignment;
        if (isAssignment) {
            this.enclosingAssignment = node;
        }
        this.completeExpressionStack.push(node);
        if (isAssignment) {
            toVisitPrimary = node.getRightExpression();
            toVisitDependent = node.getLeftExpression();
        } else {
            toVisitPrimary = node.getLeftExpression();
            toVisitDependent = node.getRightExpression();
        }
        toVisitPrimary.visit(this);
        ClassNode primaryExprType = this.primaryTypeStack.pop();
        if (isAssignment) {
            this.assignmentStorer.storeAssignment(node, this.scopes.peek(), primaryExprType);
        }
        toVisitDependent.visit(this);
        this.completeExpressionStack.pop();
        ClassNode completeExprType = primaryExprType;
        ClassNode dependentExprType = this.primaryTypeStack.pop();
        if (!isAssignment) {
            String associatedMethod = this.findBinaryOperatorName(node.getOperation().getText());
            if (this.isArithmeticOperationOnNumberOrStringOrList(node.getOperation().getText(), primaryExprType, dependentExprType)) {
                completeExprType = dependentExprType.equals(VariableScope.STRING_CLASS_NODE) ? VariableScope.STRING_CLASS_NODE : primaryExprType;
            } else if (associatedMethod != null) {
                TypeLookupResult result = this.lookupExpressionType(new ConstantExpression(associatedMethod), primaryExprType, false, this.scopes.peek());
                completeExprType = result.type;
                if (associatedMethod.equals("getAt") && result.declaringType.equals(VariableScope.DGM_CLASS_NODE)) {
                    if (primaryExprType.getName().equals("java.util.BitSet")) {
                        completeExprType = VariableScope.BOOLEAN_CLASS_NODE;
                    } else {
                        GenericsType[] lhsGenericsTypes = primaryExprType.getGenericsTypes();
                        ClassNode elementType = VariableScope.MAP_CLASS_NODE.equals(primaryExprType) && lhsGenericsTypes != null && lhsGenericsTypes.length == 2 ? lhsGenericsTypes[1].getType() : VariableScope.extractElementType(primaryExprType);
                        completeExprType = dependentExprType.isArray() || dependentExprType.getName().equals(VariableScope.LIST_CLASS_NODE.getName()) || dependentExprType.implementsInterface(VariableScope.LIST_CLASS_NODE) ? this.createParameterizedList(elementType) : elementType;
                    }
                }
            } else {
                completeExprType = this.findTypeOfBinaryExpression(node.getOperation().getText(), primaryExprType, dependentExprType);
            }
        }
        this.handleCompleteExpression(node, completeExprType, null);
        this.enclosingAssignment = oldEnclosingAssignment;
    }

    private boolean isArithmeticOperationOnNumberOrStringOrList(String text, ClassNode lhs, ClassNode rhs) {
        if (text.length() != 1) {
            return false;
        }
        switch (text.charAt(0)) {
            case '+': 
            case '-': {
                return VariableScope.STRING_CLASS_NODE.equals(lhs) || lhs.isDerivedFrom(VariableScope.NUMBER_CLASS_NODE) || VariableScope.NUMBER_CLASS_NODE.equals(lhs) || VariableScope.LIST_CLASS_NODE.equals(lhs) || lhs.implementsInterface(VariableScope.LIST_CLASS_NODE);
            }
            case '%': 
            case '*': 
            case '/': {
                return VariableScope.STRING_CLASS_NODE.equals(lhs) || lhs.isDerivedFrom(VariableScope.NUMBER_CLASS_NODE) || VariableScope.NUMBER_CLASS_NODE.equals(lhs);
            }
        }
        return false;
    }

    private String findBinaryOperatorName(String text) {
        char op = text.charAt(0);
        switch (op) {
            case '+': {
                return "plus";
            }
            case '-': {
                return "minus";
            }
            case '*': {
                if (text.length() > 1 && text.equals("**")) {
                    return "power";
                }
                return "multiply";
            }
            case '/': {
                return "divide";
            }
            case '%': {
                return "mod";
            }
            case '&': {
                return "and";
            }
            case '|': {
                return "or";
            }
            case '^': {
                return "xor";
            }
            case '>': {
                if (text.length() <= 1 || !text.equals(">>")) break;
                return "rightShift";
            }
            case '<': {
                if (text.length() <= 1 || !text.equals("<<")) break;
                return "leftShift";
            }
            case '[': {
                return "getAt";
            }
        }
        return null;
    }

    private String findUnaryOperatorName(String text) {
        char op = text.charAt(0);
        switch (op) {
            case '+': {
                if (text.length() > 1 && text.equals("++")) {
                    return "next";
                }
                return "positive";
            }
            case '-': {
                if (text.length() > 1 && text.equals("--")) {
                    return "previous";
                }
                return "negative";
            }
            case ']': {
                return "putAt";
            }
            case '~': {
                return "bitwiseNegate";
            }
        }
        return null;
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression node) {
        this.visitUnaryExpression(node, node.getExpression(), "~");
    }

    public void visitBooleanExpression(BooleanExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitBooleanExpression(node);
        }
    }

    public void visitEmptyExpression(EmptyExpression node) {
        this.handleSimpleExpression(node);
    }

    public void visitBytecodeExpression(BytecodeExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitBytecodeExpression(node);
        }
    }

    public void visitCastExpression(CastExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            this.visitClassReference(node.getType());
            super.visitCastExpression(node);
        }
    }

    public void visitClassExpression(ClassExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitClassExpression(node);
        }
    }

    public void visitClosureExpression(ClosureExpression node) {
        VariableScope parent = this.scopes.peek();
        ClosureExpression enclosingClosure = parent.getEnclosingClosure();
        VariableScope scope = new VariableScope(parent, node, false);
        this.scopes.push(scope);
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            ClassNode thisType;
            ClassNode[] implicitParamType = this.findImplicitParamType(scope, node);
            if (node.getParameters() != null && node.getParameters().length > 0) {
                this.handleParameterList(node.getParameters());
                int i = 0;
                while (i < node.getParameters().length) {
                    Parameter parameter = node.getParameters()[i];
                    if (implicitParamType[i] != VariableScope.OBJECT_CLASS_NODE && parameter.getType().equals(VariableScope.OBJECT_CLASS_NODE)) {
                        parameter.setType(implicitParamType[i]);
                        scope.addVariable(parameter);
                    }
                    ++i;
                }
            } else if (implicitParamType[0] != VariableScope.OBJECT_CLASS_NODE && !scope.containsInThisScope("it")) {
                scope.addVariable("it", implicitParamType[0], VariableScope.OBJECT_CLASS_NODE);
            }
            VariableScope.CallAndType cat = scope.getEnclosingMethodCallExpression();
            if (cat != null) {
                scope.addVariable("delegate", cat.declaringType, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getDelegate", cat.declaringType, VariableScope.CLOSURE_CLASS);
            } else {
                thisType = scope.getThis();
                scope.addVariable("delegate", thisType, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getDelegate", thisType, VariableScope.CLOSURE_CLASS);
            }
            if (enclosingClosure != null) {
                scope.addVariable("owner", VariableScope.CLOSURE_CLASS, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getOwner", VariableScope.CLOSURE_CLASS, VariableScope.CLOSURE_CLASS);
            } else {
                thisType = scope.getThis();
                scope.addVariable("owner", thisType, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getOwner", thisType, VariableScope.CLOSURE_CLASS);
                scope.addVariable("thisObject", VariableScope.OBJECT_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getThisObject", VariableScope.OBJECT_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("resolveStategy", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getResolveStategy", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("directive", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getDirective", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("maximumNumberOfParameters", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getMaximumNumberOfParameters", VariableScope.INTEGER_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("parameterTypes", VariableScope.CLASS_ARRAY_CLASS_NODE, VariableScope.CLOSURE_CLASS);
                scope.addVariable("getParameterTypes", VariableScope.CLASS_ARRAY_CLASS_NODE, VariableScope.CLOSURE_CLASS);
            }
            super.visitClosureExpression(node);
        }
        this.scopes.pop();
    }

    private ClassNode[] findImplicitParamType(VariableScope scope, ClosureExpression closure) {
        int numParams;
        int n = numParams = closure.getParameters() == null ? 0 : closure.getParameters().length;
        if (numParams == 0) {
            ++numParams;
        }
        Object[] allInferred = new ClassNode[numParams];
        VariableScope.CallAndType call = scope.getEnclosingMethodCallExpression();
        if (call != null) {
            String methodName = call.call.getMethodAsString();
            ClassNode delegateType = call.declaringType;
            ClassNode inferredType = dgmClosureMethods.contains(methodName) ? VariableScope.extractElementType(delegateType) : (dgmClosureIdentityMethods.contains(methodName) ? VariableScope.clone(delegateType) : dgmClosureMethodsMap.get(methodName));
            if (inferredType != null) {
                GenericsType[] typeParams;
                Arrays.fill(allInferred, inferredType);
                if (methodName.equals("eachWithIndex") && allInferred.length > 1) {
                    allInferred[allInferred.length - 1] = VariableScope.INTEGER_CLASS_NODE;
                }
                if (delegateType.getName().equals(VariableScope.MAP_CLASS_NODE.getName()) && (dgmClosureMaybeMap.contains(methodName) && numParams == 2 || methodName.equals("eachWithIndex") && numParams == 3) && (typeParams = inferredType.getGenericsTypes()) != null && typeParams.length == 2) {
                    allInferred[0] = typeParams[0].getType();
                    allInferred[1] = typeParams[1].getType();
                }
                return allInferred;
            }
        }
        Arrays.fill(allInferred, VariableScope.OBJECT_CLASS_NODE);
        return allInferred;
    }

    public void visitBlockStatement(BlockStatement block) {
        this.scopes.push(new VariableScope(this.scopes.peek(), block, false));
        boolean shouldContinue = this.handleStatement(block);
        if (shouldContinue) {
            super.visitBlockStatement(block);
        }
        this.scopes.pop();
    }

    public void visitReturnStatement(ReturnStatement ret) {
        boolean shouldContinue = this.handleStatement(ret);
        if (shouldContinue) {
            if (ret.getExpression() instanceof AnnotationConstantExpression) {
                this.visitClassReference(((AnnotationConstantExpression)ret.getExpression()).getType());
            }
            super.visitReturnStatement(ret);
        }
    }

    public void visitForLoop(ForStatement node) {
        this.completeExpressionStack.push(node);
        node.getCollectionExpression().visit(this);
        this.completeExpressionStack.pop();
        ClassNode collectionType = this.primaryTypeStack.pop();
        this.scopes.push(new VariableScope(this.scopes.peek(), node, false));
        Parameter param = node.getVariable();
        if (param != null) {
            this.handleParameterList(new Parameter[]{param});
            if (param.getType().equals(VariableScope.OBJECT_CLASS_NODE)) {
                ClassNode extractedElementType = VariableScope.extractElementType(collectionType);
                this.scopes.peek().addVariable(param.getName(), extractedElementType, null);
            }
        }
        node.getLoopBlock().visit(this);
        this.scopes.pop();
    }

    public void visitCatchStatement(CatchStatement node) {
        this.scopes.push(new VariableScope(this.scopes.peek(), node, false));
        Parameter param = node.getVariable();
        if (param != null) {
            this.handleParameterList(new Parameter[]{param});
        }
        super.visitCatchStatement(node);
        this.scopes.pop();
    }

    public void visitClosureListExpression(ClosureListExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitClosureListExpression(node);
        }
    }

    public void visitConstantExpression(ConstantExpression node) {
        this.scopes.peek().setCurrentNode(node);
        this.handleSimpleExpression(node);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitConstructorCallExpression(ConstructorCallExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            Expression arg;
            this.visitClassReference(node.getType());
            if (node.getArguments() instanceof TupleExpression && ((TupleExpression)node.getArguments()).getExpressions().size() == 1 && (arg = ((TupleExpression)node.getArguments()).getExpressions().get(0)) instanceof MapExpression) {
                this.enclosingConstructorCall = node;
            }
            super.visitConstructorCallExpression(node);
        }
    }

    public void visitDeclarationExpression(DeclarationExpression node) {
        this.visitBinaryExpression(node);
    }

    public void visitFieldExpression(FieldExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitFieldExpression(node);
        }
    }

    public void visitGStringExpression(GStringExpression node) {
        this.scopes.peek().setCurrentNode(node);
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitGStringExpression(node);
        }
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitListExpression(ListExpression node) {
        if (this.isDependentExpression(node)) {
            this.primaryTypeStack.pop();
        }
        this.scopes.peek().setCurrentNode(node);
        this.completeExpressionStack.push(node);
        super.visitListExpression(node);
        ClassNode eltType = node.getExpressions().size() > 0 ? this.primaryTypeStack.pop() : VariableScope.OBJECT_CLASS_NODE;
        this.completeExpressionStack.pop();
        ClassNode exprType = this.createParameterizedList(eltType);
        this.handleCompleteExpression(node, exprType, null);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitMapEntryExpression(MapEntryExpression node) {
        if (this.isDependentExpression(node)) {
            this.primaryTypeStack.pop();
        }
        this.scopes.peek().setCurrentNode(node);
        this.completeExpressionStack.push(node);
        node.getKeyExpression().visit(this);
        ClassNode k = this.primaryTypeStack.pop();
        node.getValueExpression().visit(this);
        ClassNode v = this.primaryTypeStack.pop();
        this.completeExpressionStack.pop();
        ClassNode exprType = this.isPrimaryExpression(node) ? this.createParameterizedMap(k, v) : VariableScope.OBJECT_CLASS_NODE;
        this.handleCompleteExpression(node, exprType, null);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitMapExpression(MapExpression node) {
        ClassNode newType;
        if (this.isDependentExpression(node)) {
            this.primaryTypeStack.pop();
        }
        if (this.enclosingConstructorCall != null) {
            newType = this.enclosingConstructorCall.getType();
            this.enclosingConstructorCall = null;
        } else {
            newType = null;
        }
        this.scopes.peek().setCurrentNode(node);
        this.completeExpressionStack.push(node);
        if (newType == null) {
            for (MapEntryExpression entry : node.getMapEntryExpressions()) {
                entry.visit(this);
            }
        } else {
            for (MapEntryExpression entry : node.getMapEntryExpressions()) {
                Expression key = entry.getKeyExpression();
                if (key instanceof ConstantExpression) {
                    String fieldName = key.getText();
                    FieldNode field = newType.getField(fieldName);
                    if (field != null) {
                        TypeLookupResult result = new TypeLookupResult(field.getType(), field.getDeclaringClass(), field, TypeLookupResult.TypeConfidence.EXACT, this.scopes.peek());
                        this.handleRequestor(key, newType, result);
                    } else {
                        this.handleSimpleExpression(key);
                    }
                } else {
                    this.handleSimpleExpression(key);
                }
                this.handleSimpleExpression(entry.getValueExpression());
            }
        }
        this.completeExpressionStack.pop();
        ClassNode exprType = node.getMapEntryExpressions().size() > 0 && newType == null ? this.primaryTypeStack.pop() : this.createParameterizedMap(VariableScope.OBJECT_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE);
        this.handleCompleteExpression(node, exprType, null);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitMethodCallExpression(MethodCallExpression node) {
        this.scopes.peek().setCurrentNode(node);
        if (this.isDependentExpression(node)) {
            this.primaryTypeStack.pop();
        }
        this.completeExpressionStack.push(node);
        node.getObjectExpression().visit(this);
        if (node.isSpreadSafe()) {
            ClassNode objType = this.primaryTypeStack.pop();
            this.primaryTypeStack.push(VariableScope.extractElementType(objType));
        }
        node.getMethod().visit(this);
        ClassNode exprType = this.dependentTypeStack.pop();
        ClassNode exprDeclaringType = this.dependentDeclaringTypeStack.pop();
        VariableScope.CallAndType call = new VariableScope.CallAndType(node, exprDeclaringType);
        this.completeExpressionStack.pop();
        ClassNode catNode = this.isCategoryDeclaration(node);
        if (catNode != null) {
            this.addCategoryToBeDeclared(catNode);
        }
        VariableScope scope = this.scopes.peek();
        scope.addEnclosingMethodCall(call);
        node.getArguments().visit(this);
        scope.forgetEnclosingMethodCall();
        if (node.isSpreadSafe()) {
            exprType = this.createParameterizedList(exprType);
        }
        this.handleCompleteExpression(node, exprType, exprDeclaringType);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitMethodPointerExpression(MethodPointerExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitMethodPointerExpression(node);
        }
    }

    public void visitNotExpression(NotExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitNotExpression(node);
        }
    }

    public void visitPostfixExpression(PostfixExpression node) {
        this.visitUnaryExpression(node, node.getExpression(), node.getOperation().getText());
    }

    public void visitPrefixExpression(PrefixExpression node) {
        this.visitUnaryExpression(node, node.getExpression(), node.getOperation().getText());
    }

    private void visitUnaryExpression(Expression node, Expression expression, String operation) {
        ClassNode completeExprType;
        this.scopes.peek().setCurrentNode(node);
        this.completeExpressionStack.push(node);
        if (this.isDependentExpression(node)) {
            this.primaryTypeStack.pop();
        }
        expression.visit(this);
        ClassNode primaryType = this.primaryTypeStack.pop();
        String associatedMethod = this.findUnaryOperatorName(operation);
        if (associatedMethod == null && primaryType.equals(VariableScope.NUMBER_CLASS_NODE) || primaryType.isDerivedFrom(VariableScope.NUMBER_CLASS_NODE)) {
            completeExprType = primaryType;
        } else {
            TypeLookupResult result = this.lookupExpressionType(new ConstantExpression(associatedMethod), primaryType, false, this.scopes.peek());
            completeExprType = result.type;
        }
        this.completeExpressionStack.pop();
        this.handleCompleteExpression(node, completeExprType, null);
    }

    public void visitPropertyExpression(PropertyExpression node) {
        ClassNode objType;
        this.scopes.peek().setCurrentNode(node);
        this.completeExpressionStack.push(node);
        node.getObjectExpression().visit(this);
        if (this.isDependentExpression(node)) {
            this.primaryTypeStack.pop();
        }
        if (node.isSpreadSafe()) {
            objType = this.primaryTypeStack.pop();
            objType = VariableScope.extractElementType(objType);
            this.primaryTypeStack.push(objType);
        } else {
            objType = this.primaryTypeStack.peek();
        }
        node.getProperty().visit(this);
        ClassNode exprType = this.dependentTypeStack.pop();
        this.dependentDeclaringTypeStack.pop();
        this.completeExpressionStack.pop();
        if (node.isSpreadSafe()) {
            if (objType.equals(VariableScope.MAP_CLASS_NODE) && objType.getGenericsTypes() != null && objType.getGenericsTypes().length == 2) {
                exprType = objType.getGenericsTypes()[1].getType();
            }
            exprType = this.createParameterizedList(exprType);
        }
        this.handleCompleteExpression(node, exprType, null);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitRangeExpression(RangeExpression node) {
        if (this.isDependentExpression(node)) {
            this.primaryTypeStack.pop();
        }
        this.scopes.peek().setCurrentNode(node);
        this.completeExpressionStack.push(node);
        super.visitRangeExpression(node);
        ClassNode eltType = this.primaryTypeStack.pop();
        this.completeExpressionStack.pop();
        ClassNode rangeType = this.createParameterizedRange(eltType);
        this.handleCompleteExpression(node, rangeType, null);
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression node) {
        if (this.isDependentExpression(node)) {
            this.primaryTypeStack.pop();
        }
        this.completeExpressionStack.push(node);
        node.getTrueExpression().visit(this);
        ClassNode exprType = this.primaryTypeStack.pop();
        this.completeExpressionStack.pop();
        node.getFalseExpression().visit(this);
        this.handleCompleteExpression(node, exprType, null);
    }

    public void visitSpreadExpression(SpreadExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitSpreadExpression(node);
        }
    }

    public void visitSpreadMapExpression(SpreadMapExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitSpreadMapExpression(node);
        }
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue && node.getEnd() > 0) {
            this.visitClassReference(node.getOwnerType());
            super.visitStaticMethodCallExpression(node);
        }
    }

    public void visitTernaryExpression(TernaryExpression node) {
        if (this.isDependentExpression(node)) {
            this.primaryTypeStack.pop();
        }
        this.completeExpressionStack.push(node);
        node.getBooleanExpression().visit(this);
        node.getTrueExpression().visit(this);
        ClassNode exprType = this.primaryTypeStack.pop();
        node.getFalseExpression().visit(this);
        this.completeExpressionStack.pop();
        this.handleCompleteExpression(node, exprType, null);
    }

    public void visitTupleExpression(TupleExpression node) {
        boolean shouldContinue = this.handleSimpleExpression(node);
        if (shouldContinue) {
            super.visitTupleExpression(node);
        }
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression node) {
        this.visitUnaryExpression(node, node.getExpression(), "-");
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression node) {
        this.visitUnaryExpression(node, node.getExpression(), "+");
    }

    private void visitAnnotation(AnnotationNode node) {
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        ITypeRequestor.VisitStatus status = this.notifyRequestor(node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                this.visitClassReference(node.getClassNode());
                if (node.getMembers() == null) break;
                Collection<Expression> exprs = node.getMembers().values();
                for (Expression expr : exprs) {
                    if (expr instanceof AnnotationConstantExpression) {
                        this.visitClassReference(((AnnotationConstantExpression)expr).getType());
                    }
                    expr.visit(this);
                }
                break;
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    private boolean handleStatement(Statement node) {
        VariableScope scope = this.scopes.peek();
        ClassNode declaring = scope.getDelegateOrThis();
        scope.setPrimaryNode(false);
        if (node instanceof BlockStatement) {
            ITypeLookup[] iTypeLookupArray = this.lookups;
            int n = this.lookups.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeLookup lookup = iTypeLookupArray[n2];
                if (lookup instanceof ITypeLookupExtension) {
                    ((ITypeLookupExtension)lookup).lookupInBlock((BlockStatement)node, scope);
                }
                ++n2;
            }
        }
        TypeLookupResult noLookup = new TypeLookupResult(declaring, declaring, declaring, TypeLookupResult.TypeConfidence.EXACT, scope);
        ITypeRequestor.VisitStatus status = this.notifyRequestor(node, this.requestor, noLookup);
        switch (status) {
            case CONTINUE: {
                return true;
            }
            case CANCEL_BRANCH: {
                return false;
            }
        }
        throw new VisitCompleted(status);
    }

    private boolean handleSimpleExpression(Expression node) {
        boolean isStatic;
        ClassNode primaryType;
        VariableScope scope = this.scopes.peek();
        if (this.isDependentExpression(node)) {
            primaryType = this.primaryTypeStack.pop();
            if (this.isImplicitThis()) {
                primaryType = null;
            }
            isStatic = this.hasStaticObjectExpression(node);
            scope.setMethodCallNumberOfArguments(this.getMethodCallArgs());
        } else {
            primaryType = null;
            isStatic = false;
        }
        scope.setPrimaryNode(primaryType == null);
        TypeLookupResult result = this.lookupExpressionType(node, primaryType, isStatic, scope);
        return this.handleRequestor(node, primaryType, result);
    }

    protected boolean isImplicitThis() {
        return this.completeExpressionStack.peek() instanceof MethodCallExpression && ((MethodCallExpression)this.completeExpressionStack.peek()).isImplicitThis();
    }

    private void handleCompleteExpression(Expression node, ClassNode exprType, ClassNode exprDeclaringType) {
        VariableScope scope = this.scopes.peek();
        scope.setPrimaryNode(false);
        this.handleRequestor(node, exprDeclaringType, new TypeLookupResult(exprType, exprDeclaringType, node, TypeLookupResult.TypeConfidence.EXACT, scope));
    }

    private void postVisit(Expression node, ClassNode type, ClassNode declaringType) {
        if (this.isPrimaryExpression(node)) {
            this.primaryTypeStack.push(type);
        } else if (this.isDependentExpression(node)) {
            this.dependentTypeStack.push(type);
            this.dependentDeclaringTypeStack.push(declaringType);
        }
    }

    private TypeLookupResult lookupExpressionType(Expression node, ClassNode objectExprType, boolean isStatic, VariableScope scope) {
        TypeLookupResult result = null;
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup instanceof ITypeLookupExtension ? ((ITypeLookupExtension)lookup).lookupType(node, scope, objectExprType, isStatic) : lookup.lookupType(node, scope, objectExprType);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        return result;
    }

    private int getMethodCallArgs() {
        ASTNode peek = this.completeExpressionStack.peek();
        if (peek instanceof MethodCallExpression) {
            MethodCallExpression call = (MethodCallExpression)peek;
            Expression arguments = call.getArguments();
            if (arguments instanceof ArgumentListExpression) {
                ArgumentListExpression list = (ArgumentListExpression)arguments;
                List<Expression> expressions = list.getExpressions();
                return expressions != null ? expressions.size() : 0;
            }
            return 0;
        }
        return -1;
    }

    private boolean handleParameterList(Parameter[] params) {
        if (params != null) {
            VariableScope scope = this.scopes.peek();
            Parameter[] parameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter node = parameterArray[n2];
                this.assignmentStorer.storeParameterType(node, scope);
                TypeLookupResult result = null;
                ITypeLookup[] iTypeLookupArray = this.lookups;
                int n3 = this.lookups.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeLookup lookup = iTypeLookupArray[n4];
                    lookup.lookupType(node, scope);
                    result = lookup.lookupType(node.getType(), scope);
                    TypeLookupResult candidate = lookup.lookupType(node.getType(), scope);
                    if (candidate != null) {
                        if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                            result = candidate;
                        }
                        if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
                    }
                    ++n4;
                }
                TypeLookupResult parameterResult = new TypeLookupResult(result.type, result.declaringType, node, TypeLookupResult.TypeConfidence.EXACT, scope);
                scope.setPrimaryNode(false);
                ITypeRequestor.VisitStatus status = this.notifyRequestor(node, this.requestor, parameterResult);
                switch (status) {
                    case CONTINUE: {
                        break;
                    }
                    case CANCEL_BRANCH: {
                        return false;
                    }
                    case CANCEL_MEMBER: 
                    case STOP_VISIT: {
                        throw new VisitCompleted(status);
                    }
                }
                this.visitClassReference(node.getType());
                this.visitAnnotations(node);
                Expression init = node.getInitialExpression();
                if (init != null) {
                    init.visit(this);
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean handleRequestor(Expression node, ClassNode primaryType, TypeLookupResult result) {
        result.enclosingAssignment = this.enclosingAssignment;
        ITypeRequestor.VisitStatus status = this.requestor.acceptASTNode(node, result, this.enclosingElement);
        VariableScope scope = this.scopes.peek();
        scope.setMethodCallNumberOfArguments(-1);
        ClassNode rememberedDeclaringType = result.declaringType;
        if (scope.getCategoryNames().contains(rememberedDeclaringType)) {
            ClassNode classNode = rememberedDeclaringType = primaryType != null ? primaryType : scope.getDelegateOrThis();
        }
        if (rememberedDeclaringType == null) {
            rememberedDeclaringType = VariableScope.OBJECT_CLASS_NODE;
        }
        switch (status) {
            case CONTINUE: {
                this.postVisit(node, result.type, rememberedDeclaringType);
                return true;
            }
            case CANCEL_BRANCH: {
                this.postVisit(node, result.type, rememberedDeclaringType);
                return false;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
        return false;
    }

    private ITypeRequestor.VisitStatus notifyRequestor(ASTNode node, ITypeRequestor requestor, TypeLookupResult result) {
        return requestor.acceptASTNode(node, result, this.enclosingElement);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private MethodNode findMethodNode(IMethod method) {
        ClassNode clazz = this.findClassWithName(this.createName(method.getDeclaringType()));
        try {
            if (method.isConstructor()) {
                List<ConstructorNode> constructors = clazz.getDeclaredConstructors();
                if (constructors.size() == 0) {
                    return null;
                }
                block2: for (ConstructorNode constructorNode : constructors) {
                    Parameter[] groovyParams;
                    String[] jdtParamTypes = method.getParameterTypes() == null ? new String[]{} : method.getParameterTypes();
                    Parameter[] parameterArray = groovyParams = constructorNode.getParameters() == null ? new Parameter[]{} : constructorNode.getParameters();
                    if (groovyParams != null && groovyParams.length > 0 && groovyParams[0].getName().startsWith("$")) {
                        Parameter[] newGroovyParams = new Parameter[groovyParams.length - 1];
                        System.arraycopy(groovyParams, 1, newGroovyParams, 0, newGroovyParams.length);
                        groovyParams = newGroovyParams;
                    }
                    if (groovyParams.length != jdtParamTypes.length) continue;
                    int i = 0;
                    while (i < groovyParams.length) {
                        String groovyClassType = groovyParams[i].getType().getName();
                        if (!groovyClassType.startsWith("[")) {
                            groovyClassType = Signature.createTypeSignature(groovyClassType, false);
                        }
                        if (!groovyClassType.equals(jdtParamTypes[i])) continue block2;
                        ++i;
                    }
                    return constructorNode;
                }
                return constructors.get(0);
            }
            List<MethodNode> methods = clazz.getMethods(method.getElementName());
            if (methods.size() == 0) {
                return null;
            }
            block4: for (MethodNode methodNode : methods) {
                Parameter[] groovyParams;
                String[] jdtParamTypes = method.getParameterTypes() == null ? new String[]{} : method.getParameterTypes();
                Parameter[] parameterArray = groovyParams = methodNode.getParameters() == null ? new Parameter[]{} : methodNode.getParameters();
                if (groovyParams.length != jdtParamTypes.length) continue;
                int i = 0;
                while (i < groovyParams.length) {
                    String simpleGroovyClassType = groovyParams[i].getType().getNameWithoutPackage();
                    if (!simpleGroovyClassType.startsWith("[")) {
                        simpleGroovyClassType = Signature.createTypeSignature(simpleGroovyClassType, false);
                    }
                    if (!simpleGroovyClassType.equals(jdtParamTypes[i])) {
                        String groovyClassType = groovyParams[i].getType().getName();
                        if (!groovyClassType.startsWith("[")) {
                            groovyClassType = Signature.createTypeSignature(groovyClassType, false);
                        }
                        if (!groovyClassType.equals(jdtParamTypes[i])) continue block4;
                    }
                    ++i;
                }
                return methodNode;
            }
            return methods.get(0);
        }
        catch (JavaModelException e) {
            Util.log(e, "Exception finding method " + method.getElementName() + " in class " + clazz.getName());
            return null;
        }
    }

    private FieldNode findFieldNode(IField field) {
        ClassNode clazz = this.findClassWithName(this.createName(field.getDeclaringType()));
        FieldNode fieldNode = clazz.getField(field.getElementName());
        if (fieldNode == null) {
            fieldNode = clazz.getField("$" + field.getElementName());
        }
        return fieldNode;
    }

    private ClassNode createParameterizedList(ClassNode propType) {
        ClassNode list = VariableScope.clonedList();
        list.getGenericsTypes()[0].setType(propType);
        list.getGenericsTypes()[0].setName(propType.getName());
        return list;
    }

    private ClassNode createParameterizedRange(ClassNode propType) {
        ClassNode range = VariableScope.clonedRange();
        range.getGenericsTypes()[0].setType(propType);
        range.getGenericsTypes()[0].setName(propType.getName());
        return range;
    }

    private ClassNode createParameterizedMap(ClassNode k, ClassNode v) {
        ClassNode map = VariableScope.clonedMap();
        map.getGenericsTypes()[0].setType(k);
        map.getGenericsTypes()[0].setName(k.getName());
        map.getGenericsTypes()[1].setType(v);
        map.getGenericsTypes()[1].setName(v.getName());
        return map;
    }

    private boolean isLazy(FieldNode field) {
        List<AnnotationNode> annotations = field.getAnnotations();
        for (AnnotationNode annotation : annotations) {
            if (!annotation.getClassNode().getName().equals("groovy.lang.Lazy")) continue;
            return true;
        }
        return false;
    }

    protected SourceUnit getSourceUnit() {
        return null;
    }

    private ClassNode findClassWithName(String simpleName) {
        for (ClassNode clazz : this.getModuleNode().getClasses()) {
            if (!clazz.getNameWithoutPackage().equals(simpleName)) continue;
            return clazz;
        }
        return null;
    }

    private ModuleNodeMapper.ModuleNodeInfo createModuleNode(GroovyCompilationUnit unit) {
        if (unit.getOwner() == null || unit.owner == DefaultWorkingCopyOwner.PRIMARY) {
            return unit.getModuleInfo(true);
        }
        return unit.getNewModuleInfo();
    }

    private ModuleNode getModuleNode() {
        if (this.enclosingDeclarationNode instanceof ModuleNode) {
            return (ModuleNode)this.enclosingDeclarationNode;
        }
        if (this.enclosingDeclarationNode instanceof ClassNode) {
            return ((ClassNode)this.enclosingDeclarationNode).getModule();
        }
        if (this.enclosingDeclarationNode instanceof MethodNode) {
            return ((MethodNode)this.enclosingDeclarationNode).getDeclaringClass().getModule();
        }
        if (this.enclosingDeclarationNode instanceof FieldNode) {
            return ((FieldNode)this.enclosingDeclarationNode).getDeclaringClass().getModule();
        }
        throw new IllegalArgumentException("Invalid enclosing declaration node: " + this.enclosingDeclarationNode);
    }

    private boolean isPrimaryExpression(Expression node) {
        if (!this.completeExpressionStack.isEmpty()) {
            ASTNode complete = this.completeExpressionStack.peek();
            if (complete instanceof PropertyExpression) {
                PropertyExpression prop = (PropertyExpression)complete;
                return prop.getObjectExpression() == node;
            }
            if (complete instanceof MethodCallExpression) {
                MethodCallExpression prop = (MethodCallExpression)complete;
                return prop.getObjectExpression() == node;
            }
            if (complete instanceof BinaryExpression) {
                BinaryExpression prop = (BinaryExpression)complete;
                return prop.getRightExpression() == node || prop.getLeftExpression() == node;
            }
            if (complete instanceof AttributeExpression) {
                AttributeExpression prop = (AttributeExpression)complete;
                return prop.getObjectExpression() == node;
            }
            if (complete instanceof TernaryExpression) {
                TernaryExpression prop = (TernaryExpression)complete;
                return prop.getTrueExpression() == node;
            }
            if (complete instanceof ForStatement) {
                ForStatement prop = (ForStatement)complete;
                return prop.getCollectionExpression() == node;
            }
            if (complete instanceof ListExpression) {
                return ((ListExpression)complete).getExpressions().size() > 0 && ((ListExpression)complete).getExpression(0) == node;
            }
            if (complete instanceof RangeExpression) {
                return ((RangeExpression)complete).getFrom() == node;
            }
            if (complete instanceof MapEntryExpression) {
                return ((MapEntryExpression)complete).getKeyExpression() == node || ((MapEntryExpression)complete).getValueExpression() == node;
            }
            if (complete instanceof MapExpression) {
                return ((MapExpression)complete).getMapEntryExpressions().size() > 0 && ((MapExpression)complete).getMapEntryExpressions().get(0) == node;
            }
            if (complete instanceof PrefixExpression) {
                return ((PrefixExpression)complete).getExpression() == node;
            }
            if (complete instanceof PostfixExpression) {
                return ((PostfixExpression)complete).getExpression() == node;
            }
            if (complete instanceof UnaryPlusExpression) {
                return ((UnaryPlusExpression)complete).getExpression() == node;
            }
            if (complete instanceof UnaryMinusExpression) {
                return ((UnaryMinusExpression)complete).getExpression() == node;
            }
            if (complete instanceof BitwiseNegationExpression) {
                return ((BitwiseNegationExpression)complete).getExpression() == node;
            }
            return false;
        }
        return false;
    }

    private boolean isDependentExpression(Expression node) {
        if (!this.completeExpressionStack.isEmpty()) {
            ASTNode complete = this.completeExpressionStack.peek();
            if (complete instanceof PropertyExpression) {
                PropertyExpression prop = (PropertyExpression)complete;
                return prop.getProperty() == node;
            }
            if (complete instanceof MethodCallExpression) {
                MethodCallExpression prop = (MethodCallExpression)complete;
                return prop.getMethod() == node;
            }
            if (complete instanceof ImportNode) {
                ImportNode imp = (ImportNode)complete;
                return node == imp.getAliasExpr() || node == imp.getFieldNameExpr();
            }
            return false;
        }
        return false;
    }

    private boolean hasStaticObjectExpression(Expression node) {
        if (!this.completeExpressionStack.isEmpty()) {
            ASTNode maybeProperty = this.completeExpressionStack.peek();
            if (maybeProperty instanceof PropertyExpression) {
                PropertyExpression prop = (PropertyExpression)maybeProperty;
                return prop.getObjectExpression() instanceof ClassExpression || prop.isImplicitThis() && this.scopes.peek().isStatic();
            }
            if (maybeProperty instanceof MethodCallExpression) {
                MethodCallExpression prop = (MethodCallExpression)maybeProperty;
                return prop.getObjectExpression() instanceof ClassExpression || prop.isImplicitThis() && this.scopes.peek().isStatic();
            }
            if (maybeProperty instanceof AttributeExpression) {
                AttributeExpression prop = (AttributeExpression)maybeProperty;
                return prop.getObjectExpression() instanceof ClassExpression || prop.isImplicitThis() && this.scopes.peek().isStatic();
            }
            return false;
        }
        return false;
    }

    private ClassNode findTypeOfBinaryExpression(String operation, ClassNode lhs, ClassNode rhs) {
        char op = operation.charAt(0);
        switch (op) {
            case '*': {
                if (operation.equals("*.") || operation.equals("*.@")) {
                    return VariableScope.clonedList();
                }
            }
            case '~': {
                return VariableScope.STRING_CLASS_NODE;
            }
            case '!': 
            case '<': 
            case '>': {
                if (operation.length() > 1 && operation.equals("<=>")) {
                    return VariableScope.INTEGER_CLASS_NODE;
                }
                return VariableScope.BOOLEAN_CLASS_NODE;
            }
            case 'i': {
                if (operation.equals("is") || operation.equals("in")) {
                    return VariableScope.BOOLEAN_CLASS_NODE;
                }
                return rhs;
            }
            case '.': {
                if (operation.equals(".&")) {
                    return ClassHelper.CLOSURE_TYPE;
                }
                return rhs;
            }
            case '=': {
                if (operation.length() <= 1) break;
                if (operation.charAt(1) == '=') {
                    return VariableScope.BOOLEAN_CLASS_NODE;
                }
                if (operation.charAt(1) != '~') break;
                return VariableScope.MATCHER_CLASS_NODE;
            }
        }
        return rhs;
    }

    private void addCategoryToBeDeclared(ClassNode catNode) {
        this.scopes.peek().setCategoryBeingDeclared(catNode);
    }

    private ClassNode isCategoryDeclaration(MethodCallExpression node) {
        ArgumentListExpression args;
        Expression exprs;
        String methodAsString = node.getMethodAsString();
        if (methodAsString != null && methodAsString.equals("use") && (exprs = node.getArguments()) instanceof ArgumentListExpression && (args = (ArgumentListExpression)exprs).getExpressions().size() >= 2 && args.getExpressions().get(1) instanceof ClosureExpression) {
            VariableScope.VariableInfo info;
            Expression expr = args.getExpressions().get(0);
            if (expr instanceof ClassExpression) {
                return expr.getType();
            }
            if (expr instanceof VariableExpression && expr.getText() != null && (info = this.scopes.peek().lookupName(expr.getText())) != null) {
                return info.type;
            }
        }
        return null;
    }

    private void postVisitSanityCheck() {
        Assert.isTrue(this.completeExpressionStack.isEmpty(), "Inferencing engine in invalid state after visitor completed.  All stacks should be empty after visit completed.");
        Assert.isTrue(this.primaryTypeStack.isEmpty(), "Inferencing engine in invalid state after visitor completed.  All stacks should be empty after visit completed.");
        Assert.isTrue(this.dependentDeclaringTypeStack.isEmpty(), "Inferencing engine in invalid state after visitor completed.  All stacks should be empty after visit completed.");
        Assert.isTrue(this.dependentTypeStack.isEmpty(), "Inferencing engine in invalid state after visitor completed.  All stacks should be empty after visit completed.");
        Assert.isTrue(this.scopes.isEmpty(), "Inferencing engine in invalid state after visitor completed.  All stacks should be empty after visit completed.");
    }

    public class VisitCompleted
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final ITypeRequestor.VisitStatus status;

        public VisitCompleted(ITypeRequestor.VisitStatus status) {
            this.status = status;
        }
    }
}

