/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.List;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.groovy.search.CategoryTypeLookup;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.SimpleTypeLookup;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupRegistry;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.util.Util;

public class TypeInferencingVisitorFactory {
    public TypeInferencingVisitorWithRequestor createVisitor(PossibleMatch possibleMatch) {
        try {
            Openable openable = possibleMatch.openable;
            if (openable instanceof GroovyCompilationUnit) {
                TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorWithRequestor((GroovyCompilationUnit)openable, this.createLookups(((GroovyCompilationUnit)openable).getJavaProject().getProject()));
                return visitor;
            }
            Util.log(new RuntimeException(), "Attempted to do a groovy visit on a non-groovy file: " + new String(possibleMatch.getFileName()));
        }
        catch (Exception e) {
            Util.log(e, "Exception when creating TypeInferencingVisitorWithRequestor for " + possibleMatch.document.getPath());
        }
        return null;
    }

    public TypeInferencingVisitorWithRequestor createVisitor(GroovyCompilationUnit unit) {
        return new TypeInferencingVisitorWithRequestor(unit, this.createLookups(unit.getJavaProject().getProject()));
    }

    private ITypeLookup[] createLookups(IProject project) {
        ITypeLookup[] lookups;
        try {
            List<ITypeLookup> lookupsList = TypeLookupRegistry.getRegistry().getLookupsFor(project);
            lookupsList.add(new CategoryTypeLookup());
            lookupsList.add(new SimpleTypeLookup());
            lookups = lookupsList.toArray(new ITypeLookup[0]);
        }
        catch (CoreException e) {
            Util.log(e, "Exception creating type lookups for project " + project.getName() + ".  Using default instead");
            lookups = new ITypeLookup[]{new CategoryTypeLookup(), new SimpleTypeLookup()};
        }
        return lookups;
    }
}

