/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.util.HashSet;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTAnnotationNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTFieldNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTMethodNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.internal.compiler.ast.LazyGenericsType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTClassNode
extends ClassNode
implements JDTNode {
    private static final Parameter[] NO_PARAMETERS = new Parameter[0];
    private static final String[] argNames = new String[]{"arg0", "arg1", "arg2", "arg3", "arg4", "arg5", "arg6", "arg7"};
    ReferenceBinding jdtBinding;
    private boolean beingInitialized = false;
    JDTResolver resolver;
    private int bits = 0;
    private static final int ANNOTATIONS_INITIALIZED = 1;
    private static final int PROPERTIES_INITIALIZED = 2;
    static final ClassNode unboundWildcard;
    static final GenericsType genericsTypeUnboundWildcard;
    private boolean unfindable = false;

    static {
        ClassNode base = ClassHelper.makeWithoutCaching("?");
        base.setRedirect(ClassHelper.OBJECT_TYPE);
        GenericsType t = new GenericsType(base, null, null);
        t.setName("?");
        t.setWildcard(true);
        unboundWildcard = ClassHelper.makeWithoutCaching("?");
        unboundWildcard.setRedirect(ClassHelper.OBJECT_TYPE);
        genericsTypeUnboundWildcard = t;
    }

    @Override
    public boolean mightHaveInners() {
        return this.jdtBinding.memberTypes().length != 0;
    }

    public JDTClassNode(ReferenceBinding jdtReferenceBinding, JDTResolver resolver) {
        super(JDTClassNode.getName(jdtReferenceBinding), JDTClassNode.getMods(jdtReferenceBinding), null);
        this.jdtBinding = jdtReferenceBinding;
        this.resolver = resolver;
        this.lazyInitDone = false;
        this.isPrimaryNode = false;
    }

    private static String getName(TypeBinding tb) {
        if (tb instanceof ArrayBinding) {
            return new String(((ArrayBinding)tb).signature());
        }
        if (tb instanceof MemberTypeBinding) {
            MemberTypeBinding mtb = (MemberTypeBinding)tb;
            return CharOperation.toString(mtb.compoundName);
        }
        if (tb instanceof ReferenceBinding) {
            return CharOperation.toString(((ReferenceBinding)tb).compoundName);
        }
        return new String(tb.sourceName());
    }

    private static int getMods(TypeBinding tb) {
        if (tb instanceof ReferenceBinding) {
            return ((ReferenceBinding)tb).modifiers;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lazyClassInit() {
        Object object = this.lazyInitLock;
        synchronized (object) {
            if (this.lazyInitDone) {
                return;
            }
            this.initialize();
            this.lazyInitDone = true;
        }
    }

    public void setupGenerics() {
        if (this.jdtBinding instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding ptb = (ParameterizedTypeBinding)this.jdtBinding;
            TypeBinding[] parameterizationArguments = ptb.arguments;
            if (parameterizationArguments != null && parameterizationArguments.length > 0) {
                GenericsType[] generics = new GenericsType[parameterizationArguments.length];
                int g = 0;
                while (g < parameterizationArguments.length) {
                    TypeBinding typeBinding = parameterizationArguments[g];
                    generics[g] = typeBinding instanceof TypeVariableBinding ? this.createGenericsTypeInfoForTypeVariableBinding((TypeVariableBinding)parameterizationArguments[g]) : (typeBinding instanceof WildcardBinding && ((WildcardBinding)typeBinding).boundKind == 0 ? genericsTypeUnboundWildcard : new GenericsType(this.resolver.convertToClassNode(typeBinding)));
                    ++g;
                }
                this.setGenericsTypes(generics);
            }
            this.setRedirect(this.resolver.convertToClassNode(ptb.original()));
        } else {
            TypeVariableBinding[] typeVariables = this.jdtBinding.typeVariables();
            GenericsType[] generics = this.createGenericsTypeInfoForTypeVariableBindings(typeVariables);
            if (generics != null) {
                this.setGenericsTypes(generics);
            }
        }
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    void initialize() {
        try {
            ReferenceBinding[] superInterfaceBindings;
            ReferenceBinding superClass;
            if (this.beingInitialized) {
                return;
            }
            this.beingInitialized = true;
            if (this.jdtBinding instanceof ParameterizedTypeBinding) {
                ClassNode rd = this.redirect();
                rd.lazyClassInit();
                return;
            }
            this.resolver.pushTypeGenerics(this.getGenericsTypes());
            if (!this.jdtBinding.isInterface() && (superClass = this.jdtBinding.superclass()) != null) {
                this.setUnresolvedSuperClass(this.resolver.convertToClassNode(superClass));
            }
            superInterfaceBindings = (superInterfaceBindings = this.jdtBinding.superInterfaces()) == null ? ReferenceBinding.NO_SUPERINTERFACES : superInterfaceBindings;
            ClassNode[] interfaces = new ClassNode[superInterfaceBindings.length];
            int i = 0;
            while (i < superInterfaceBindings.length) {
                interfaces[i] = this.resolver.convertToClassNode(superInterfaceBindings[i]);
                ++i;
            }
            this.setInterfaces(interfaces);
            this.initializeMembers();
            this.resolver.popTypeGenerics();
        }
        finally {
            this.beingInitialized = false;
        }
    }

    private void initializeMembers() {
        TypeDeclaration groovyDecl = null;
        if (this.jdtBinding instanceof SourceTypeBinding) {
            TypeDeclaration typeDecl;
            SourceTypeBinding sourceType = (SourceTypeBinding)this.jdtBinding;
            if (sourceType.scope != null && (typeDecl = sourceType.scope.referenceContext) instanceof GroovyTypeDeclaration) {
                groovyDecl = typeDecl;
            }
        }
        MethodBinding[] bindings = null;
        if (this.jdtBinding instanceof ParameterizedTypeBinding) {
            ReferenceBinding genericType = ((ParameterizedTypeBinding)this.jdtBinding).genericType();
            bindings = genericType.methods();
        } else {
            bindings = this.jdtBinding.methods();
        }
        if (bindings != null) {
            int i = 0;
            while (i < bindings.length) {
                if (bindings[i].isConstructor()) {
                    ConstructorNode cNode = this.constructorBindingToConstructorNode(bindings[i]);
                    this.addConstructor(cNode);
                } else {
                    MethodNode mNode = this.methodBindingToMethodNode(bindings[i]);
                    this.addMethod(mNode);
                }
                ++i;
            }
        }
        if (this.jdtBinding instanceof BinaryTypeBinding) {
            MethodBinding[] infraBindings = ((BinaryTypeBinding)this.jdtBinding).infraMethods();
            int i = 0;
            while (i < infraBindings.length) {
                if (infraBindings[i].isConstructor()) {
                    ConstructorNode cNode = this.constructorBindingToConstructorNode(infraBindings[i]);
                    this.addConstructor(cNode);
                } else {
                    MethodNode mNode = this.methodBindingToMethodNode(infraBindings[i]);
                    this.addMethod(mNode);
                }
                ++i;
            }
        }
        if (this.jdtBinding instanceof SourceTypeBinding) {
            SyntheticMethodBinding[] syntheticMethodBindings;
            SourceTypeBinding jdtSourceTypeBinding = (SourceTypeBinding)this.jdtBinding;
            ClassScope classScope = jdtSourceTypeBinding.scope;
            if (classScope != null) {
                CompilationUnitScope cuScope = classScope.compilationUnitScope();
                LookupEnvironment environment = classScope.environment();
                MethodVerifier verifier = environment.methodVerifier();
                cuScope.verifyMethods(verifier);
            }
            if ((syntheticMethodBindings = ((SourceTypeBinding)this.jdtBinding).syntheticMethods()) != null) {
                int i = 0;
                while (i < syntheticMethodBindings.length) {
                    if (syntheticMethodBindings[i].isConstructor()) {
                        ConstructorNode cNode = this.constructorBindingToConstructorNode(bindings[i]);
                        this.addConstructor(cNode);
                    } else {
                        MethodNode mNode = this.methodBindingToMethodNode(syntheticMethodBindings[i]);
                        this.addMethod(mNode);
                    }
                    ++i;
                }
            }
        }
        FieldBinding[] fieldBindings = null;
        fieldBindings = this.jdtBinding instanceof ParameterizedTypeBinding ? ((ParameterizedTypeBinding)this.jdtBinding).genericType().fields() : this.jdtBinding.fields();
        if (fieldBindings != null) {
            int i = 0;
            while (i < fieldBindings.length) {
                FieldNode fNode = this.fieldBindingToFieldNode(fieldBindings[i], groovyDecl);
                this.addField(fNode);
                ++i;
            }
        }
    }

    private MethodNode methodBindingToMethodNode(MethodBinding methodBinding) {
        String name = new String(methodBinding.selector);
        TypeVariableBinding[] typeVariables = methodBinding.typeVariables();
        GenericsType[] generics = this.createGenericsTypeInfoForTypeVariableBindings(typeVariables);
        JDTMethodNode mNode = null;
        try {
            this.resolver.pushMemberGenerics(generics);
            int modifiers = methodBinding.modifiers;
            if (this.jdtBinding.isInterface()) {
                modifiers |= 0x400;
            }
            ClassNode returnType = this.resolver.convertToClassNode(methodBinding.returnType);
            Parameter[] gParameters = this.convertJdtParametersToGroovyParameters(methodBinding.parameters);
            ClassNode[] thrownExceptions = new ClassNode[]{};
            if (methodBinding.thrownExceptions != null) {
                thrownExceptions = new ClassNode[methodBinding.thrownExceptions.length];
                int i = 0;
                while (i < methodBinding.thrownExceptions.length) {
                    thrownExceptions[i] = this.resolver.convertToClassNode(methodBinding.thrownExceptions[i]);
                    ++i;
                }
            }
            mNode = new JDTMethodNode(methodBinding, this.resolver, name, modifiers, returnType, gParameters, thrownExceptions, null);
        }
        finally {
            this.resolver.popMemberGenerics();
        }
        mNode.setGenericsTypes(generics);
        return mNode;
    }

    private Parameter[] convertJdtParametersToGroovyParameters(TypeBinding[] jdtParameters) {
        Parameter[] gParameters;
        block4: {
            gParameters = NO_PARAMETERS;
            if (jdtParameters == null || jdtParameters.length <= 0) break block4;
            gParameters = new Parameter[jdtParameters.length];
            if (jdtParameters.length < 8) {
                int i = 0;
                while (i < jdtParameters.length) {
                    ClassNode paramType = this.resolver.convertToClassNode(jdtParameters[i]);
                    gParameters[i] = new Parameter(paramType, argNames[i]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < jdtParameters.length) {
                    ClassNode c2 = this.resolver.convertToClassNode(jdtParameters[i]);
                    gParameters[i] = i < 8 ? new Parameter(c2, argNames[i]) : new Parameter(c2, "arg" + i);
                    ++i;
                }
            }
        }
        return gParameters;
    }

    private ConstructorNode constructorBindingToConstructorNode(MethodBinding methodBinding) {
        TypeVariableBinding[] typeVariables = methodBinding.typeVariables();
        GenericsType[] generics = this.createGenericsTypeInfoForTypeVariableBindings(typeVariables);
        ConstructorNode ctorNode = null;
        try {
            this.resolver.pushMemberGenerics(generics);
            int modifiers = methodBinding.modifiers;
            Parameter[] parameters = this.convertJdtParametersToGroovyParameters(methodBinding.parameters);
            ClassNode[] thrownExceptions = new ClassNode[]{};
            if (methodBinding.thrownExceptions != null) {
                thrownExceptions = new ClassNode[methodBinding.thrownExceptions.length];
                int i = 0;
                while (i < methodBinding.thrownExceptions.length) {
                    thrownExceptions[i] = this.resolver.convertToClassNode(methodBinding.thrownExceptions[i]);
                    ++i;
                }
            }
            ctorNode = new ConstructorNode(modifiers, parameters, thrownExceptions, null);
        }
        finally {
            this.resolver.popMemberGenerics();
        }
        ctorNode.setGenericsTypes(generics);
        return ctorNode;
    }

    private FieldNode fieldBindingToFieldNode(FieldBinding fieldBinding, TypeDeclaration groovyTypeDecl) {
        String name = new String(fieldBinding.name);
        int modifiers = fieldBinding.modifiers;
        ClassNode fieldType = this.resolver.convertToClassNode(fieldBinding.type);
        Constant c = fieldBinding.constant();
        Expression initializerExpression = null;
        if (c == Constant.NotAConstant) {
            FieldDeclaration fieldDecl;
            if (groovyTypeDecl != null && (fieldDecl = groovyTypeDecl.declarationOf(fieldBinding)) instanceof GroovyCompilationUnitDeclaration.FieldDeclarationWithInitializer) {
                initializerExpression = ((GroovyCompilationUnitDeclaration.FieldDeclarationWithInitializer)fieldDecl).getGroovyInitializer();
            }
        } else if (c instanceof StringConstant) {
            initializerExpression = new ConstantExpression(((StringConstant)c).stringValue());
        } else if (c instanceof BooleanConstant) {
            initializerExpression = new ConstantExpression(((BooleanConstant)c).booleanValue());
        } else if (c instanceof IntConstant) {
            initializerExpression = new ConstantExpression(((IntConstant)c).intValue());
        } else if (c instanceof LongConstant) {
            initializerExpression = new ConstantExpression(((LongConstant)c).longValue());
        } else if (c instanceof DoubleConstant) {
            initializerExpression = new ConstantExpression(((DoubleConstant)c).doubleValue());
        } else if (c instanceof FloatConstant) {
            initializerExpression = new ConstantExpression(Float.valueOf(((FloatConstant)c).floatValue()));
        } else if (c instanceof ByteConstant) {
            initializerExpression = new ConstantExpression(((ByteConstant)c).byteValue());
        } else if (c instanceof CharConstant) {
            initializerExpression = new ConstantExpression(Character.valueOf(((CharConstant)c).charValue()));
        } else if (c instanceof ShortConstant) {
            initializerExpression = new ConstantExpression(((ShortConstant)c).shortValue());
        }
        JDTFieldNode fNode = new JDTFieldNode(fieldBinding, this.resolver, name, modifiers, fieldType, this, initializerExpression);
        return fNode;
    }

    @Override
    public boolean isReallyResolved() {
        return true;
    }

    @Override
    public String getClassInternalName() {
        return this.getName().replace('.', '/');
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    private GenericsType[] createGenericsTypeInfoForTypeVariableBindings(TypeVariableBinding ... typeVariables) {
        if (typeVariables == null || typeVariables.length == 0) {
            return null;
        }
        GenericsType[] genericTypeInfo = new GenericsType[typeVariables.length];
        int g = 0;
        while (g < typeVariables.length) {
            genericTypeInfo[g] = this.createGenericsTypeInfoForTypeVariableBinding(typeVariables[g]);
            ++g;
        }
        return genericTypeInfo;
    }

    private GenericsType createGenericsTypeInfoForTypeVariableBinding(TypeVariableBinding typeVariableBinding) {
        LazyGenericsType gt = new LazyGenericsType(typeVariableBinding, this.resolver);
        return gt;
    }

    @Override
    public List<AnnotationNode> getAnnotations() {
        if ((this.bits & 1) == 0) {
            this.ensureAnnotationsInitialized();
        }
        return super.getAnnotations();
    }

    private synchronized void ensureAnnotationsInitialized() {
        if ((this.bits & 1) == 0) {
            AnnotationBinding[] annotationBindings;
            if (this.jdtBinding instanceof SourceTypeBinding) {
                ((SourceTypeBinding)this.jdtBinding).getAnnotationTagBits();
            }
            AnnotationBinding[] annotationBindingArray = annotationBindings = this.jdtBinding.getAnnotations();
            int n = annotationBindings.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationBinding annotationBinding = annotationBindingArray[n2];
                this.addAnnotation(new JDTAnnotationNode(annotationBinding, this.resolver));
                ++n2;
            }
            this.bits |= 1;
        }
    }

    @Override
    protected void ensurePropertiesInitialized() {
        if ((this.bits & 2) == 0) {
            this.initializeProperties();
        }
    }

    protected synchronized void initializeProperties() {
        if ((this.bits & 2) == 0) {
            this.lazyClassInit();
            HashSet<String> existing = new HashSet<String>();
            for (MethodNode methodNode : this.getMethods()) {
                String propertyName;
                if (!this.isGetter(methodNode) || existing.contains(propertyName = this.convertToPropertyName(methodNode.getName()))) continue;
                existing.add(propertyName);
                super.addPropertyWithoutField(this.createPropertyNodeForMethodNode(methodNode, propertyName));
            }
            this.bits |= 2;
        }
    }

    private PropertyNode createPropertyNodeForMethodNode(MethodNode methodNode, String propertyName) {
        ClassNode propertyType = methodNode.getReturnType();
        int mods = methodNode.getModifiers();
        FieldNode field = this.getField(propertyName);
        if (field == null) {
            field = new FieldNode(propertyName, mods, propertyType, this, null);
            field.setDeclaringClass(this);
        } else {
            this.removeField(propertyName);
        }
        PropertyNode property = new PropertyNode(field, mods, null, null);
        property.setDeclaringClass(this);
        return property;
    }

    private String convertToPropertyName(String methodName) {
        StringBuffer propertyName = new StringBuffer();
        int prefixLen = methodName.startsWith("is") ? 2 : 3;
        propertyName.append(Character.toLowerCase(methodName.charAt(prefixLen)));
        if (methodName.length() > prefixLen + 1) {
            propertyName.append(methodName.substring(prefixLen + 1));
        }
        String name = propertyName.toString();
        return name;
    }

    private boolean isSetter(MethodNode methodNode) {
        return methodNode.getReturnType() == ClassHelper.VOID_TYPE && methodNode.getParameters().length == 1 && methodNode.getName().startsWith("set") && methodNode.getName().length() > 3;
    }

    private boolean isGetter(MethodNode methodNode) {
        return methodNode.getReturnType() != ClassHelper.VOID_TYPE && methodNode.getParameters().length == 0 && (methodNode.getName().startsWith("get") && methodNode.getName().length() > 3 || methodNode.getName().startsWith("is") && methodNode.getName().length() > 2);
    }

    @Override
    public List<PropertyNode> getProperties() {
        this.ensurePropertiesInitialized();
        return super.getProperties();
    }

    @Override
    public PropertyNode getProperty(String name) {
        this.ensurePropertiesInitialized();
        return super.getProperty(name);
    }

    @Override
    public boolean hasProperty(String name) {
        this.ensurePropertiesInitialized();
        return super.hasProperty(name);
    }

    @Override
    public void addProperty(PropertyNode node) {
        new RuntimeException("JDTClassNode is immutable, should not be called to add property: " + node.getName()).printStackTrace();
    }

    @Override
    public PropertyNode addProperty(String name, int modifiers, ClassNode type, Expression initialValueExpression, Statement getterBlock, Statement setterBlock) {
        new RuntimeException("JDTClassNode is immutable, should not be called to add property: " + name).printStackTrace();
        return null;
    }

    @Override
    public ReferenceBinding getJdtBinding() {
        return this.jdtBinding;
    }

    @Override
    public JDTResolver getResolver() {
        return this.resolver;
    }

    @Override
    public boolean isDeprecated() {
        return this.jdtBinding.isDeprecated();
    }

    @Override
    public Class getTypeClass() {
        if (this.clazz != null || this.unfindable) {
            return this.clazz;
        }
        GroovyClassLoader transformLoader = this.resolver.compilationUnit.getTransformLoader();
        if (transformLoader != null) {
            try {
                this.clazz = Class.forName(this.getName(), false, transformLoader);
                return this.clazz;
            }
            catch (ClassNotFoundException e) {
                this.unfindable = true;
            }
        }
        throw new GroovyBugError("JDTClassNode.getTypeClass() cannot locate class for " + this.getName() + " using transform loader " + transformLoader);
    }
}

