/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class Tuple<E>
extends AbstractList<E> {
    private final E[] contents;

    public Tuple(E ... contents) {
        if (contents == null) {
            throw new NullPointerException();
        }
        this.contents = contents;
    }

    @Override
    public E get(int index) {
        return this.contents[index];
    }

    @Override
    public int size() {
        return this.contents.length;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        int size = toIndex - fromIndex;
        Object[] newContent = new Object[size];
        System.arraycopy(this.contents, fromIndex, newContent, 0, size);
        return new Tuple<Object>(newContent);
    }

    public Tuple<E> subTuple(int fromIndex, int toIndex) {
        return (Tuple)this.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Tuple)) {
            return false;
        }
        Tuple that = (Tuple)o;
        int size = this.size();
        if (size != that.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (DefaultTypeTransformation.compareEqual(this.get(i), that.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.contents);
    }
}

