/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.parser.antlr4.util;

import groovy.lang.Closure;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.groovy.util.Maps;
import org.codehaus.groovy.runtime.StringGroovyMethods;

public class StringUtils {
    private static final Map<Character, Character> STANDARD_ESCAPES = Maps.of(Character.valueOf('b'), Character.valueOf('\b'), Character.valueOf('t'), Character.valueOf('\t'), Character.valueOf('n'), Character.valueOf('\n'), Character.valueOf('f'), Character.valueOf('\f'), Character.valueOf('r'), Character.valueOf('\r'));
    public static final int NONE_SLASHY = 0;
    public static final int SLASHY = 1;
    public static final int DOLLAR_SLASHY = 2;

    public static String replaceHexEscapes(String text) {
        Pattern p = Pattern.compile("(\\\\*)\\\\u+([0-9abcdefABCDEF]{4})");
        return StringGroovyMethods.replaceAll((CharSequence)text, p, (Closure)new Closure<Void>(null, null){

            Object doCall(String _0, String _1, String _2) {
                if (StringUtils.isLengthOdd(_1)) {
                    return _0;
                }
                return _1 + new String(Character.toChars(Integer.parseInt(_2, 16)));
            }
        });
    }

    public static String replaceOctalEscapes(String text) {
        Pattern p = Pattern.compile("(\\\\*)\\\\([0-3]?[0-7]?[0-7])");
        return StringGroovyMethods.replaceAll((CharSequence)text, p, (Closure)new Closure<Void>(null, null){

            Object doCall(String _0, String _1, String _2) {
                if (StringUtils.isLengthOdd(_1)) {
                    return _0;
                }
                return _1 + new String(Character.toChars(Integer.parseInt(_2, 8)));
            }
        });
    }

    public static String replaceStandardEscapes(String text) {
        Pattern p = Pattern.compile("(\\\\*)\\\\([btnfr\"'])");
        String result = StringGroovyMethods.replaceAll((CharSequence)text, p, (Closure)new Closure<Void>(null, null){

            Object doCall(String _0, String _1, String _2) {
                if (StringUtils.isLengthOdd(_1)) {
                    return _0;
                }
                Character character = (Character)STANDARD_ESCAPES.get(Character.valueOf(_2.charAt(0)));
                return _1 + (character != null ? character : _2);
            }
        });
        return StringUtils.replace(result, Maps.of("\\\\", "\\"));
    }

    public static String replaceEscapes(String text, int slashyType) {
        if (slashyType == 1 || slashyType == 2) {
            text = StringUtils.replaceHexEscapes(text);
            text = StringUtils.replaceLineEscape(text);
            StringBuilder sb = new StringBuilder(text);
            if (slashyType == 1) {
                StringUtils.replace(sb, Maps.of("\\/", "/"));
            }
            if (slashyType == 2) {
                StringUtils.replace(sb, Maps.of("$$", "$", "$/", "/"));
            }
            text = sb.toString();
        } else if (slashyType == 0) {
            text = StringUtils.replaceEscapes(text);
        } else {
            throw new IllegalArgumentException("Invalid slashyType: " + slashyType);
        }
        return text;
    }

    private static String replaceEscapes(String text) {
        text = StringUtils.replace(text, Maps.of("\\$", "$"));
        text = StringUtils.replaceLineEscape(text);
        return StringUtils.replaceStandardEscapes(StringUtils.replaceHexEscapes(StringUtils.replaceOctalEscapes(text)));
    }

    private static String replaceLineEscape(String text) {
        Pattern p = Pattern.compile("(\\\\*)\\\\\r?\n");
        text = StringGroovyMethods.replaceAll((CharSequence)text, p, (Closure)new Closure<Void>(null, null){

            Object doCall(String _0, String _1) {
                if (StringUtils.isLengthOdd(_1)) {
                    return _0;
                }
                return _1;
            }
        });
        return text;
    }

    private static boolean isLengthOdd(String str) {
        return null != str && str.length() % 2 == 1;
    }

    public static String removeCR(String text) {
        return StringUtils.replace(text, Maps.of("\r\n", "\n"));
    }

    public static long countChar(String text, char c) {
        int length = text.length();
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (text.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String replace(String str, Map<String, String> replacements) {
        return StringUtils.replace(new StringBuilder(str), replacements).toString();
    }

    public static StringBuilder replace(StringBuilder sb, Map<String, String> replacements) {
        for (Map.Entry<String, String> replacementEntry : replacements.entrySet()) {
            String key = replacementEntry.getKey();
            int keyLength = key.length();
            String value = replacementEntry.getValue();
            int valueLength = value.length();
            int start = sb.indexOf(key, 0);
            while (start > -1) {
                sb.replace(start, start + keyLength, value);
                start = sb.indexOf(key, start + valueLength);
            }
        }
        return sb;
    }

    public static String trimQuotations(String text, int quotationLength) {
        int length = text.length();
        return length == quotationLength << 1 ? "" : text.substring(quotationLength, length - quotationLength);
    }
}

