/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.MapConstructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class MapConstructorASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = MapConstructor.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode MAP_TYPE = ClassHelper.makeWithoutCaching(Map.class, false);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            if (!this.checkNotInterface(cNode, MY_TYPE_NAME)) {
                return;
            }
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            boolean includeProperties = !this.memberHasValue(anno, "includeProperties", false);
            boolean includeSuperProperties = this.memberHasValue(anno, "includeSuperProperties", true);
            boolean useSetters = this.memberHasValue(anno, "useSetters", true);
            List<String> excludes = MapConstructorASTTransformation.getMemberStringList(anno, "excludes");
            List<String> includes = MapConstructorASTTransformation.getMemberStringList(anno, "includes");
            boolean allNames = this.memberHasValue(anno, "allNames", true);
            if (!this.checkIncludeExcludeUndefinedAware(anno, excludes, includes, MY_TYPE_NAME)) {
                return;
            }
            if (!this.checkPropertyList(cNode, includes, "includes", anno, MY_TYPE_NAME, includeFields, includeSuperProperties, false)) {
                return;
            }
            if (!this.checkPropertyList(cNode, excludes, "excludes", anno, MY_TYPE_NAME, includeFields, includeSuperProperties, false)) {
                return;
            }
            if (this.hasAnnotation(cNode, ImmutableASTTransformation.MY_TYPE)) {
                return;
            }
            Expression pre = anno.getMember("pre");
            if (pre != null && !(pre instanceof ClosureExpression)) {
                this.addError("Expected closure value for annotation parameter 'pre'. Found " + pre, cNode);
                return;
            }
            Expression post = anno.getMember("post");
            if (post != null && !(post instanceof ClosureExpression)) {
                this.addError("Expected closure value for annotation parameter 'post'. Found " + post, cNode);
                return;
            }
            MapConstructorASTTransformation.createConstructor(cNode, includeFields, includeProperties, includeSuperProperties, useSetters, excludes, includes, (ClosureExpression)pre, (ClosureExpression)post, source, allNames);
            if (pre != null) {
                anno.setMember("pre", new ClosureExpression(new Parameter[0], new EmptyStatement()));
            }
            if (post != null) {
                anno.setMember("post", new ClosureExpression(new Parameter[0], new EmptyStatement()));
            }
        }
    }

    public static void createConstructor(ClassNode cNode, boolean includeFields, boolean includeProperties, boolean includeSuperProperties, boolean useSetters, List<String> excludes, List<String> includes, ClosureExpression pre, ClosureExpression post, SourceUnit source, boolean allNames) {
        String name;
        boolean foundEmpty;
        List<ConstructorNode> constructors = cNode.getDeclaredConstructors();
        boolean bl = foundEmpty = constructors.size() == 1 && constructors.get(0).getFirstStatement() == null;
        if (foundEmpty) {
            constructors.remove(0);
        }
        ArrayList<FieldNode> superList = new ArrayList<FieldNode>();
        if (includeSuperProperties) {
            superList.addAll(GeneralUtils.getSuperPropertyFields(cNode.getSuperClass()));
        }
        ArrayList<FieldNode> list = new ArrayList<FieldNode>();
        if (includeProperties) {
            list.addAll(GeneralUtils.getInstancePropertyFields(cNode));
        }
        if (includeFields) {
            list.addAll(GeneralUtils.getInstanceNonPropertyFields(cNode));
        }
        Parameter map = GeneralUtils.param(MAP_TYPE, "args");
        BlockStatement body = new BlockStatement();
        ClassCodeExpressionTransformer transformer = MapConstructorASTTransformation.makeMapTypedArgsTransformer();
        if (pre != null) {
            ClosureExpression transformed = (ClosureExpression)transformer.transform(pre);
            GeneralUtils.copyStatementsWithSuperAdjustment(transformed, body);
        }
        BlockStatement inner = new BlockStatement();
        for (FieldNode fNode : superList) {
            name = fNode.getName();
            if (MapConstructorASTTransformation.shouldSkip(name, excludes, includes, allNames)) continue;
            MapConstructorASTTransformation.assignField(useSetters, map, inner, name);
        }
        for (FieldNode fNode : list) {
            name = fNode.getName();
            if (MapConstructorASTTransformation.shouldSkip(name, excludes, includes, allNames)) continue;
            MapConstructorASTTransformation.assignField(useSetters, map, inner, name);
        }
        body.addStatement(GeneralUtils.ifS((Expression)GeneralUtils.notNullX(GeneralUtils.varX("args")), inner));
        if (post != null) {
            ClosureExpression transformed = (ClosureExpression)transformer.transform(post);
            body.addStatement(transformed.getCode());
        }
        cNode.addConstructor(new ConstructorNode(1, GeneralUtils.params(map), ClassNode.EMPTY_ARRAY, body));
    }

    private static void assignField(boolean useSetters, Parameter map, BlockStatement body, String name) {
        ArgumentListExpression nameArg = GeneralUtils.args(GeneralUtils.constX(name));
        body.addStatement(GeneralUtils.ifS((Expression)GeneralUtils.callX((Expression)GeneralUtils.varX(map), "containsKey", (Expression)nameArg), useSetters ? GeneralUtils.stmt(GeneralUtils.callThisX(GeneralUtils.getSetterName(name), GeneralUtils.callX((Expression)GeneralUtils.varX(map), "get", (Expression)nameArg))) : GeneralUtils.assignS(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), name), GeneralUtils.callX((Expression)GeneralUtils.varX(map), "get", (Expression)nameArg))));
    }

    private static ClassCodeExpressionTransformer makeMapTypedArgsTransformer() {
        return new ClassCodeExpressionTransformer(){

            @Override
            public Expression transform(Expression exp) {
                VariableExpression ve;
                if (exp instanceof ClosureExpression) {
                    ClosureExpression ce = (ClosureExpression)exp;
                    ce.getCode().visit(this);
                } else if (exp instanceof VariableExpression && (ve = (VariableExpression)exp).getName().equals("args") && ve.getAccessedVariable() instanceof DynamicVariable) {
                    VariableExpression newVe = new VariableExpression(new Parameter(MAP_TYPE, "args"));
                    newVe.setSourcePosition(ve);
                    return newVe;
                }
                return exp.transformExpression(this);
            }

            @Override
            protected SourceUnit getSourceUnit() {
                return null;
            }
        };
    }
}

