/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.trait;

import groovy.transform.ForceOverride;
import groovy.transform.Trait;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.transform.trait.TraitHelpersTuple;

public abstract class Traits {
    public static final ClassNode FORCEOVERRIDE_CLASSNODE = ClassHelper.make(ForceOverride.class);
    public static final ClassNode IMPLEMENTED_CLASSNODE = ClassHelper.make(Implemented.class);
    public static final Class TRAIT_CLASS = Trait.class;
    public static final ClassNode TRAIT_CLASSNODE = ClassHelper.make(TRAIT_CLASS);
    static final String TRAIT_TYPE_NAME = "@" + TRAIT_CLASSNODE.getNameWithoutPackage();
    static final String TRAIT_HELPER = "$Trait$Helper";
    static final String FIELD_HELPER = "$Trait$FieldHelper";
    static final String DIRECT_SETTER_SUFFIX = "$set";
    static final String DIRECT_GETTER_SUFFIX = "$get";
    static final String INIT_METHOD = "$init$";
    static final String STATIC_INIT_METHOD = "$static$init$";
    static final String THIS_OBJECT = "$self";
    static final String STATIC_THIS_OBJECT = "$static$self";
    static final String STATIC_FIELD_PREFIX = "$static";

    static String fieldHelperClassName(ClassNode traitNode) {
        return traitNode.getName() + FIELD_HELPER;
    }

    static String helperGetterName(FieldNode field) {
        return Traits.remappedFieldName(Traits.unwrapOwner(field.getOwner()), field.getName()) + DIRECT_GETTER_SUFFIX;
    }

    static String helperSetterName(FieldNode field) {
        return Traits.remappedFieldName(Traits.unwrapOwner(field.getOwner()), field.getName()) + DIRECT_SETTER_SUFFIX;
    }

    static String helperClassName(ClassNode traitNode) {
        return traitNode.getName() + TRAIT_HELPER;
    }

    static String remappedFieldName(ClassNode traitNode, String name) {
        return traitNode.getName().replace('.', '_') + "__" + name;
    }

    private static ClassNode unwrapOwner(ClassNode owner) {
        if (ClassHelper.CLASS_Type.equals(owner) && owner.getGenericsTypes() != null && owner.getGenericsTypes().length == 1) {
            return owner.getGenericsTypes()[0].getType();
        }
        return owner;
    }

    static TraitHelpersTuple findHelpers(ClassNode trait) {
        ClassNode helperClassNode = null;
        ClassNode fieldHelperClassNode = null;
        Iterator<InnerClassNode> innerClasses = trait.redirect().getInnerClasses();
        if (innerClasses != null && innerClasses.hasNext()) {
            while (innerClasses.hasNext()) {
                ClassNode icn = innerClasses.next();
                if (icn.getName().endsWith(FIELD_HELPER)) {
                    fieldHelperClassNode = icn;
                    continue;
                }
                if (!icn.getName().endsWith(TRAIT_HELPER)) continue;
                helperClassNode = icn;
            }
        } else {
            try {
                ClassLoader classLoader = trait.getTypeClass().getClassLoader();
                String helperClassName = Traits.helperClassName(trait);
                helperClassNode = ClassHelper.make(classLoader.loadClass(helperClassName));
                try {
                    fieldHelperClassNode = ClassHelper.make(classLoader.loadClass(Traits.fieldHelperClassName(trait)));
                }
                catch (ClassNotFoundException e) {}
            }
            catch (ClassNotFoundException e) {
                throw new GroovyBugError("Couldn't find trait helper classes on compile classpath!", e);
            }
        }
        return new TraitHelpersTuple(helperClassNode, fieldHelperClassNode);
    }

    public static boolean isTrait(ClassNode cNode) {
        return cNode != null && (cNode.isInterface() && !cNode.getAnnotations(TRAIT_CLASSNODE).isEmpty() || Traits.isAnnotatedWithTrait(cNode));
    }

    public static boolean isTrait(Class clazz) {
        return clazz != null && clazz.getAnnotation(Trait.class) != null;
    }

    public static boolean isAnnotatedWithTrait(ClassNode cNode) {
        List<AnnotationNode> traitAnn = cNode.getAnnotations(TRAIT_CLASSNODE);
        return traitAnn != null && !traitAnn.isEmpty();
    }

    public static boolean isForceOverride(MethodNode methodNode) {
        return !methodNode.getAnnotations(FORCEOVERRIDE_CLASSNODE).isEmpty() || !methodNode.getDeclaringClass().getAnnotations(FORCEOVERRIDE_CLASSNODE).isEmpty();
    }

    public static boolean isForceOverride(Method methodNode) {
        return methodNode.getAnnotation(ForceOverride.class) != null || methodNode.getDeclaringClass().getAnnotation(ForceOverride.class) != null;
    }

    public static boolean hasDefaultImplementation(MethodNode method) {
        return !method.getAnnotations(IMPLEMENTED_CLASSNODE).isEmpty();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Implemented {
    }
}

