/*
 * Decompiled with CFR 0.152.
 */
package groovy.transform.stc;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClosureSignatureHint {
    public static ClassNode pickGenericType(ClassNode type, int gtIndex) {
        GenericsType[] genericsTypes = type.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length < gtIndex) {
            return ClassHelper.OBJECT_TYPE;
        }
        return genericsTypes[gtIndex].getType();
    }

    public static ClassNode pickGenericType(MethodNode node, int parameterIndex, int gtIndex) {
        Parameter[] parameters = node.getParameters();
        ClassNode type = parameters[parameterIndex].getOriginType();
        return ClosureSignatureHint.pickGenericType(type, gtIndex);
    }

    public abstract List<ClassNode[]> getClosureSignatures(MethodNode var1, SourceUnit var2, CompilationUnit var3, String[] var4, ASTNode var5);

    protected ClassNode findClassNode(SourceUnit sourceUnit, CompilationUnit compilationUnit, String className) {
        ClassNode cn;
        block3: {
            if (className.endsWith("[]")) {
                return this.findClassNode(sourceUnit, compilationUnit, className.substring(0, className.length() - 2)).makeArray();
            }
            try {
                cn = ClassHelper.make(Class.forName(className, false, sourceUnit.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                cn = compilationUnit.getClassNode(className);
                if (cn != null) break block3;
                cn = ClassHelper.make(className);
            }
        }
        return cn;
    }
}

