/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class ConstructorCallTransformer {
    private final StaticCompilationTransformer staticCompilationTransformer;

    public ConstructorCallTransformer(StaticCompilationTransformer staticCompilationTransformer) {
        this.staticCompilationTransformer = staticCompilationTransformer;
    }

    Expression transformConstructorCall(ConstructorCallExpression expr) {
        Expression expression;
        TupleExpression tupleExpression;
        List<Expression> expressions;
        Expression arguments;
        ConstructorNode node = (ConstructorNode)expr.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (node == null) {
            return expr;
        }
        if (node.getParameters().length == 1 && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(node.getParameters()[0].getType(), ClassHelper.MAP_TYPE) && (arguments = expr.getArguments()) instanceof TupleExpression && (expressions = (tupleExpression = (TupleExpression)arguments).getExpressions()).size() == 1 && (expression = expressions.get(0)) instanceof MapExpression) {
            MapExpression map = (MapExpression)expression;
            ClassNode declaringClass = node.getDeclaringClass();
            for (ConstructorNode constructorNode : declaringClass.getDeclaredConstructors()) {
                if (constructorNode != node) continue;
                return this.staticCompilationTransformer.superTransform(expr);
            }
            VariableExpression vexp = new VariableExpression("obj" + System.currentTimeMillis(), declaringClass);
            ConstructorNode cn = new ConstructorNode(1, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
            cn.setDeclaringClass(declaringClass);
            ConstructorCallExpression call = new ConstructorCallExpression(declaringClass, new ArgumentListExpression());
            call.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, cn);
            DeclarationExpression declaration = new DeclarationExpression(vexp, Token.newSymbol("=", expr.getLineNumber(), expr.getColumnNumber()), (Expression)call);
            BlockStatement stmt = new BlockStatement();
            stmt.addStatement(new ExpressionStatement(declaration));
            for (MapEntryExpression entryExpression : map.getMapEntryExpressions()) {
                int line = entryExpression.getLineNumber();
                int col = entryExpression.getColumnNumber();
                Expression keyExpression = this.staticCompilationTransformer.transform(entryExpression.getKeyExpression());
                Expression valueExpression = this.staticCompilationTransformer.transform(entryExpression.getValueExpression());
                BinaryExpression bexp = new BinaryExpression(new PropertyExpression((Expression)vexp, keyExpression), Token.newSymbol("=", line, col), valueExpression);
                bexp.setSourcePosition(entryExpression);
                stmt.addStatement(new ExpressionStatement(bexp));
            }
            stmt.addStatement(new ReturnStatement(vexp));
            ClosureExpression cl = new ClosureExpression(Parameter.EMPTY_ARRAY, stmt);
            cl.setSourcePosition(call);
            MethodCallExpression result = new MethodCallExpression((Expression)cl, "call", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            result.setMethodTarget(StaticTypeCheckingVisitor.CLOSURE_CALL_NO_ARG);
            VariableScopeVisitor visitor = new VariableScopeVisitor(this.staticCompilationTransformer.getSourceUnit());
            visitor.prepareVisit(this.staticCompilationTransformer.getClassNode());
            visitor.visitClosureExpression(cl);
            return result;
        }
        return this.staticCompilationTransformer.superTransform(expr);
    }
}

