/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.ReturnAdder;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.transform.stc.SharedVariableCollector;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.codehaus.groovy.util.ListHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticTypeCheckingVisitor
extends ClassCodeVisitorSupport {
    private static final ClassNode ITERABLE_TYPE = ClassHelper.make(Iterable.class);
    private static final ClassNode READONLY_PROPERTY_RETURN = ClassHelper.make("<readonly>");
    private static final List<MethodNode> EMPTY_METHODNODE_LIST = Collections.emptyList();
    private SourceUnit source;
    private ClassNode classNode;
    private MethodNode methodNode;
    private Set<MethodNode> methodsToBeVisited = Collections.emptySet();
    private ClosureExpression closureExpression;
    private List<ClassNode> closureReturnTypes;
    private LinkedList<ClassNode> withReceiverList = new LinkedList();
    private ClassNode lastImplicitItType;
    private Map<VariableExpression, List<ClassNode>> ifElseForWhileAssignmentTracker = null;
    private Stack<Map<Object, List<ClassNode>>> temporaryIfBranchTypeInformation;
    private Set<MethodNode> alreadyVisitedMethods = new HashSet<MethodNode>();
    private final LinkedHashSet<Expression> secondPassExpressions = new LinkedHashSet();
    private final Map<VariableExpression, List<ClassNode>> closureSharedVariablesAssignmentTypes = new HashMap<VariableExpression, List<ClassNode>>();
    private Map<Parameter, ClassNode> forLoopVariableTypes = new HashMap<Parameter, ClassNode>();
    private final ReturnAdder returnAdder = new ReturnAdder(new ReturnAdder.ReturnStatementListener(){

        public void returnStatementAdded(ReturnStatement returnStatement) {
            if (returnStatement.getExpression().equals(ConstantExpression.NULL)) {
                return;
            }
            ClassNode returnType = StaticTypeCheckingVisitor.this.checkReturnType(returnStatement);
            if (StaticTypeCheckingVisitor.this.methodNode != null) {
                ClassNode previousType = (ClassNode)StaticTypeCheckingVisitor.this.methodNode.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
                ClassNode inferred = previousType == null ? returnType : WideningCategories.lowestUpperBound(returnType, previousType);
                StaticTypeCheckingVisitor.this.methodNode.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, inferred);
            }
        }
    });
    private final ReturnAdder closureReturnAdder = new ReturnAdder(new ReturnAdder.ReturnStatementListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void returnStatementAdded(ReturnStatement returnStatement) {
            if (returnStatement.getExpression().equals(ConstantExpression.NULL)) {
                return;
            }
            MethodNode currentNode = StaticTypeCheckingVisitor.this.methodNode;
            StaticTypeCheckingVisitor.this.methodNode = null;
            try {
                StaticTypeCheckingVisitor.this.checkReturnType(returnStatement);
                if (StaticTypeCheckingVisitor.this.closureExpression != null) {
                    StaticTypeCheckingVisitor.this.addClosureReturnType(StaticTypeCheckingVisitor.this.getType(returnStatement.getExpression()));
                }
            }
            finally {
                StaticTypeCheckingVisitor.this.methodNode = currentNode;
            }
        }
    });

    public StaticTypeCheckingVisitor(SourceUnit source, ClassNode cn) {
        this.source = source;
        this.classNode = cn;
        this.temporaryIfBranchTypeInformation = new Stack();
        this.pushTemporaryTypeInfo();
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    @Override
    public void visitClass(ClassNode node) {
        ClassNode oldCN = this.classNode;
        this.classNode = node;
        super.visitClass(node);
        this.classNode = oldCN;
    }

    @Override
    public void visitVariableExpression(VariableExpression vexp) {
        super.visitVariableExpression(vexp);
        if (vexp != VariableExpression.THIS_EXPRESSION && vexp != VariableExpression.SUPER_EXPRESSION) {
            if (vexp.getName().equals("this")) {
                this.storeType(vexp, this.classNode);
            }
            if (vexp.getName().equals("super")) {
                this.storeType(vexp, this.classNode.getSuperClass());
            }
        }
        if (vexp.getAccessedVariable() instanceof DynamicVariable) {
            DynamicVariable dyn = (DynamicVariable)vexp.getAccessedVariable();
            String dynName = dyn.getName();
            for (ClassNode node : this.withReceiverList) {
                if (node.getProperty(dynName) != null) {
                    this.storeType(vexp, node.getProperty(dynName).getType());
                    return;
                }
                if (node.getField(dynName) == null) continue;
                this.storeType(vexp, node.getField(dynName).getType());
                return;
            }
            this.addStaticTypeError("The variable [" + vexp.getName() + "] is undeclared.", vexp);
        }
    }

    @Override
    public void visitPropertyExpression(PropertyExpression pexp) {
        super.visitPropertyExpression(pexp);
        if (!this.existsProperty(pexp, true)) {
            Expression objectExpression = pexp.getObjectExpression();
            this.addStaticTypeError("No such property: " + pexp.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, objectExpression.getType()), pexp);
        }
    }

    @Override
    public void visitAttributeExpression(AttributeExpression expression) {
        super.visitAttributeExpression(expression);
        if (!this.existsProperty(expression, true)) {
            Expression objectExpression = expression.getObjectExpression();
            this.addStaticTypeError("No such property: " + expression.getPropertyAsString() + " for class: " + this.findCurrentInstanceOfClass(objectExpression, objectExpression.getType()), expression);
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpression expression) {
        boolean isEmptyDeclaration;
        int op;
        ClassNode resultType;
        super.visitBinaryExpression(expression);
        Expression leftExpression = expression.getLeftExpression();
        ClassNode lType = this.getType(leftExpression);
        Expression rightExpression = expression.getRightExpression();
        ClassNode rType = this.getType(rightExpression);
        if (rightExpression instanceof ConstantExpression && ((ConstantExpression)rightExpression).getValue() == null && !ClassHelper.isPrimitiveType(lType)) {
            rType = lType;
        }
        if ((resultType = this.getResultType(lType, op = expression.getOperation().getType(), rType, expression)) == null) {
            resultType = lType;
        }
        boolean bl = isEmptyDeclaration = expression instanceof DeclarationExpression && rightExpression instanceof EmptyExpression;
        if (!isEmptyDeclaration) {
            this.storeType(expression, resultType);
        }
        if (!isEmptyDeclaration && StaticTypeCheckingSupport.isAssignment(op)) {
            Variable accessedVariable;
            if (rightExpression instanceof ConstructorCallExpression) {
                this.inferDiamondType((ConstructorCallExpression)rightExpression, lType);
            }
            ClassNode originType = this.getOriginalDeclarationType(leftExpression);
            this.typeCheckAssignment(expression, leftExpression, originType, rightExpression, resultType);
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(ClassHelper.getWrapper(resultType), ClassHelper.getWrapper(originType))) {
                resultType = originType;
            }
            if (this.ifElseForWhileAssignmentTracker != null && leftExpression instanceof VariableExpression && (accessedVariable = ((VariableExpression)leftExpression).getAccessedVariable()) instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)accessedVariable;
                List<ClassNode> types = this.ifElseForWhileAssignmentTracker.get(var);
                if (types == null) {
                    types = new LinkedList<ClassNode>();
                    ClassNode type = (ClassNode)var.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                    if (type != null) {
                        types.add(type);
                    }
                    this.ifElseForWhileAssignmentTracker.put(var, types);
                }
                types.add(resultType);
            }
            this.storeType(leftExpression, resultType);
            if (leftExpression instanceof VariableExpression && rightExpression instanceof ClosureExpression) {
                Parameter[] parameters = ((ClosureExpression)rightExpression).getParameters();
                leftExpression.putNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS, parameters);
            }
        } else if (op == 544) {
            this.pushInstanceOfTypeInfo(leftExpression, rightExpression);
        }
    }

    private ClassNode getOriginalDeclarationType(Expression lhs) {
        if (lhs instanceof VariableExpression) {
            Variable var = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)lhs);
            if (var instanceof DynamicVariable) {
                return this.getType(lhs);
            }
            return var.getOriginType();
        }
        if (lhs instanceof FieldExpression) {
            return ((FieldExpression)lhs).getField().getOriginType();
        }
        return this.getType(lhs);
    }

    private void inferDiamondType(ConstructorCallExpression cce, ClassNode lType) {
        ClassNode node = cce.getType();
        if (node.isUsingGenerics() && node.getGenericsTypes().length == 0) {
            ArgumentListExpression argumentListExpression = InvocationWriter.makeArgumentList(cce.getArguments());
            if (argumentListExpression.getExpressions().isEmpty()) {
                GenericsType[] genericsTypes = lType.getGenericsTypes();
                GenericsType[] copy = new GenericsType[genericsTypes.length];
                for (int i = 0; i < genericsTypes.length; ++i) {
                    GenericsType genericsType = genericsTypes[i];
                    copy[i] = new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(genericsType.getType()), genericsType.getUpperBounds(), genericsType.getLowerBound());
                }
                node.setGenericsTypes(copy);
            } else {
                ClassNode type = this.getType(argumentListExpression.getExpression(0));
                if (type.isUsingGenerics()) {
                    GenericsType[] genericsTypes = type.getGenericsTypes();
                    GenericsType[] copy = new GenericsType[genericsTypes.length];
                    for (int i = 0; i < genericsTypes.length; ++i) {
                        GenericsType genericsType = genericsTypes[i];
                        copy[i] = new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(genericsType.getType()), genericsType.getUpperBounds(), genericsType.getLowerBound());
                    }
                    node.setGenericsTypes(copy);
                }
            }
        }
    }

    private void pushInstanceOfTypeInfo(Expression objectOfInstanceOf, Expression typeExpression) {
        Object key;
        Map<Object, List<ClassNode>> tempo = this.temporaryIfBranchTypeInformation.peek();
        List<ClassNode> potentialTypes = tempo.get(key = this.extractTemporaryTypeInfoKey(objectOfInstanceOf));
        if (potentialTypes == null) {
            potentialTypes = new LinkedList<ClassNode>();
            tempo.put(key, potentialTypes);
        }
        potentialTypes.add(typeExpression.getType());
    }

    private void typeCheckAssignment(BinaryExpression assignmentExpression, Expression leftExpression, ClassNode leftExpressionType, Expression rightExpression, ClassNode inferredRightExpressionType) {
        ClassNode leftRedirect = StaticTypeCheckingSupport.isArrayAccessExpression(leftExpression) || leftExpression instanceof PropertyExpression || leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).getAccessedVariable() instanceof DynamicVariable ? leftExpressionType : (leftExpression instanceof VariableExpression && ClassHelper.isPrimitiveType(((VariableExpression)leftExpression).getOriginType()) ? leftExpressionType : leftExpression.getType().redirect());
        if (leftExpression instanceof TupleExpression) {
            if (!(rightExpression instanceof ListExpression)) {
                this.addStaticTypeError("Multiple assignments without list expressions on the right hand side are unsupported in static type checking mode", rightExpression);
                return;
            }
            TupleExpression tuple = (TupleExpression)leftExpression;
            ListExpression list = (ListExpression)rightExpression;
            List<Expression> listExpressions = list.getExpressions();
            List<Expression> tupleExpressions = tuple.getExpressions();
            if (listExpressions.size() < tupleExpressions.size()) {
                this.addStaticTypeError("Incorrect number of values. Expected:" + tupleExpressions.size() + " Was:" + listExpressions.size(), list);
                return;
            }
            int tupleExpressionsSize = tupleExpressions.size();
            for (int i = 0; i < tupleExpressionsSize; ++i) {
                ClassNode tupleType;
                Expression tupleExpression = tupleExpressions.get(i);
                Expression listExpression = listExpressions.get(i);
                ClassNode elemType = this.getType(listExpression);
                if (StaticTypeCheckingSupport.isAssignableTo(elemType, tupleType = this.getType(tupleExpression))) continue;
                this.addStaticTypeError("Cannot assign value of type " + elemType.getName() + " to variable of type " + tupleType.getName(), rightExpression);
                break;
            }
            return;
        }
        boolean compatible = StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftRedirect, inferredRightExpressionType, rightExpression);
        if (!compatible) {
            if (leftRedirect == READONLY_PROPERTY_RETURN && leftExpression instanceof PropertyExpression) {
                this.addStaticTypeError("Cannot set read-only property: " + ((PropertyExpression)leftExpression).getPropertyAsString(), leftExpression);
            } else {
                this.addStaticTypeError("Cannot assign value of type " + inferredRightExpressionType.getName() + " to variable of type " + leftExpressionType.getName(), assignmentExpression);
            }
        } else {
            GenericsType gt;
            ClassNode[] args;
            ArgumentListExpression argList;
            Object type;
            if (rightExpression instanceof ClosureExpression && (type = rightExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) != null) {
                leftExpression.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, type);
            }
            boolean possibleLooseOfPrecision = false;
            if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(inferredRightExpressionType) && (possibleLooseOfPrecision = StaticTypeCheckingSupport.checkPossibleLooseOfPrecision(leftRedirect, inferredRightExpressionType, rightExpression))) {
                this.addStaticTypeError("Possible loose of precision from " + inferredRightExpressionType + " to " + leftRedirect, rightExpression);
            }
            if (!possibleLooseOfPrecision && leftExpressionType.isArray()) {
                ClassNode leftComponentType = leftExpressionType.getComponentType();
                ClassNode rightRedirect = rightExpression.getType().redirect();
                if (rightRedirect.isArray()) {
                    ClassNode rightComponentType = rightRedirect.getComponentType();
                    if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType, rightComponentType)) {
                        this.addStaticTypeError("Cannot assign value of type " + rightComponentType + " into array of type " + leftExpressionType, assignmentExpression);
                    }
                } else if (rightExpression instanceof ListExpression) {
                    for (Expression element : ((ListExpression)rightExpression).getExpressions()) {
                        ClassNode rightComponentType = element.getType().redirect();
                        if (StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftComponentType, rightComponentType)) continue;
                        this.addStaticTypeError("Cannot assign value of type " + rightComponentType + " into array of type " + leftExpressionType, assignmentExpression);
                    }
                }
            }
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(leftRedirect, ClassHelper.LIST_TYPE) && rightExpression instanceof ListExpression) {
                argList = new ArgumentListExpression(((ListExpression)rightExpression).getExpressions());
                args = this.getArgumentTypes(argList);
                this.checkGroovyStyleConstructor(leftRedirect, args);
            } else if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, leftRedirect) && StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(inferredRightExpressionType, ClassHelper.LIST_TYPE)) {
                this.addStaticTypeError("Cannot assign value of type " + inferredRightExpressionType.getName() + " to variable of type " + leftExpressionType.getName(), assignmentExpression);
            }
            if (!(StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(leftRedirect, ClassHelper.MAP_TYPE) || !(rightExpression instanceof MapExpression) || leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).isDynamicTyped())) {
                argList = new ArgumentListExpression(rightExpression);
                args = this.getArgumentTypes(argList);
                this.checkGroovyStyleConstructor(leftRedirect, args);
                MapExpression mapExpression = (MapExpression)rightExpression;
                for (MapEntryExpression entryExpression : mapExpression.getMapEntryExpressions()) {
                    Expression keyExpr = entryExpression.getKeyExpression();
                    if (!(keyExpr instanceof ConstantExpression)) {
                        this.addStaticTypeError("Dynamic keys in map-style constructors are unsupported in static type checking", keyExpr);
                        continue;
                    }
                    String property = keyExpr.getText();
                    PropertyNode propertyNode = null;
                    for (ClassNode currentNode = leftRedirect; propertyNode == null && currentNode != null; currentNode = currentNode.getSuperClass()) {
                        propertyNode = currentNode.getProperty(property);
                    }
                    if (propertyNode == null) {
                        this.addStaticTypeError("No such property: " + property + " for class: " + leftRedirect.getName(), leftExpression);
                        continue;
                    }
                    if (propertyNode == null) continue;
                    ClassNode valueType = this.getType(entryExpression.getValueExpression());
                    if (StaticTypeCheckingSupport.isAssignableTo(propertyNode.getType(), valueType)) continue;
                    this.addStaticTypeError("Cannot assign value of type " + valueType.getName() + " to field of type " + propertyNode.getType().getName(), entryExpression);
                }
            }
            if (leftExpressionType.isUsingGenerics() && !leftExpressionType.isEnum() && !(gt = GenericsUtils.buildWildcardType(leftExpressionType)).isCompatibleWith(inferredRightExpressionType)) {
                this.addStaticTypeError("Incompatible generic argument types. Cannot assign " + inferredRightExpressionType.toString(false) + " to: " + leftExpressionType.toString(false), assignmentExpression);
            }
        }
    }

    private void checkGroovyStyleConstructor(ClassNode node, ClassNode[] arguments) {
        if (node.equals(ClassHelper.OBJECT_TYPE) || node.equals(ClassHelper.DYNAMIC_TYPE)) {
            return;
        }
        List<ConstructorNode> constructors = node.getDeclaredConstructors();
        if (constructors.isEmpty() && arguments.length == 0) {
            return;
        }
        List<MethodNode> constructorList = this.findMethod(node, "<init>", arguments);
        if (constructorList.isEmpty()) {
            this.addStaticTypeError("No matching constructor found: " + node + StaticTypeCheckingSupport.toMethodParametersString("<init>", arguments), this.classNode);
        }
    }

    private Object extractTemporaryTypeInfoKey(Expression expression) {
        return expression instanceof VariableExpression ? StaticTypeCheckingSupport.findTargetVariable((VariableExpression)expression) : expression.getText();
    }

    private ClassNode findCurrentInstanceOfClass(Expression expr, ClassNode type) {
        if (!this.temporaryIfBranchTypeInformation.empty()) {
            Object key = this.extractTemporaryTypeInfoKey(expr);
            List<ClassNode> nodes = this.temporaryIfBranchTypeInformation.peek().get(key);
            if (nodes != null && nodes.size() == 1) {
                return nodes.get(0);
            }
        }
        return type;
    }

    private boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly) {
        return this.existsProperty(pexp, checkForReadOnly, null);
    }

    private boolean existsProperty(PropertyExpression pexp, boolean checkForReadOnly, ClassCodeVisitorSupport visitor) {
        String propertyName;
        Object key;
        Map<Object, List<ClassNode>> info;
        List<ClassNode> classNodes;
        Expression objectExpression = pexp.getObjectExpression();
        ClassNode clazz = this.getType(objectExpression);
        if (clazz.isArray() && "length".equals(pexp.getPropertyAsString())) {
            if (visitor != null) {
                PropertyNode node = new PropertyNode("length", 17, ClassHelper.int_TYPE, clazz, null, null, null);
                this.storeType(pexp, ClassHelper.int_TYPE);
                visitor.visitProperty(node);
            }
            return true;
        }
        LinkedList<ClassNode> tests = new LinkedList<ClassNode>();
        tests.add(clazz);
        if (objectExpression instanceof ClassExpression) {
            tests.add(ClassHelper.CLASS_Type);
        }
        if (!this.temporaryIfBranchTypeInformation.empty() && (classNodes = (info = this.temporaryIfBranchTypeInformation.peek()).get(key = this.extractTemporaryTypeInfoKey(objectExpression))) != null) {
            tests.addAll(classNodes);
        }
        if (this.lastImplicitItType != null && pexp.getObjectExpression() instanceof VariableExpression && ((VariableExpression)pexp.getObjectExpression()).getName().equals("it")) {
            tests.add(this.lastImplicitItType);
        }
        if ((propertyName = pexp.getPropertyAsString()) == null) {
            return false;
        }
        boolean isAttributeExpression = pexp instanceof AttributeExpression;
        for (ClassNode testClass : tests) {
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(testClass, ClassHelper.MAP_TYPE) && !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(testClass, ClassHelper.LIST_TYPE)) {
                ClassNode current = testClass;
                while (current != null) {
                    FieldNode field;
                    PropertyNode propertyNode = (current = current.redirect()).getProperty(propertyName);
                    if (propertyNode != null) {
                        if (visitor != null) {
                            visitor.visitProperty(propertyNode);
                        }
                        this.storeType(pexp, propertyNode.getOriginType());
                        return true;
                    }
                    if (!isAttributeExpression && (field = current.getDeclaredField(propertyName)) != null) {
                        if (visitor != null) {
                            visitor.visitField(field);
                        }
                        this.storeType(pexp, field.getOriginType());
                        return true;
                    }
                    current = isAttributeExpression ? null : current.getSuperClass();
                }
                if (!checkForReadOnly) continue;
                current = testClass;
                while (current != null) {
                    current = current.redirect();
                    String pname = MetaClassHelper.capitalize(propertyName);
                    List<MethodNode> nodes = current.getMethods("get" + pname);
                    if (nodes.isEmpty()) {
                        nodes = current.getMethods("is" + pname);
                    }
                    if (!nodes.isEmpty()) {
                        for (MethodNode node : nodes) {
                            Parameter[] parameters = node.getParameters();
                            if (node.getReturnType() == ClassHelper.VOID_TYPE || parameters != null && parameters.length != 0) continue;
                            if (visitor != null) {
                                visitor.visitMethod(node);
                            }
                            this.storeType(pexp, READONLY_PROPERTY_RETURN);
                            return true;
                        }
                    }
                    current = isAttributeExpression ? null : current.getSuperClass();
                }
                continue;
            }
            if (visitor != null) {
                PropertyNode node = new PropertyNode(propertyName, 1, ClassHelper.OBJECT_TYPE, clazz, null, null, null);
                visitor.visitProperty(node);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitForLoop(ForStatement forLoop) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        ClassNode collectionType = this.getType(forLoop.getCollectionExpression());
        ClassNode componentType = collectionType.getComponentType();
        if (componentType == null) {
            if (collectionType.implementsInterface(ITERABLE_TYPE)) {
                ClassNode intf = GenericsUtils.parameterizeInterfaceGenerics(collectionType, ITERABLE_TYPE);
                GenericsType[] genericsTypes = intf.getGenericsTypes();
                componentType = genericsTypes[0].getType();
            } else {
                componentType = collectionType == ClassHelper.STRING_TYPE ? ClassHelper.Character_TYPE : ClassHelper.OBJECT_TYPE;
            }
        }
        this.forLoopVariableTypes.put(forLoop.getVariable(), componentType);
        if (!StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(forLoop.getVariableType(), componentType)) {
            this.addStaticTypeError("Cannot loop with element of type " + forLoop.getVariableType() + " with collection of type " + collectionType, forLoop);
        }
        try {
            super.visitForLoop(forLoop);
        }
        finally {
            this.forLoopVariableTypes.remove(forLoop.getVariable());
        }
        this.popAssignmentTracking(oldTracker);
    }

    @Override
    public void visitWhileLoop(WhileStatement loop) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        super.visitWhileLoop(loop);
        this.popAssignmentTracking(oldTracker);
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        ClassNode resultType;
        super.visitBitwiseNegationExpression(expression);
        ClassNode type = this.getType(expression);
        ClassNode typeRe = type.redirect();
        if (WideningCategories.isBigIntCategory(typeRe)) {
            resultType = type;
        } else if (typeRe == ClassHelper.STRING_TYPE || typeRe == ClassHelper.GSTRING_TYPE) {
            resultType = ClassHelper.PATTERN_TYPE;
        } else if (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE) {
            resultType = StaticTypeCheckingSupport.ArrayList_TYPE;
        } else {
            MethodNode mn = this.findMethodOrFail(expression, type, "bitwiseNegate", new ClassNode[0]);
            resultType = mn.getReturnType();
        }
        this.storeType(expression, resultType);
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        super.visitUnaryPlusExpression(expression);
        this.negativeOrPositiveUnary(expression, "positive");
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        super.visitUnaryMinusExpression(expression);
        this.negativeOrPositiveUnary(expression, "negative");
    }

    private void negativeOrPositiveUnary(Expression expression, String name) {
        ClassNode resultType;
        ClassNode type = this.getType(expression);
        ClassNode typeRe = type.redirect();
        if (WideningCategories.isBigDecCategory(typeRe)) {
            resultType = type;
        } else if (typeRe == StaticTypeCheckingSupport.ArrayList_TYPE) {
            resultType = StaticTypeCheckingSupport.ArrayList_TYPE;
        } else {
            MethodNode mn = this.findMethodOrFail(expression, type, name, new ClassNode[0]);
            resultType = mn.getReturnType();
        }
        this.storeType(expression, resultType);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        MethodNode old = this.methodNode;
        this.methodNode = node;
        super.visitConstructorOrMethod(node, isConstructor);
        if (!isConstructor) {
            this.returnAdder.visitMethod(node);
        }
        this.methodNode = old;
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement) {
        super.visitReturnStatement(statement);
        this.checkReturnType(statement);
        if (this.closureExpression != null && statement.getExpression() != ConstantExpression.NULL) {
            this.addClosureReturnType(this.getType(statement.getExpression()));
        }
    }

    private ClassNode checkReturnType(ReturnStatement statement) {
        ClassNode type = this.getType(statement.getExpression());
        if (!(this.methodNode == null || this.methodNode.isVoidMethod() || type.equals(ClassHelper.void_WRAPPER_TYPE) || type.equals(ClassHelper.VOID_TYPE) || StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(this.methodNode.getReturnType(), type))) {
            this.addStaticTypeError("Cannot return value of type " + type + " on method returning type " + this.methodNode.getReturnType(), statement.getExpression());
        }
        return type;
    }

    private void addClosureReturnType(ClassNode returnType) {
        if (this.closureReturnTypes == null) {
            this.closureReturnTypes = new LinkedList<ClassNode>();
        }
        this.closureReturnTypes.add(returnType);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        super.visitConstructorCallExpression(call);
        ClassNode receiver = call.isThisCall() ? this.classNode : (call.isSuperCall() ? this.classNode.getSuperClass() : call.getType());
        ClassNode[] args = this.getArgumentTypes(InvocationWriter.makeArgumentList(call.getArguments()));
        MethodNode node = this.findMethodOrFail(call, receiver, "<init>", args);
        if (node != null) {
            this.storeTargetMethod(call, node);
        }
    }

    private ClassNode[] getArgumentTypes(ArgumentListExpression args) {
        List<Expression> arglist = args.getExpressions();
        ClassNode[] ret = new ClassNode[arglist.size()];
        int i = 0;
        for (Expression exp : arglist) {
            ret[i] = exp instanceof ConstantExpression && ((ConstantExpression)exp).getValue() == null ? StaticTypeCheckingSupport.UNKNOWN_PARAMETER_TYPE : this.getType(exp);
            ++i;
        }
        return ret;
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        SharedVariableCollector collector = new SharedVariableCollector(this.getSourceUnit());
        collector.visitClosureExpression(expression);
        Set<VariableExpression> closureSharedExpressions = collector.getClosureSharedExpressions();
        HashMap<VariableExpression, ListHashMap> typesBeforeVisit = null;
        if (!closureSharedExpressions.isEmpty()) {
            typesBeforeVisit = new HashMap<VariableExpression, ListHashMap>();
            this.saveVariableExpressionMetadata(closureSharedExpressions, typesBeforeVisit);
        }
        ClosureExpression oldClosureExpr = this.closureExpression;
        List<ClassNode> oldClosureReturnTypes = this.closureReturnTypes;
        this.closureExpression = expression;
        super.visitClosureExpression(expression);
        MethodNode node = new MethodNode("dummy", 0, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, expression.getCode());
        this.closureReturnAdder.visitMethod(node);
        if (this.closureReturnTypes != null) {
            expression.putNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE, WideningCategories.lowestUpperBound(this.closureReturnTypes));
        }
        this.closureExpression = oldClosureExpr;
        this.closureReturnTypes = oldClosureReturnTypes;
        this.restoreVariableExpressionMetadata(typesBeforeVisit);
    }

    private void restoreVariableExpressionMetadata(Map<VariableExpression, ListHashMap> typesBeforeVisit) {
        if (typesBeforeVisit != null) {
            for (Map.Entry<VariableExpression, ListHashMap> entry : typesBeforeVisit.entrySet()) {
                VariableExpression ve = entry.getKey();
                ListHashMap metadata = entry.getValue();
                for (StaticTypesMarker marker : StaticTypesMarker.values()) {
                    ve.removeNodeMetaData((Object)marker);
                    Object value = metadata.get((Object)marker);
                    if (value == null) continue;
                    ve.setNodeMetaData((Object)marker, value);
                }
            }
        }
    }

    private void saveVariableExpressionMetadata(Set<VariableExpression> closureSharedExpressions, Map<VariableExpression, ListHashMap> typesBeforeVisit) {
        for (VariableExpression ve : closureSharedExpressions) {
            ListHashMap<StaticTypesMarker, Object> metadata = new ListHashMap<StaticTypesMarker, Object>();
            for (StaticTypesMarker marker : StaticTypesMarker.values()) {
                Object value = ve.getNodeMetaData((Object)marker);
                if (value == null) continue;
                metadata.put(marker, value);
            }
            typesBeforeVisit.put(ve, metadata);
            Variable accessedVariable = ve.getAccessedVariable();
            if (accessedVariable == ve || !(accessedVariable instanceof VariableExpression)) continue;
            this.saveVariableExpressionMetadata(Collections.singleton((VariableExpression)accessedVariable), typesBeforeVisit);
        }
    }

    @Override
    public void visitMethod(MethodNode node) {
        if (this.alreadyVisitedMethods.contains(node)) {
            return;
        }
        this.alreadyVisitedMethods.add(node);
        if (!this.methodsToBeVisited.isEmpty() && !this.methodsToBeVisited.contains(node)) {
            return;
        }
        super.visitMethod(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        String name = call.getMethodAsString();
        if (name == null) {
            this.addStaticTypeError("cannot resolve dynamic method name at compile time.", call.getMethod());
            return;
        }
        Expression objectExpression = call.getObjectExpression();
        objectExpression.visit(this);
        call.getMethod().visit(this);
        if (call.isSpreadSafe()) {
            ClassNode expressionType = this.getType(objectExpression);
            if (!expressionType.equals(StaticTypeCheckingSupport.Collection_TYPE) && !expressionType.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE)) {
                this.addStaticTypeError("Spread operator can only be used on collection types", expressionType);
                return;
            }
            ClassNode componentType = this.inferComponentType(expressionType);
            MethodCallExpression subcall = new MethodCallExpression((Expression)new CastExpression(componentType, EmptyExpression.INSTANCE), name, call.getArguments());
            subcall.setLineNumber(call.getLineNumber());
            subcall.setColumnNumber(call.getColumnNumber());
            this.visitMethodCallExpression(subcall);
            ClassNode subcallReturnType = this.getType(subcall);
            ClassNode listNode = new ClassNode(List.class);
            listNode.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(subcallReturnType))});
            this.storeType(call, listNode);
            return;
        }
        ClassNode rememberLastItType = this.lastImplicitItType;
        Expression callArguments = call.getArguments();
        boolean isWithCall = StaticTypeCheckingSupport.isWithCall(name, callArguments);
        if (!isWithCall) {
            callArguments.visit(this);
        }
        ClassNode[] args = this.getArgumentTypes(InvocationWriter.makeArgumentList(callArguments));
        boolean isCallOnClosure = this.isClosureCall(name, objectExpression);
        ClassNode receiver = this.getType(objectExpression);
        if (isWithCall) {
            this.withReceiverList.add(0, receiver);
            this.lastImplicitItType = receiver;
            if (callArguments instanceof ArgumentListExpression) {
                Parameter param;
                ArgumentListExpression argList = (ArgumentListExpression)callArguments;
                ClosureExpression closure = (ClosureExpression)argList.getExpression(0);
                Parameter[] parameters = closure.getParameters();
                if (parameters.length > 1) {
                    this.addStaticTypeError("Unexpected number of parameters for a with call", argList);
                } else if (parameters.length == 1 && !(param = parameters[0]).isDynamicTyped() && !StaticTypeCheckingSupport.isAssignableTo(receiver, param.getType().redirect())) {
                    this.addStaticTypeError("Expected parameter type: " + receiver.toString(false) + " but was: " + param.getType().redirect().toString(false), param);
                }
            }
        }
        try {
            Object key;
            Map<Object, List<ClassNode>> tempo;
            List<ClassNode> potentialReceiverType;
            if (isWithCall) {
                callArguments.visit(this);
            }
            LinkedList<ClassNode> receivers = new LinkedList<ClassNode>();
            if (!this.withReceiverList.isEmpty()) {
                receivers.addAll(this.withReceiverList);
            }
            receivers.add(receiver);
            if (objectExpression instanceof ClassExpression) {
                receivers.add(ClassHelper.CLASS_Type);
            }
            if (!this.temporaryIfBranchTypeInformation.empty() && (potentialReceiverType = (tempo = this.temporaryIfBranchTypeInformation.peek()).get(key = this.extractTemporaryTypeInfoKey(objectExpression))) != null) {
                receivers.addAll(potentialReceiverType);
            }
            List<MethodNode> mn = null;
            ClassNode chosenReceiver = null;
            for (ClassNode currentReceiver : receivers) {
                mn = this.findMethod(currentReceiver, name, args);
                if (mn.isEmpty()) continue;
                this.typeCheckMethodsWithGenerics(currentReceiver, args, mn, call);
                chosenReceiver = currentReceiver;
                break;
            }
            if (mn.isEmpty()) {
                this.addStaticTypeError("Cannot find matching method " + receiver.getName() + "#" + StaticTypeCheckingSupport.toMethodParametersString(name, args), call);
            } else if (isCallOnClosure) {
                Object data;
                if (objectExpression instanceof VariableExpression) {
                    Variable variable = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression);
                    if (variable instanceof Expression) {
                        Object type;
                        data = ((Expression)((Object)variable)).getNodeMetaData((Object)StaticTypesMarker.CLOSURE_ARGUMENTS);
                        if (data != null) {
                            Parameter[] parameters = (Parameter[])data;
                            this.typeCheckClosureCall(callArguments, args, parameters);
                        }
                        if ((type = ((Expression)((Object)variable)).getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) != null) {
                            this.storeType(call, (ClassNode)type);
                        }
                    }
                } else if (objectExpression instanceof ClosureExpression) {
                    Parameter[] parameters = ((ClosureExpression)objectExpression).getParameters();
                    this.typeCheckClosureCall(callArguments, args, parameters);
                    data = objectExpression.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
                    if (data != null) {
                        this.storeType(call, (ClassNode)data);
                    }
                }
            } else if (mn.size() == 1) {
                VariableExpression var;
                MethodNode directMethodCallCandidate = mn.get(0);
                ClassNode currentClassNode = this.classNode;
                this.classNode = directMethodCallCandidate.getDeclaringClass();
                this.visitMethod(directMethodCallCandidate);
                this.classNode = currentClassNode;
                ClassNode returnType = this.getType(directMethodCallCandidate);
                if (returnType.isUsingGenerics()) {
                    returnType = this.inferReturnTypeGenerics(chosenReceiver, directMethodCallCandidate, callArguments);
                }
                this.storeType(call, returnType);
                this.storeTargetMethod(call, directMethodCallCandidate);
                if (objectExpression instanceof VariableExpression && (var = (VariableExpression)objectExpression).isClosureSharedVariable()) {
                    this.secondPassExpressions.add(call);
                }
            } else {
                this.addStaticTypeError("Reference to method is ambiguous. Cannot choose between " + mn, call);
            }
        }
        finally {
            if (isWithCall) {
                this.lastImplicitItType = rememberLastItType;
                this.withReceiverList.removeFirst();
            }
        }
    }

    private void storeTargetMethod(Expression call, MethodNode directMethodCallCandidate) {
        call.putNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET, directMethodCallCandidate);
    }

    private boolean isClosureCall(String name, Expression objectExpression) {
        if (!"call".equals(name)) {
            return false;
        }
        if (objectExpression instanceof ClosureExpression) {
            return true;
        }
        return this.getType(objectExpression).equals(ClassHelper.CLOSURE_TYPE);
    }

    private void typeCheckClosureCall(Expression callArguments, ClassNode[] args, Parameter[] parameters) {
        if (StaticTypeCheckingSupport.allParametersAndArgumentsMatch(parameters, args) < 0 && StaticTypeCheckingSupport.lastArgMatchesVarg(parameters, args) < 0) {
            StringBuilder sb = new StringBuilder("[");
            int parametersLength = parameters.length;
            for (int i = 0; i < parametersLength; ++i) {
                Parameter parameter = parameters[i];
                sb.append(parameter.getType().getName());
                if (i >= parametersLength - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            this.addStaticTypeError("Closure argument types: " + sb + " do not match with parameter types: " + Arrays.toString(args), callArguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIfElse(IfStatement ifElse) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        try {
            this.pushTemporaryTypeInfo();
            this.visitStatement(ifElse);
            ifElse.getBooleanExpression().visit(this);
            ifElse.getIfBlock().visit(this);
            this.temporaryIfBranchTypeInformation.pop();
            Statement elseBlock = ifElse.getElseBlock();
            if (elseBlock instanceof EmptyStatement) {
                this.visitEmptyStatement((EmptyStatement)elseBlock);
            } else {
                elseBlock.visit(this);
            }
        }
        finally {
            this.popAssignmentTracking(oldTracker);
        }
    }

    private void popAssignmentTracking(Map<VariableExpression, List<ClassNode>> oldTracker) {
        if (!this.ifElseForWhileAssignmentTracker.isEmpty()) {
            for (Map.Entry<VariableExpression, List<ClassNode>> entry : this.ifElseForWhileAssignmentTracker.entrySet()) {
                this.storeType(entry.getKey(), WideningCategories.lowestUpperBound(entry.getValue()));
            }
        }
        this.ifElseForWhileAssignmentTracker = oldTracker;
    }

    private Map<VariableExpression, List<ClassNode>> pushAssignmentTracking() {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.ifElseForWhileAssignmentTracker;
        this.ifElseForWhileAssignmentTracker = new HashMap<VariableExpression, List<ClassNode>>();
        return oldTracker;
    }

    @Override
    public void visitCastExpression(CastExpression expression) {
        super.visitCastExpression(expression);
        if (!expression.isCoerce()) {
            ClassNode targetType = expression.getType();
            Expression source = expression.getExpression();
            boolean sourceIsNull = source instanceof ConstantExpression && ((ConstantExpression)source).getValue() == null;
            ClassNode expressionType = this.getType(source);
            if (!(targetType.equals(ClassHelper.char_TYPE) && expressionType == ClassHelper.STRING_TYPE && source instanceof ConstantExpression && source.getText().length() == 1 || targetType.equals(ClassHelper.Character_TYPE) && (expressionType == ClassHelper.STRING_TYPE || sourceIsNull) && (sourceIsNull || source instanceof ConstantExpression && source.getText().length() == 1) || WideningCategories.isNumberCategory(ClassHelper.getWrapper(targetType)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(expressionType)) || sourceIsNull && !ClassHelper.isPrimitiveType(targetType) || StaticTypeCheckingSupport.isAssignableTo(expressionType, targetType))) {
                this.addStaticTypeError("Inconvertible types: cannot cast " + expressionType.getName() + " to " + targetType.getName(), expression);
            }
        }
        this.storeType(expression, expression.getType());
    }

    @Override
    public void visitTernaryExpression(TernaryExpression expression) {
        Map<VariableExpression, List<ClassNode>> oldTracker = this.pushAssignmentTracking();
        this.pushTemporaryTypeInfo();
        expression.getBooleanExpression().visit(this);
        expression.getTrueExpression().visit(this);
        this.temporaryIfBranchTypeInformation.pop();
        expression.getFalseExpression().visit(this);
        ClassNode typeOfTrue = this.getType(expression.getTrueExpression());
        ClassNode typeOfFalse = this.getType(expression.getFalseExpression());
        this.storeType(expression, WideningCategories.lowestUpperBound(typeOfTrue, typeOfFalse));
        this.popAssignmentTracking(oldTracker);
    }

    private void pushTemporaryTypeInfo() {
        HashMap potentialTypes = new HashMap();
        this.temporaryIfBranchTypeInformation.push(potentialTypes);
    }

    private void storeType(Expression exp, ClassNode cn) {
        ClassNode oldValue = (ClassNode)exp.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, cn);
        if (oldValue != null) {
            ClassNode oldDIT = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE);
            if (oldDIT != null) {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, WideningCategories.lowestUpperBound(oldDIT, cn));
            } else {
                exp.putNodeMetaData((Object)StaticTypesMarker.DECLARATION_INFERRED_TYPE, WideningCategories.lowestUpperBound(oldValue, cn));
            }
        }
        if (exp instanceof VariableExpression) {
            VariableExpression var = (VariableExpression)exp;
            Variable accessedVariable = var.getAccessedVariable();
            if (accessedVariable != null && accessedVariable != exp && accessedVariable instanceof VariableExpression) {
                this.storeType((Expression)((Object)accessedVariable), cn);
            }
            if (var.isClosureSharedVariable()) {
                List<ClassNode> assignedTypes = this.closureSharedVariablesAssignmentTypes.get(var);
                if (assignedTypes == null) {
                    assignedTypes = new LinkedList<ClassNode>();
                    this.closureSharedVariablesAssignmentTypes.put(var, assignedTypes);
                }
                assignedTypes.add(cn);
            }
        }
    }

    private ClassNode getResultType(ClassNode left, int op, ClassNode right, BinaryExpression expr) {
        MethodNode method;
        String operationName;
        ClassNode leftRedirect = left.redirect();
        ClassNode rightRedirect = right.redirect();
        Expression leftExpression = expr.getLeftExpression();
        if (op == 100) {
            ClassNode initialType;
            if (leftRedirect.isArray() && !rightRedirect.isArray()) {
                return leftRedirect;
            }
            if (leftRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE) && rightRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE)) {
                List<Expression> list;
                if (expr.getRightExpression() instanceof ListExpression && (list = ((ListExpression)expr.getRightExpression()).getExpressions()).isEmpty()) {
                    return left;
                }
                return right;
            }
            if (rightRedirect.implementsInterface(StaticTypeCheckingSupport.Collection_TYPE) && rightRedirect.isDerivedFrom(leftRedirect)) {
                return right;
            }
            if (leftExpression instanceof VariableExpression && (ClassHelper.STRING_TYPE.equals(initialType = this.getOriginalDeclarationType(leftExpression).redirect()) || ClassHelper.CLASS_Type.equals(initialType) || ClassHelper.Boolean_TYPE.equals(initialType))) {
                return initialType;
            }
            return right;
        }
        if (StaticTypeCheckingSupport.isBoolIntrinsicOp(op)) {
            return ClassHelper.boolean_TYPE;
        }
        if (StaticTypeCheckingSupport.isArrayOp(op)) {
            if (ClassHelper.STRING_TYPE.equals(left)) {
                return ClassHelper.STRING_TYPE;
            }
            return this.inferComponentType(left);
        }
        if (op == 90) {
            return StaticTypeCheckingSupport.Matcher_TYPE;
        }
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
            if (StaticTypeCheckingSupport.isOperationInGroup(op)) {
                if (WideningCategories.isIntCategory(leftRedirect) && WideningCategories.isIntCategory(rightRedirect)) {
                    return ClassHelper.int_TYPE;
                }
                if (WideningCategories.isLongCategory(leftRedirect) && WideningCategories.isLongCategory(rightRedirect)) {
                    return ClassHelper.long_TYPE;
                }
                if (WideningCategories.isFloat(leftRedirect) && WideningCategories.isFloat(rightRedirect)) {
                    return ClassHelper.float_TYPE;
                }
                if (WideningCategories.isDouble(leftRedirect) && WideningCategories.isDouble(rightRedirect)) {
                    return ClassHelper.double_TYPE;
                }
            } else {
                if (StaticTypeCheckingSupport.isPowerOperator(op)) {
                    return ClassHelper.Number_TYPE;
                }
                if (StaticTypeCheckingSupport.isBitOperator(op)) {
                    if (WideningCategories.isIntCategory(leftRedirect) && WideningCategories.isIntCategory(rightRedirect)) {
                        return ClassHelper.int_TYPE;
                    }
                    if (WideningCategories.isLongCategory(leftRedirect) && WideningCategories.isLongCategory(rightRedirect)) {
                        return ClassHelper.Long_TYPE;
                    }
                    if (WideningCategories.isBigIntCategory(leftRedirect) && WideningCategories.isBigIntCategory(rightRedirect)) {
                        return ClassHelper.BigInteger_TYPE;
                    }
                } else if (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123) {
                    return ClassHelper.boolean_TYPE;
                }
            }
        }
        if (StaticTypeCheckingSupport.isShiftOperation(operationName = StaticTypeCheckingSupport.getOperationName(op)) && WideningCategories.isNumberCategory(leftRedirect) && (WideningCategories.isIntCategory(rightRedirect) || WideningCategories.isLongCategory(rightRedirect))) {
            return leftRedirect;
        }
        if (203 == op || 213 == op) {
            if (WideningCategories.isFloatingCategory(leftRedirect) || WideningCategories.isFloatingCategory(rightRedirect)) {
                return ClassHelper.Double_TYPE;
            }
            if (ClassHelper.BigDecimal_TYPE.equals(leftRedirect) || ClassHelper.BigDecimal_TYPE.equals(rightRedirect)) {
                return ClassHelper.BigDecimal_TYPE;
            }
        } else if (StaticTypeCheckingSupport.isOperationInGroup(op) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(leftRedirect)) && WideningCategories.isNumberCategory(ClassHelper.getWrapper(rightRedirect))) {
            return StaticTypeCheckingVisitor.getGroupOperationResultType(leftRedirect, rightRedirect);
        }
        if ((method = this.findMethodOrFail(expr, leftRedirect, operationName, rightRedirect)) != null) {
            this.typeCheckMethodsWithGenerics(left, new ClassNode[]{right}, Collections.singletonList(method), expr);
            if (StaticTypeCheckingSupport.isAssignment(op)) {
                return left;
            }
            if (StaticTypeCheckingSupport.isCompareToBoolean(op)) {
                return ClassHelper.boolean_TYPE;
            }
            if (op == 128) {
                return ClassHelper.int_TYPE;
            }
            return this.inferReturnTypeGenerics(left, method, new ArgumentListExpression(expr.getRightExpression()));
        }
        return null;
    }

    private static ClassNode getGroupOperationResultType(ClassNode a, ClassNode b) {
        if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
            return ClassHelper.BigInteger_TYPE;
        }
        if (WideningCategories.isBigDecCategory(a) && WideningCategories.isBigDecCategory(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigDecimal_TYPE.equals(a) || ClassHelper.BigDecimal_TYPE.equals(b)) {
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.BigInteger_TYPE.equals(a) || ClassHelper.BigInteger_TYPE.equals(b)) {
            if (WideningCategories.isBigIntCategory(a) && WideningCategories.isBigIntCategory(b)) {
                return ClassHelper.BigInteger_TYPE;
            }
            return ClassHelper.BigDecimal_TYPE;
        }
        if (ClassHelper.double_TYPE.equals(a) || ClassHelper.double_TYPE.equals(b)) {
            return ClassHelper.double_TYPE;
        }
        if (ClassHelper.Double_TYPE.equals(a) || ClassHelper.Double_TYPE.equals(b)) {
            return ClassHelper.Double_TYPE;
        }
        if (ClassHelper.float_TYPE.equals(a) || ClassHelper.float_TYPE.equals(b)) {
            return ClassHelper.float_TYPE;
        }
        if (ClassHelper.Float_TYPE.equals(a) || ClassHelper.Float_TYPE.equals(b)) {
            return ClassHelper.Float_TYPE;
        }
        if (ClassHelper.long_TYPE.equals(a) || ClassHelper.long_TYPE.equals(b)) {
            return ClassHelper.long_TYPE;
        }
        if (ClassHelper.Long_TYPE.equals(a) || ClassHelper.Long_TYPE.equals(b)) {
            return ClassHelper.Long_TYPE;
        }
        if (ClassHelper.int_TYPE.equals(a) || ClassHelper.int_TYPE.equals(b)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Integer_TYPE.equals(a) || ClassHelper.Integer_TYPE.equals(b)) {
            return ClassHelper.Integer_TYPE;
        }
        if (ClassHelper.short_TYPE.equals(a) || ClassHelper.short_TYPE.equals(b)) {
            return ClassHelper.short_TYPE;
        }
        if (ClassHelper.Short_TYPE.equals(a) || ClassHelper.Short_TYPE.equals(b)) {
            return ClassHelper.Short_TYPE;
        }
        if (ClassHelper.byte_TYPE.equals(a) || ClassHelper.byte_TYPE.equals(b)) {
            return ClassHelper.byte_TYPE;
        }
        if (ClassHelper.Byte_TYPE.equals(a) || ClassHelper.Byte_TYPE.equals(b)) {
            return ClassHelper.Byte_TYPE;
        }
        if (ClassHelper.char_TYPE.equals(a) || ClassHelper.char_TYPE.equals(b)) {
            return ClassHelper.char_TYPE;
        }
        if (ClassHelper.Character_TYPE.equals(a) || ClassHelper.Character_TYPE.equals(b)) {
            return ClassHelper.Character_TYPE;
        }
        return ClassHelper.Number_TYPE;
    }

    private ClassNode inferComponentType(ClassNode containerType) {
        ClassNode componentType = containerType.getComponentType();
        if (componentType == null) {
            GenericsType[] types = containerType.getGenericsTypes();
            if (types != null && types.length == 1) {
                return types[0].getType();
            }
            return ClassHelper.OBJECT_TYPE;
        }
        return componentType;
    }

    private MethodNode findMethodOrFail(Expression expr, ClassNode receiver, String name, ClassNode ... args) {
        List<MethodNode> methods = this.findMethod(receiver, name, args);
        if (methods.isEmpty()) {
            this.addStaticTypeError("Cannot find matching method " + receiver.getName() + "#" + StaticTypeCheckingSupport.toMethodParametersString(name, args), expr);
        } else {
            if (methods.size() == 1) {
                return methods.get(0);
            }
            this.addStaticTypeError("Reference to method is ambiguous. Cannot choose between " + methods, expr);
        }
        return null;
    }

    private List<MethodNode> findMethod(ClassNode receiver, String name, ClassNode ... args) {
        List<MethodNode> chosen;
        List<MethodNode> methods;
        if (ClassHelper.isPrimitiveType(receiver)) {
            receiver = ClassHelper.getWrapper(receiver);
        }
        if ("<init>".equals(name)) {
            methods = new ArrayList<ConstructorNode>(receiver.getDeclaredConstructors());
            if (methods.isEmpty()) {
                MethodNode node = new MethodNode("<init>", 1, receiver, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
                node.setDeclaringClass(receiver);
                return Collections.singletonList(node);
            }
        } else {
            methods = receiver.getMethods(name);
            if (methods.isEmpty() && args == null || args.length == 0) {
                PropertyNode property;
                String pname = null;
                if (name.startsWith("get")) {
                    pname = Introspector.decapitalize(name.substring(3));
                } else if (name.startsWith("is")) {
                    pname = Introspector.decapitalize(name.substring(2));
                }
                if (pname != null && (property = receiver.getProperty(pname)) != null) {
                    return Collections.singletonList(new MethodNode(name, 1, property.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE));
                }
            }
        }
        if (!(chosen = this.chooseBestMethod(receiver, methods, args)).isEmpty()) {
            return chosen;
        }
        methods.clear();
        chosen = this.findDGMMethodsByNameAndArguments(receiver, name, args, methods);
        if (!chosen.isEmpty()) {
            return chosen;
        }
        if (receiver == ClassHelper.GSTRING_TYPE) {
            return this.findMethod(ClassHelper.STRING_TYPE, name, args);
        }
        return EMPTY_METHODNODE_LIST;
    }

    private List<MethodNode> findDGMMethodsByNameAndArguments(ClassNode receiver, String name, ClassNode[] args, List<MethodNode> methods) {
        methods.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode(receiver, name));
        List<MethodNode> chosen = this.chooseBestMethod(receiver, methods, args);
        return chosen;
    }

    private List<MethodNode> chooseBestMethod(ClassNode receiver, Collection<MethodNode> methods, ClassNode ... args) {
        if (methods.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<MethodNode> bestChoices = new LinkedList<MethodNode>();
        int bestDist = Integer.MAX_VALUE;
        for (MethodNode m : methods) {
            Parameter[] params = this.parameterizeArguments(receiver, m);
            if (params.length == args.length) {
                int dist;
                int lastArgMatch;
                int allPMatch = StaticTypeCheckingSupport.allParametersAndArgumentsMatch(params, args);
                int n = lastArgMatch = StaticTypeCheckingSupport.isVargs(params) ? StaticTypeCheckingSupport.lastArgMatchesVarg(params, args) : -1;
                if (lastArgMatch >= 0) {
                    ++lastArgMatch;
                }
                int n2 = dist = allPMatch >= 0 ? Math.max(allPMatch, lastArgMatch) : lastArgMatch;
                if (dist >= 0 && !receiver.equals(m.getDeclaringClass())) {
                    dist += StaticTypeCheckingSupport.getDistance(receiver, m.getDeclaringClass());
                }
                if (dist >= 0 && dist < bestDist) {
                    bestChoices.clear();
                    bestChoices.add(m);
                    bestDist = dist;
                    continue;
                }
                if (dist < 0 || dist != bestDist) continue;
                bestChoices.add(m);
                continue;
            }
            if (!StaticTypeCheckingSupport.isVargs(params)) continue;
            boolean firstParamMatches = true;
            if (args.length > 0) {
                Parameter[] firstParams = new Parameter[params.length - 1];
                System.arraycopy(params, 0, firstParams, 0, firstParams.length);
                boolean bl = firstParamMatches = StaticTypeCheckingSupport.allParametersAndArgumentsMatch(firstParams, args) >= 0;
            }
            if (!firstParamMatches) continue;
            if (params.length == args.length + 1) {
                if (bestDist <= 1) continue;
                bestChoices.clear();
                bestChoices.add(m);
                bestDist = 1;
                continue;
            }
            int dist = StaticTypeCheckingSupport.excessArgumentsMatchesVargsParameter(params, args);
            if (dist >= 0 && !receiver.equals(m.getDeclaringClass())) {
                ++dist;
            }
            if (params.length >= args.length || ++dist < 0) continue;
            if (dist >= 0 && dist < bestDist) {
                bestChoices.clear();
                bestChoices.add(m);
                bestDist = dist;
                continue;
            }
            if (dist < 0 || dist != bestDist) continue;
            bestChoices.add(m);
        }
        return bestChoices;
    }

    private Parameter[] parameterizeArguments(ClassNode receiver, MethodNode m) {
        GenericsType[] redirectReceiverTypes = receiver.redirect().getGenericsTypes();
        if (redirectReceiverTypes == null) {
            redirectReceiverTypes = m.getGenericsTypes();
        }
        if (redirectReceiverTypes == null) {
            return m.getParameters();
        }
        Parameter[] methodParameters = m.getParameters();
        Parameter[] params = new Parameter[methodParameters.length];
        GenericsType[] receiverParameterizedTypes = receiver.getGenericsTypes();
        if (receiverParameterizedTypes == null) {
            receiverParameterizedTypes = redirectReceiverTypes;
        }
        for (int i = 0; i < methodParameters.length; ++i) {
            Parameter methodParameter = methodParameters[i];
            ClassNode paramType = methodParameter.getType();
            if (paramType.isUsingGenerics()) {
                GenericsType[] alignmentTypes = paramType.getGenericsTypes();
                GenericsType[] genericsTypes = GenericsUtils.alignGenericTypes(redirectReceiverTypes, receiverParameterizedTypes, alignmentTypes);
                if (genericsTypes.length == 1) {
                    ClassNode parameterizedCN;
                    if (paramType.equals(ClassHelper.OBJECT_TYPE)) {
                        parameterizedCN = genericsTypes[0].getType();
                    } else {
                        parameterizedCN = paramType.getPlainNodeReference();
                        parameterizedCN.setGenericsTypes(genericsTypes);
                    }
                    params[i] = new Parameter(parameterizedCN, methodParameter.getName());
                    continue;
                }
                params[i] = methodParameter;
                continue;
            }
            params[i] = methodParameter;
        }
        return params;
    }

    private ClassNode getType(ASTNode exp) {
        ClassNode irt;
        ClassNode cn = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
        if (cn != null) {
            return cn;
        }
        if (exp instanceof VariableExpression) {
            Parameter parameter;
            ClassNode type;
            VariableExpression vexp = (VariableExpression)exp;
            if (vexp == VariableExpression.THIS_EXPRESSION) {
                return this.classNode;
            }
            if (vexp == VariableExpression.SUPER_EXPRESSION) {
                return this.classNode.getSuperClass();
            }
            Variable variable = vexp.getAccessedVariable();
            if (variable != null && variable != vexp && variable instanceof VariableExpression) {
                return this.getType((Expression)((Object)variable));
            }
            if (variable instanceof Parameter && (type = this.forLoopVariableTypes.get(parameter = (Parameter)variable)) != null) {
                return type;
            }
        } else if (exp instanceof PropertyExpression) {
            PropertyExpression pexp = (PropertyExpression)exp;
            ClassNode objectExpType = this.getType(pexp.getObjectExpression());
            if ((ClassHelper.LIST_TYPE.equals(objectExpType) || objectExpType.implementsInterface(ClassHelper.LIST_TYPE)) && pexp.isSpreadSafe()) {
                return ClassHelper.LIST_TYPE;
            }
            if ((objectExpType.equals(ClassHelper.MAP_TYPE) || objectExpType.implementsInterface(ClassHelper.MAP_TYPE)) && pexp.isSpreadSafe()) {
                String propertyName = pexp.getPropertyAsString();
                GenericsType[] types = objectExpType.getGenericsTypes();
                if ("key".equals(propertyName)) {
                    if (types.length == 2) {
                        ClassNode listKey = new ClassNode(List.class);
                        listKey.setGenericsTypes(new GenericsType[]{types[0]});
                        return listKey;
                    }
                } else if ("value".equals(propertyName)) {
                    if (types.length == 2) {
                        ClassNode listValue = new ClassNode(List.class);
                        listValue.setGenericsTypes(new GenericsType[]{types[1]});
                        return listValue;
                    }
                } else {
                    this.addStaticTypeError("Spread operator on map only allows one of [key,value]", pexp);
                }
                return ClassHelper.LIST_TYPE;
            }
            if (objectExpType.isEnum()) {
                return objectExpType;
            }
            AtomicReference<ClassNode> result = new AtomicReference<ClassNode>(ClassHelper.VOID_TYPE);
            this.existsProperty(pexp, false, new PropertyLookupVisitor(result));
            return result.get();
        }
        if (exp instanceof ListExpression) {
            return this.inferListExpressionType((ListExpression)exp);
        }
        if (exp instanceof MapExpression) {
            return this.inferMapExpressionType((MapExpression)exp);
        }
        if (exp instanceof MethodNode) {
            ClassNode ret = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
            return ret != null ? ret : ((MethodNode)exp).getReturnType();
        }
        if (exp instanceof ClosureExpression && (irt = (ClassNode)exp.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) != null) {
            irt = StaticTypeCheckingVisitor.wrapTypeIfNecessary(irt);
            ClassNode result = ClassHelper.CLOSURE_TYPE.getPlainNodeReference();
            result.setGenericsTypes(new GenericsType[]{new GenericsType(irt)});
            return result;
        }
        if (exp instanceof RangeExpression) {
            ClassNode toType;
            ClassNode plain = ClassHelper.RANGE_TYPE.getPlainNodeReference();
            RangeExpression re = (RangeExpression)exp;
            ClassNode fromType = this.getType(re.getFrom());
            if (fromType.equals(toType = this.getType(re.getTo()))) {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(fromType))});
            } else {
                plain.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(WideningCategories.lowestUpperBound(fromType, toType)))});
            }
            return plain;
        }
        return exp instanceof VariableExpression ? ((VariableExpression)exp).getOriginType() : ((Expression)exp).getType();
    }

    private ClassNode inferListExpressionType(ListExpression list) {
        List<Expression> expressions = list.getExpressions();
        if (expressions.isEmpty()) {
            return list.getType();
        }
        ClassNode listType = list.getType();
        GenericsType[] genericsTypes = listType.getGenericsTypes();
        if ((genericsTypes == null || genericsTypes.length == 0 || genericsTypes.length == 1 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType())) && !expressions.isEmpty()) {
            LinkedList<ClassNode> nodes = new LinkedList<ClassNode>();
            for (Expression expression : expressions) {
                nodes.add(this.getType(expression));
            }
            ClassNode superType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(nodes));
            ClassNode inferred = listType.getPlainNodeReference();
            inferred.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(superType))});
            return inferred;
        }
        return listType;
    }

    private ClassNode inferMapExpressionType(MapExpression map) {
        ClassNode mapType = map.getType();
        List<MapEntryExpression> entryExpressions = map.getMapEntryExpressions();
        if (entryExpressions.isEmpty()) {
            return mapType;
        }
        GenericsType[] genericsTypes = mapType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length < 2 || genericsTypes.length == 2 && ClassHelper.OBJECT_TYPE.equals(genericsTypes[0].getType()) && ClassHelper.OBJECT_TYPE.equals(genericsTypes[1].getType())) {
            LinkedList<ClassNode> keyTypes = new LinkedList<ClassNode>();
            LinkedList<ClassNode> valueTypes = new LinkedList<ClassNode>();
            for (MapEntryExpression entryExpression : entryExpressions) {
                keyTypes.add(this.getType(entryExpression.getKeyExpression()));
                valueTypes.add(this.getType(entryExpression.getValueExpression()));
            }
            ClassNode keyType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(keyTypes));
            ClassNode valueType = ClassHelper.getWrapper(WideningCategories.lowestUpperBound(valueTypes));
            if (!ClassHelper.OBJECT_TYPE.equals(keyType) || !ClassHelper.OBJECT_TYPE.equals(valueType)) {
                ClassNode inferred = mapType.getPlainNodeReference();
                inferred.setGenericsTypes(new GenericsType[]{new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(keyType)), new GenericsType(StaticTypeCheckingVisitor.wrapTypeIfNecessary(valueType))});
                return inferred;
            }
        }
        return mapType;
    }

    private ClassNode inferReturnTypeGenerics(ClassNode receiver, MethodNode method, Expression arguments) {
        ClassNode returnType = method.getReturnType();
        if (!returnType.isUsingGenerics()) {
            return returnType;
        }
        GenericsType[] returnTypeGenerics = returnType.getGenericsTypes();
        LinkedList<GenericsType> placeholders = new LinkedList<GenericsType>();
        for (GenericsType returnTypeGeneric : returnTypeGenerics) {
            if (!returnTypeGeneric.isPlaceholder() && !returnTypeGeneric.isWildcard()) continue;
            placeholders.add(returnTypeGeneric);
        }
        if (placeholders.isEmpty()) {
            return returnType;
        }
        HashMap<String, GenericsType> resolvedPlaceholders = new HashMap<String, GenericsType>();
        GenericsUtils.extractPlaceholders(receiver, resolvedPlaceholders);
        GenericsUtils.extractPlaceholders(method.getReturnType(), resolvedPlaceholders);
        Parameter[] parameters = method.getParameters();
        boolean isVargs = StaticTypeCheckingSupport.isVargs(parameters);
        ArgumentListExpression argList = InvocationWriter.makeArgumentList(arguments);
        List<Expression> expressions = argList.getExpressions();
        int paramLength = parameters.length;
        for (int i = 0; i < paramLength; ++i) {
            boolean lastArg = i == paramLength - 1;
            ClassNode type = parameters[i].getType();
            if (!type.isUsingGenerics() && type.isArray()) {
                type = type.getComponentType();
            }
            if (!type.isUsingGenerics()) continue;
            ClassNode actualType = this.getType(expressions.get(i));
            if (isVargs && lastArg && actualType.isArray()) {
                actualType = actualType.getComponentType();
            }
            actualType = StaticTypeCheckingVisitor.wrapTypeIfNecessary(actualType);
            Map<String, GenericsType> typePlaceholders = GenericsUtils.extractPlaceholders(type.isArray() ? type.getComponentType() : type);
            if (ClassHelper.OBJECT_TYPE.equals(type)) {
                for (String key : typePlaceholders.keySet()) {
                    resolvedPlaceholders.put(key, new GenericsType(actualType));
                }
                continue;
            }
            while (!actualType.equals(type)) {
                Set<ClassNode> interfaces = actualType.getAllInterfaces();
                boolean intf = false;
                for (ClassNode anInterface : interfaces) {
                    if (!anInterface.equals(type)) continue;
                    intf = true;
                    actualType = GenericsUtils.parameterizeInterfaceGenerics(actualType, anInterface);
                }
                if (intf) continue;
                actualType = actualType.getUnresolvedSuperClass();
            }
            Map<String, GenericsType> actualTypePlaceholders = GenericsUtils.extractPlaceholders(actualType);
            for (Map.Entry<String, GenericsType> typeEntry : actualTypePlaceholders.entrySet()) {
                String key = typeEntry.getKey();
                GenericsType value = typeEntry.getValue();
                GenericsType alias = typePlaceholders.get(key);
                if (alias == null || !alias.isPlaceholder()) continue;
                resolvedPlaceholders.put(alias.getName(), value);
            }
        }
        GenericsType[] copy = new GenericsType[returnTypeGenerics.length];
        for (int i = 0; i < copy.length; ++i) {
            GenericsType returnTypeGeneric = returnTypeGenerics[i];
            if (returnTypeGeneric.isPlaceholder() || returnTypeGeneric.isWildcard()) {
                GenericsType resolved = (GenericsType)resolvedPlaceholders.get(returnTypeGeneric.getName());
                if (resolved == null) {
                    resolved = returnTypeGeneric;
                }
                copy[i] = resolved;
                continue;
            }
            copy[i] = returnTypeGeneric;
        }
        if (returnType.equals(ClassHelper.OBJECT_TYPE)) {
            return copy[0].getType();
        }
        returnType = returnType.getPlainNodeReference();
        returnType.setGenericsTypes(copy);
        return returnType;
    }

    private void typeCheckMethodsWithGenerics(ClassNode receiver, ClassNode[] arguments, List<MethodNode> candidateMethods, Expression location) {
        if (!receiver.isUsingGenerics()) {
            return;
        }
        int failure = 0;
        GenericsType[] methodGenericTypes = null;
        for (MethodNode method : candidateMethods) {
            ClassNode methodNodeReceiver = method.getDeclaringClass();
            if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(receiver, methodNodeReceiver) || !methodNodeReceiver.isUsingGenerics()) continue;
            Parameter[] parameters = method.getParameters();
            int argNum = 0;
            for (Parameter parameter : parameters) {
                ClassNode type = parameter.getType();
                if (type.isUsingGenerics()) {
                    methodGenericTypes = GenericsUtils.alignGenericTypes(receiver.redirect().getGenericsTypes(), receiver.getGenericsTypes(), type.getGenericsTypes());
                    if (methodGenericTypes.length == 1) {
                        ClassNode nodeType = ClassHelper.getWrapper(methodGenericTypes[0].getType());
                        ClassNode actualType = ClassHelper.getWrapper(arguments[argNum]);
                        if (!actualType.isDerivedFrom(nodeType)) {
                            ++failure;
                        }
                    }
                } else if (type.isArray() && type.getComponentType().isUsingGenerics()) {
                    ClassNode componentType = type.getComponentType();
                    methodGenericTypes = GenericsUtils.alignGenericTypes(receiver.redirect().getGenericsTypes(), receiver.getGenericsTypes(), componentType.getGenericsTypes());
                    if (methodGenericTypes.length == 1) {
                        ClassNode nodeType = ClassHelper.getWrapper(methodGenericTypes[0].getType());
                        ClassNode actualType = ClassHelper.getWrapper(arguments[argNum].getComponentType());
                        if (!actualType.equals(nodeType)) {
                            ++failure;
                            methodGenericTypes[0].setType(methodGenericTypes[0].getType().makeArray());
                        }
                    }
                }
                ++argNum;
            }
        }
        if (failure == candidateMethods.size()) {
            if (failure == 1) {
                MethodNode method = candidateMethods.get(0);
                ClassNode[] parameterTypes = new ClassNode[methodGenericTypes.length];
                for (int i = 0; i < methodGenericTypes.length; ++i) {
                    parameterTypes[i] = methodGenericTypes[i].getType();
                }
                this.addStaticTypeError("Cannot call " + receiver.getName() + "#" + StaticTypeCheckingSupport.toMethodParametersString(method.getName(), parameterTypes) + " with arguments " + Arrays.asList(arguments), location);
            } else {
                this.addStaticTypeError("No matching method found for arguments " + Arrays.asList(arguments), location);
            }
        }
    }

    protected void addStaticTypeError(String msg, ASTNode expr) {
        if (expr.getColumnNumber() > 0 && expr.getLineNumber() > 0) {
            this.addError("[Static type checking] - " + msg, expr);
        }
    }

    public void setMethodsToBeVisited(Set<MethodNode> methodsToBeVisited) {
        this.methodsToBeVisited = methodsToBeVisited;
    }

    public void performSecondPass() {
        for (Expression expression : this.secondPassExpressions) {
            VariableExpression var;
            List<ClassNode> classNodes;
            Variable target;
            MethodCallExpression call;
            Expression objectExpression;
            if (!(expression instanceof MethodCallExpression) || !((objectExpression = (call = (MethodCallExpression)expression).getObjectExpression()) instanceof VariableExpression) || !((target = StaticTypeCheckingSupport.findTargetVariable((VariableExpression)objectExpression)) instanceof VariableExpression) || (classNodes = this.closureSharedVariablesAssignmentTypes.get(var = (VariableExpression)target)) == null || classNodes.size() <= 1) continue;
            ClassNode lub = WideningCategories.lowestUpperBound(classNodes);
            MethodNode methodNode = (MethodNode)call.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            Parameter[] parameters = methodNode.getParameters();
            ClassNode[] params = new ClassNode[parameters.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = parameters[i].getType();
            }
            List<MethodNode> method = this.findMethod(lub, methodNode.getName(), params);
            if (method.size() == 1) continue;
            this.addStaticTypeError("A closure shared variable [" + target.getName() + "] has been assigned with various types and the method" + " [" + StaticTypeCheckingSupport.toMethodParametersString(methodNode.getName(), params) + "]" + " does not exist in the lowest upper bound of those types: [" + lub.toString(false) + "]. In general, this is a bad practice (variable reuse) because the compiler cannot" + " determine safely what is the type of the variable at the moment of the call in a multithreaded context.", call);
        }
    }

    private static ClassNode wrapTypeIfNecessary(ClassNode type) {
        if (ClassHelper.isPrimitiveType(type)) {
            return ClassHelper.getWrapper(type);
        }
        return type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyLookupVisitor
    extends ClassCodeVisitorSupport {
        private final AtomicReference<ClassNode> result;

        public PropertyLookupVisitor(AtomicReference<ClassNode> result) {
            this.result = result;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return null;
        }

        @Override
        public void visitMethod(MethodNode node) {
            this.result.set(node.getReturnType());
        }

        @Override
        public void visitProperty(PropertyNode node) {
            this.result.set(node.getType());
        }

        @Override
        public void visitField(FieldNode field) {
            this.result.set(field.getType());
        }
    }
}

