/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.stc.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class StaticTypeCheckingSupport {
    static final Map<String, List<MethodNode>> VIRTUAL_DGM_METHODS = StaticTypeCheckingSupport.getDGMMethods();
    static final ClassNode Collection_TYPE = ClassHelper.makeWithoutCaching(Collection.class);
    static final ClassNode Matcher_TYPE = ClassHelper.makeWithoutCaching(Matcher.class);
    static final ClassNode ArrayList_TYPE = ClassHelper.makeWithoutCaching(ArrayList.class);
    static final Map<ClassNode, Integer> NUMBER_TYPES = Collections.unmodifiableMap(new HashMap<ClassNode, Integer>(){
        {
            this.put(ClassHelper.byte_TYPE, 0);
            this.put(ClassHelper.Byte_TYPE, 0);
            this.put(ClassHelper.short_TYPE, 1);
            this.put(ClassHelper.Short_TYPE, 1);
            this.put(ClassHelper.int_TYPE, 2);
            this.put(ClassHelper.Integer_TYPE, 2);
            this.put(ClassHelper.Long_TYPE, 3);
            this.put(ClassHelper.long_TYPE, 3);
            this.put(ClassHelper.float_TYPE, 4);
            this.put(ClassHelper.Float_TYPE, 4);
            this.put(ClassHelper.double_TYPE, 5);
            this.put(ClassHelper.Double_TYPE, 5);
        }
    });

    StaticTypeCheckingSupport() {
    }

    static boolean isArrayAccessExpression(Expression expression) {
        return expression instanceof BinaryExpression && StaticTypeCheckingSupport.isArrayOp(((BinaryExpression)expression).getOperation().getType());
    }

    static boolean isWithCall(String name, Expression callArguments) {
        boolean isWithCall;
        boolean bl = isWithCall = "with".equals(name) && callArguments instanceof ArgumentListExpression;
        if (isWithCall) {
            ArgumentListExpression argList = (ArgumentListExpression)callArguments;
            List<Expression> expressions = argList.getExpressions();
            isWithCall = expressions.size() == 1 && expressions.get(0) instanceof ClosureExpression;
        }
        return isWithCall;
    }

    static Variable findTargetVariable(VariableExpression ve) {
        Variable accessedVariable = ve.getAccessedVariable();
        if (accessedVariable != ve && accessedVariable instanceof VariableExpression) {
            return StaticTypeCheckingSupport.findTargetVariable((VariableExpression)accessedVariable);
        }
        return accessedVariable;
    }

    private static Map<String, List<MethodNode>> getDGMMethods() {
        HashMap<String, List<MethodNode>> methods = new HashMap<String, List<MethodNode>>();
        ClassNode cn = ClassHelper.makeWithoutCaching(DefaultGroovyMethods.class, true);
        for (MethodNode metaMethod : cn.getMethods()) {
            Parameter[] types = metaMethod.getParameters();
            if (!metaMethod.isStatic() || !metaMethod.isPublic() || types.length <= 0) continue;
            Parameter[] parameters = new Parameter[types.length - 1];
            System.arraycopy(types, 1, parameters, 0, parameters.length);
            MethodNode node = new MethodNode(metaMethod.getName(), metaMethod.getModifiers(), metaMethod.getReturnType(), parameters, ClassNode.EMPTY_ARRAY, null);
            node.setGenericsTypes(metaMethod.getGenericsTypes());
            ClassNode declaringClass = types[0].getType();
            String declaringClassName = declaringClass.getName();
            node.setDeclaringClass(declaringClass);
            LinkedList<MethodNode> nodes = (LinkedList<MethodNode>)methods.get(declaringClassName);
            if (nodes == null) {
                nodes = new LinkedList<MethodNode>();
                methods.put(declaringClassName, nodes);
            }
            nodes.add(node);
        }
        return methods;
    }

    static Set<MethodNode> findDGMMethodsForClassNode(ClassNode clazz) {
        HashSet<MethodNode> result = new HashSet<MethodNode>();
        List<MethodNode> fromDGM = VIRTUAL_DGM_METHODS.get(clazz.getName());
        if (fromDGM != null) {
            result.addAll(fromDGM);
        }
        for (ClassNode node : clazz.getInterfaces()) {
            result.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode(node));
        }
        if (clazz.getSuperClass() != null) {
            result.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode(clazz.getSuperClass()));
        } else if (!clazz.equals(ClassHelper.OBJECT_TYPE)) {
            result.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode(ClassHelper.OBJECT_TYPE));
        }
        return result;
    }

    static int allParametersAndArgumentsMatch(Parameter[] params, ClassNode[] args) {
        if (params == null) {
            return args.length == 0 ? 0 : -1;
        }
        int dist = 0;
        for (int i = 0; i < params.length; ++i) {
            if (!StaticTypeCheckingSupport.isAssignableTo(args[i], params[i].getType())) {
                return -1;
            }
            if (params[i].getType().equals(args[i])) continue;
            ++dist;
        }
        return dist;
    }

    static int excessArgumentsMatchesVargsParameter(Parameter[] params, ClassNode[] args) {
        int dist = 0;
        ClassNode vargsBase = params[params.length - 1].getType().getComponentType();
        for (int i = params.length; i < args.length; ++i) {
            if (!StaticTypeCheckingSupport.isAssignableTo(args[i], vargsBase)) {
                return -1;
            }
            if (args[i].equals(vargsBase)) continue;
            ++dist;
        }
        return dist;
    }

    static int lastArgMatchesVarg(Parameter[] params, ClassNode ... args) {
        if (!StaticTypeCheckingSupport.isVargs(params)) {
            return -1;
        }
        ClassNode ptype = params[params.length - 1].getType().getComponentType();
        ClassNode arg = args[args.length - 1];
        if (ClassHelper.isNumberType(ptype) && ClassHelper.isNumberType(arg) && !ptype.equals(arg)) {
            return -1;
        }
        return StaticTypeCheckingSupport.isAssignableTo(arg, ptype) ? (ptype.equals(arg) ? 0 : 1) : -1;
    }

    static boolean isAssignableTo(ClassNode type, ClassNode toBeAssignedTo) {
        if (toBeAssignedTo.redirect() == ClassHelper.STRING_TYPE && type.redirect() == ClassHelper.GSTRING_TYPE) {
            return true;
        }
        if (ClassHelper.isPrimitiveType(toBeAssignedTo)) {
            toBeAssignedTo = ClassHelper.getWrapper(toBeAssignedTo);
        }
        if (ClassHelper.isPrimitiveType(type)) {
            type = ClassHelper.getWrapper(type);
        }
        if (type.isArray() && toBeAssignedTo.isArray()) {
            return type.getComponentType().equals(toBeAssignedTo.getComponentType());
        }
        if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, toBeAssignedTo)) {
            if (ClassHelper.OBJECT_TYPE.equals(toBeAssignedTo)) {
                return true;
            }
            if (toBeAssignedTo.isUsingGenerics()) {
                GenericsType gt = GenericsUtils.buildWildcardType(toBeAssignedTo);
                return gt.isCompatibleWith(type);
            }
            return true;
        }
        return false;
    }

    static boolean isVargs(Parameter[] params) {
        if (params.length == 0) {
            return false;
        }
        return params[params.length - 1].getType().isArray();
    }

    static boolean isCompareToBoolean(int op) {
        return op == 126 || op == 127 || op == 124 || op == 125;
    }

    static boolean isArrayOp(int op) {
        return op == 30;
    }

    static boolean isBoolIntrinsicOp(int op) {
        return op == 164 || op == 162 || op == 94 || op == 544;
    }

    static boolean isPowerOperator(int op) {
        return op == 206 || op == 216;
    }

    static String getOperationName(int op) {
        switch (op) {
            case 120: 
            case 123: {
                return "equals";
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                return "compareTo";
            }
            case 341: 
            case 351: {
                return "and";
            }
            case 340: 
            case 350: {
                return "or";
            }
            case 342: 
            case 352: {
                return "xor";
            }
            case 200: 
            case 210: {
                return "plus";
            }
            case 201: 
            case 211: {
                return "minus";
            }
            case 202: 
            case 212: {
                return "multiply";
            }
            case 203: 
            case 213: {
                return "div";
            }
            case 204: 
            case 214: {
                return "intdiv";
            }
            case 205: 
            case 215: {
                return "mod";
            }
            case 206: 
            case 216: {
                return "power";
            }
            case 280: 
            case 285: {
                return "leftShift";
            }
            case 281: 
            case 286: {
                return "rightShift";
            }
            case 282: 
            case 287: {
                return "rightShiftUnsigned";
            }
            case 573: {
                return "isCase";
            }
        }
        return null;
    }

    static boolean isShiftOperation(String name) {
        return "leftShift".equals(name) || "rightShift".equals(name) || "rightShiftUnsigned".equals(name);
    }

    static boolean isOperationInGroup(int op) {
        switch (op) {
            case 200: 
            case 201: 
            case 202: 
            case 210: 
            case 211: 
            case 212: {
                return true;
            }
        }
        return false;
    }

    static boolean isBitOperator(int op) {
        switch (op) {
            case 340: 
            case 341: 
            case 342: 
            case 350: 
            case 351: 
            case 352: {
                return true;
            }
        }
        return false;
    }

    static boolean isAssignment(int op) {
        switch (op) {
            case 100: 
            case 166: 
            case 168: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 285: 
            case 286: 
            case 287: 
            case 350: 
            case 351: 
            case 352: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkCompatibleAssignmentTypes(ClassNode left, ClassNode right) {
        ClassNode leftRedirect = left.redirect();
        ClassNode rightRedirect = right.redirect();
        if (leftRedirect == ClassHelper.OBJECT_TYPE || leftRedirect == ClassHelper.STRING_TYPE || leftRedirect == ClassHelper.boolean_TYPE || leftRedirect == ClassHelper.Boolean_TYPE || leftRedirect == ClassHelper.CLASS_Type) {
            return true;
        }
        if (leftRedirect.isDerivedFrom(ClassHelper.Enum_Type) && (rightRedirect == ClassHelper.GSTRING_TYPE || rightRedirect == ClassHelper.STRING_TYPE)) {
            return true;
        }
        if (rightRedirect.implementsInterface(ClassHelper.MAP_TYPE) || rightRedirect.implementsInterface(Collection_TYPE) || rightRedirect.equals(ClassHelper.MAP_TYPE) || rightRedirect.equals(Collection_TYPE) || rightRedirect.isArray()) {
            if (leftRedirect.isArray() && rightRedirect.isArray()) {
                return StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftRedirect.getComponentType(), rightRedirect.getComponentType());
            }
            return true;
        }
        if (right.isDerivedFrom(left) || left.implementsInterface(right)) {
            return true;
        }
        if (ClassHelper.isPrimitiveType(leftRedirect) && ClassHelper.isPrimitiveType(rightRedirect)) {
            return true;
        }
        return ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect);
    }

    static boolean checkPossibleLooseOfPrecision(ClassNode left, ClassNode right, Expression rightExpr) {
        int rightIndex;
        if (left == right || left.equals(right)) {
            return false;
        }
        int leftIndex = NUMBER_TYPES.get(left);
        if (leftIndex >= (rightIndex = NUMBER_TYPES.get(right).intValue())) {
            return false;
        }
        if (rightExpr instanceof ConstantExpression) {
            Object value = ((ConstantExpression)rightExpr).getValue();
            if (!(value instanceof Number)) {
                return true;
            }
            Number number = (Number)value;
            switch (leftIndex) {
                case 0: {
                    byte val = number.byteValue();
                    if (number instanceof Short) {
                        return !Short.valueOf(val).equals(number);
                    }
                    if (number instanceof Integer) {
                        return !Integer.valueOf(val).equals(number);
                    }
                    if (number instanceof Long) {
                        return !Long.valueOf(val).equals(number);
                    }
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 1: {
                    short val = number.shortValue();
                    if (number instanceof Integer) {
                        return !Integer.valueOf(val).equals(number);
                    }
                    if (number instanceof Long) {
                        return !Long.valueOf(val).equals(number);
                    }
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 2: {
                    int val = number.intValue();
                    if (number instanceof Long) {
                        return !Long.valueOf(val).equals(number);
                    }
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 3: {
                    long val = number.longValue();
                    if (number instanceof Float) {
                        return !Float.valueOf(val).equals(number);
                    }
                    return !Double.valueOf(val).equals(number);
                }
                case 4: {
                    float val = number.floatValue();
                    return !Double.valueOf(val).equals(number);
                }
            }
            return false;
        }
        return true;
    }

    static String toMethodParametersString(String methodName, ClassNode ... parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName).append("(");
        if (parameters != null) {
            int parametersLength = parameters.length;
            for (int i = 0; i < parametersLength; ++i) {
                ClassNode parameter = parameters[i];
                sb.append(parameter.toString(false));
                if (i >= parametersLength - 1) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    static boolean implementsInterfaceOrIsSubclassOf(ClassNode type, ClassNode superOrInterface) {
        return type.equals(superOrInterface) || type.isDerivedFrom(superOrInterface) || type.implementsInterface(superOrInterface);
    }
}

