/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import java.util.Collections;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class StaticTypesTransformation
implements ASTTransformation {
    public static final String STATIC_ERROR_PREFIX = "[Static type checking] - ";

    public void visit(ASTNode[] nodes, SourceUnit source) {
        AnnotatedNode node = (AnnotatedNode)nodes[1];
        if (node instanceof ClassNode) {
            ClassNode classNode = (ClassNode)node;
            StaticTypeCheckingVisitor visitor = this.newVisitor(source, classNode);
            visitor.visitClass(classNode);
        } else if (node instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)node;
            StaticTypeCheckingVisitor visitor = this.newVisitor(source, methodNode.getDeclaringClass());
            visitor.setMethodsToBeVisited(Collections.singleton(methodNode));
            visitor.visitMethod(methodNode);
        } else {
            source.addError(new SyntaxException("[Static type checking] - Unimplemented node type", node.getLineNumber(), node.getColumnNumber()));
        }
    }

    protected StaticTypeCheckingVisitor newVisitor(SourceUnit unit, ClassNode node) {
        return new StaticTypeCheckingVisitor(unit, node);
    }
}

