/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsType
extends ASTNode {
    private final ClassNode[] upperBounds;
    private final ClassNode lowerBound;
    private ClassNode type;
    private String name;
    private boolean placeholder;
    private boolean resolved;
    private boolean wildcard;

    public GenericsType(ClassNode type, ClassNode[] upperBounds, ClassNode lowerBound) {
        this.type = type;
        this.name = type.isGenericsPlaceHolder() ? type.getUnresolvedName() : type.getName();
        this.upperBounds = upperBounds;
        this.lowerBound = lowerBound;
        this.placeholder = type.isGenericsPlaceHolder();
        this.resolved = false;
    }

    public GenericsType(ClassNode basicType) {
        this(basicType, null, null);
    }

    public ClassNode getType() {
        return this.type;
    }

    public void setType(ClassNode type) {
        this.type = type;
    }

    public String toString() {
        HashSet<Integer> visited = new HashSet<Integer>();
        return this.toString(visited);
    }

    private String toString(Set<Integer> visited) {
        String ret;
        String string = ret = this.type == null || this.placeholder || this.wildcard ? this.name : this.genericsBounds(this.type, visited);
        if (this.upperBounds != null) {
            ret = ret + " extends ";
            for (int i = 0; i < this.upperBounds.length; ++i) {
                ret = ret + this.genericsBounds(this.upperBounds[i], visited);
                if (i + 1 >= this.upperBounds.length) continue;
                ret = ret + " & ";
            }
        } else if (this.lowerBound != null) {
            ret = ret + " super " + this.genericsBounds(this.lowerBound, visited);
        }
        return ret;
    }

    private String genericsBounds(ClassNode theType, Set<Integer> visited) {
        if (visited.contains(System.identityHashCode(theType))) {
            return "...";
        }
        visited.add(System.identityHashCode(theType));
        String ret = theType.getName();
        GenericsType[] genericsTypes = theType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length == 0) {
            return ret;
        }
        ret = ret + "<";
        for (int i = 0; i < genericsTypes.length; ++i) {
            if (i != 0) {
                ret = ret + ", ";
            }
            ret = ret + genericsTypes[i].toString(visited);
        }
        ret = ret + ">";
        return ret;
    }

    public ClassNode[] getUpperBounds() {
        return this.upperBounds;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
        this.type.setGenericsPlaceHolder(placeholder);
    }

    public boolean isResolved() {
        return this.resolved || this.placeholder;
    }

    public void setResolved(boolean res) {
        this.resolved = res;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public ClassNode getLowerBound() {
        return this.lowerBound;
    }

    public boolean isCompatibleWith(ClassNode classNode) {
        return new GenericsTypeMatcher().matches(classNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GenericsTypeMatcher {
        private GenericsTypeMatcher() {
        }

        public boolean matches(ClassNode classNode) {
            if (classNode.isGenericsPlaceHolder()) {
                GenericsType[] genericsTypes = classNode.getGenericsTypes();
                return genericsTypes == null || genericsTypes[0].getName().equals(GenericsType.this.name);
            }
            if (GenericsType.this.wildcard || GenericsType.this.placeholder) {
                if (GenericsType.this.upperBounds != null) {
                    boolean upIsOk = true;
                    int upperBoundsLength = GenericsType.this.upperBounds.length;
                    for (int i = 0; i < upperBoundsLength && upIsOk; ++i) {
                        ClassNode upperBound = GenericsType.this.upperBounds[i];
                        upIsOk = classNode.isDerivedFrom(upperBound) || upperBound.isInterface() && classNode.implementsInterface(upperBound);
                    }
                    upIsOk = upIsOk && this.checkGenerics(classNode);
                    return upIsOk;
                }
                if (GenericsType.this.lowerBound != null) {
                    return (GenericsType.this.lowerBound.isDerivedFrom(classNode) || classNode.isInterface() && GenericsType.this.lowerBound.implementsInterface(GenericsType.this.lowerBound)) && this.checkGenerics(classNode);
                }
            }
            if (GenericsType.this.type != null && !GenericsType.this.type.equals(classNode)) {
                return false;
            }
            return GenericsType.this.type == null || this.compareGenericsWithBound(classNode, GenericsType.this.type);
        }

        private boolean checkGenerics(ClassNode classNode) {
            if (GenericsType.this.upperBounds != null) {
                for (ClassNode upperBound : GenericsType.this.upperBounds) {
                    if (this.compareGenericsWithBound(classNode, upperBound)) continue;
                    return false;
                }
            }
            return GenericsType.this.lowerBound == null || GenericsType.this.lowerBound.redirect().isUsingGenerics() || this.compareGenericsWithBound(classNode, GenericsType.this.lowerBound);
        }

        private boolean compareGenericsWithBound(ClassNode classNode, ClassNode bound) {
            if (classNode == null) {
                return false;
            }
            if (!bound.isUsingGenerics()) {
                return true;
            }
            if (!classNode.equals(bound)) {
                if (bound.isInterface()) {
                    Set<ClassNode> interfaces = classNode.getAllInterfaces();
                    for (ClassNode anInterface : interfaces) {
                        if (!anInterface.equals(bound)) continue;
                        HashMap<String, ClassNode> parameters = new HashMap<String, ClassNode>();
                        this.collectParameter(classNode, parameters);
                        ClassNode node = ClassHelper.makeWithoutCaching(anInterface.getTypeClass(), false);
                        GenericsType[] interfaceGTs = anInterface.getGenericsTypes();
                        GenericsType[] types = new GenericsType[interfaceGTs.length];
                        for (int i = 0; i < interfaceGTs.length; ++i) {
                            String name;
                            GenericsType interfaceGT;
                            types[i] = interfaceGT = interfaceGTs[i];
                            if (!interfaceGT.isPlaceholder() || !parameters.containsKey(name = interfaceGT.getName())) continue;
                            types[i] = new GenericsType((ClassNode)parameters.get(name));
                        }
                        node.setGenericsTypes(types);
                        return this.compareGenericsWithBound(node, bound);
                    }
                }
                return this.compareGenericsWithBound(classNode.getUnresolvedSuperClass(), bound);
            }
            GenericsType[] cnTypes = classNode.getGenericsTypes();
            if (cnTypes == null && classNode.isRedirectNode()) {
                cnTypes = classNode.redirect().getGenericsTypes();
            }
            if (cnTypes == null) {
                return false;
            }
            GenericsType[] uBTypes = bound.getGenericsTypes();
            Map<String, ClassNode> resolvedPlaceholders = this.placeholderToParameterizedType();
            boolean match = true;
            for (int i = 0; i < uBTypes.length && match; ++i) {
                String name;
                GenericsType uBType = uBTypes[i];
                GenericsType cnType = cnTypes[i];
                if (cnType.isPlaceholder() && resolvedPlaceholders.containsKey(name = cnType.getName())) {
                    cnType = new GenericsType(resolvedPlaceholders.get(name));
                }
                match = uBType.isWildcard() || uBType.isPlaceholder() || cnType.isCompatibleWith(uBType.getType());
            }
            return match;
        }

        private Map<String, ClassNode> placeholderToParameterizedType() {
            HashMap<String, ClassNode> result = new HashMap<String, ClassNode>();
            this.collectParameter(GenericsType.this.type, result);
            if (GenericsType.this.upperBounds != null) {
                for (ClassNode upperBound : GenericsType.this.upperBounds) {
                    this.collectParameter(upperBound, result);
                }
            }
            if (GenericsType.this.lowerBound != null) {
                this.collectParameter(GenericsType.this.lowerBound, result);
            }
            return result;
        }

        private void collectParameter(ClassNode node, Map<String, ClassNode> map) {
            if (node == null) {
                return;
            }
            if (!node.isUsingGenerics() || !node.isRedirectNode()) {
                return;
            }
            GenericsType[] parameterized = node.getGenericsTypes();
            if (parameterized == null) {
                return;
            }
            GenericsType[] genericsTypes = node.redirect().getGenericsTypes();
            for (int i = 0; i < genericsTypes.length; ++i) {
                GenericsType genericsType = genericsTypes[i];
                if (!genericsType.isPlaceholder()) continue;
                String name = genericsType.getName();
                map.put(name, parameterized[i].getType());
            }
        }
    }
}

