/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.AutoExternalize;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.AbstractASTTransformUtil;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class AutoExternalizeASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = AutoExternalize.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode EXTERNALIZABLE_TYPE = ClassHelper.make(Externalizable.class);
    private static final ClassNode OBJECTOUTPUT_TYPE = ClassHelper.make(ObjectOutput.class);
    private static final ClassNode OBJECTINPUT_TYPE = ClassHelper.make(ObjectInput.class);
    private static final Token ASSIGN = Token.newSymbol(100, -1, -1);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            this.checkNotInterface(cNode, MY_TYPE_NAME);
            cNode.addInterface(EXTERNALIZABLE_TYPE);
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            List<String> excludes = this.tokenize((String)this.getMemberValue(anno, "excludes"));
            List<FieldNode> list = AbstractASTTransformUtil.getInstancePropertyFields(cNode);
            if (includeFields) {
                list.addAll(AbstractASTTransformUtil.getInstanceNonPropertyFields(cNode));
            }
            this.createWriteExternal(cNode, excludes, list);
            this.createReadExternal(cNode, excludes, list);
        }
    }

    private void createWriteExternal(ClassNode cNode, List<String> excludes, List<FieldNode> list) {
        BlockStatement body = new BlockStatement();
        VariableExpression out = new VariableExpression("out", OBJECTOUTPUT_TYPE);
        for (FieldNode fNode : list) {
            if (excludes.contains(fNode.getName()) || (fNode.getModifiers() & 0x80) != 0) continue;
            body.addStatement(new ExpressionStatement(new MethodCallExpression((Expression)out, "write" + this.suffixForField(fNode), (Expression)new VariableExpression(fNode))));
        }
        ClassNode[] exceptions = new ClassNode[]{ClassHelper.make(IOException.class)};
        cNode.addMethod("writeExternal", 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(OBJECTOUTPUT_TYPE, "out")}, exceptions, body);
    }

    private void createReadExternal(ClassNode cNode, List<String> excludes, List<FieldNode> list) {
        BlockStatement body = new BlockStatement();
        VariableExpression oin = new VariableExpression("oin", OBJECTINPUT_TYPE);
        for (FieldNode fNode : list) {
            if (excludes.contains(fNode.getName()) || (fNode.getModifiers() & 0x80) != 0) continue;
            MethodCallExpression readObject = new MethodCallExpression((Expression)oin, "read" + this.suffixForField(fNode), MethodCallExpression.NO_ARGUMENTS);
            body.addStatement(new ExpressionStatement(new BinaryExpression(new VariableExpression(fNode), ASSIGN, readObject)));
        }
        cNode.addMethod("readExternal", 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(OBJECTINPUT_TYPE, "oin")}, ClassNode.EMPTY_ARRAY, body);
    }

    private String suffixForField(FieldNode fNode) {
        if (fNode.getType() == ClassHelper.int_TYPE) {
            return "Int";
        }
        if (fNode.getType() == ClassHelper.boolean_TYPE) {
            return "Boolean";
        }
        if (fNode.getType() == ClassHelper.long_TYPE) {
            return "Long";
        }
        if (fNode.getType() == ClassHelper.short_TYPE) {
            return "Short";
        }
        if (fNode.getType() == ClassHelper.byte_TYPE) {
            return "Byte";
        }
        if (fNode.getType() == ClassHelper.float_TYPE) {
            return "Float";
        }
        if (fNode.getType() == ClassHelper.double_TYPE) {
            return "Double";
        }
        return "Object";
    }
}

