/*
 * Decompiled with CFR 0.152.
 */
package groovy.json;

import groovy.io.LineColumnReader;
import groovy.json.JsonException;
import groovy.json.JsonLexer;
import groovy.json.JsonToken;
import groovy.json.JsonTokenType;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonSlurper {
    Object parseText(String text) {
        return this.parse(new LineColumnReader(new StringReader(text)));
    }

    Object parse(Reader reader) {
        Object content;
        JsonLexer lexer = new JsonLexer(reader);
        JsonToken token = lexer.nextToken();
        if (token.getType() == JsonTokenType.OPEN_CURLY) {
            content = this.parseObject(lexer);
        } else if (token.getType() == JsonTokenType.OPEN_BRACKET) {
            content = this.parseArray(lexer);
        } else {
            throw new JsonException("A JSON payload should start with ${OPEN_CURLY.label} or ${OPEN_BRACKET.label}.\nInstead, '${token.text}' was found on line: ${token.startLine}, column: ${token.startColumn}");
        }
        return content;
    }

    private List parseArray(JsonLexer lexer) {
        ArrayList<Object> content;
        block10: {
            JsonToken currentToken;
            content = new ArrayList<Object>();
            do {
                if ((currentToken = lexer.nextToken()) == null) {
                    throw new JsonException("Expected a value on line: ${lexer.reader.line}, column: ${lexer.reader.column}.\nBut got an unterminated array.");
                }
                if (currentToken.getType() == JsonTokenType.OPEN_CURLY) {
                    content.add(this.parseObject(lexer));
                } else if (currentToken.getType() == JsonTokenType.OPEN_BRACKET) {
                    content.add(this.parseArray(lexer));
                } else if (currentToken.getType().ordinal() >= JsonTokenType.NULL.ordinal()) {
                    content.add(currentToken.getValue());
                } else {
                    if (currentToken.getType() == JsonTokenType.CLOSE_BRACKET) {
                        return content;
                    }
                    throw new JsonException("Expected a value, an array, or an object on line: ${currentToken.startLine}, column: ${currentToken.startColumn}.\nBut got '${currentToken.text}' instead.");
                }
                currentToken = lexer.nextToken();
                if (currentToken == null) {
                    throw new JsonException("Expected ${CLOSE_BRACKET.label} or ${COMMA.label} on line: ${lexer.reader.line}, column: ${lexer.reader.column}.\nBut got an unterminated array.");
                }
                if (currentToken.getType() == JsonTokenType.CLOSE_BRACKET) break block10;
            } while (currentToken.getType() == JsonTokenType.COMMA);
            throw new JsonException("Expected a value or ${CLOSE_BRACKET.label} on line: ${currentToken.startLine} column: ${currentToken.startColumn}.\nBut got '${currentToken.text}' instead.");
        }
        return content;
    }

    private Map parseObject(JsonLexer lexer) {
        HashMap<String, Object> content;
        block11: {
            content = new HashMap<String, Object>();
            JsonToken previousToken = null;
            JsonToken currentToken = null;
            do {
                previousToken = currentToken;
                currentToken = lexer.nextToken();
                if (currentToken.getType() == JsonTokenType.CLOSE_CURLY) {
                    return content;
                }
                if (currentToken.getType() != JsonTokenType.STRING) {
                    throw new JsonException("Expected " + JsonTokenType.STRING.getLabel() + " key on line: " + currentToken.getStartLine() + ", column: " + currentToken.getStartColumn() + ".\n" + "Bug got '${currentToken.text}' instead.");
                }
                String mapKey = (String)currentToken.getValue();
                previousToken = currentToken;
                currentToken = lexer.nextToken();
                if (currentToken.getType() != JsonTokenType.COLON) {
                    throw new JsonException("Expected " + JsonTokenType.COLON.getLabel() + " on line: " + currentToken.getStartLine() + ", column: " + currentToken.getStartColumn() + ".\n" + "Bug got '" + currentToken.getText() + "' instead.");
                }
                previousToken = currentToken;
                currentToken = lexer.nextToken();
                if (currentToken.getType() == JsonTokenType.OPEN_CURLY) {
                    content.put(mapKey, this.parseObject(lexer));
                } else if (currentToken.getType() == JsonTokenType.OPEN_BRACKET) {
                    content.put(mapKey, this.parseArray(lexer));
                } else if (currentToken.getType().ordinal() >= JsonTokenType.NULL.ordinal()) {
                    content.put(mapKey, currentToken.getValue());
                } else {
                    throw new JsonException("Expected a value, an array, or an object on line: " + currentToken.getStartLine() + ", column: " + currentToken.getStartColumn() + ".\n" + "But got '" + currentToken.getText() + "' instead.");
                }
                previousToken = currentToken;
                currentToken = lexer.nextToken();
                if (currentToken == null) {
                    throw new JsonException("Expected " + JsonTokenType.CLOSE_CURLY.getLabel() + " or " + JsonTokenType.COMMA.getLabel() + " " + "on line: " + previousToken.getEndLine() + ", column: " + previousToken.getEndColumn() + ".\n" + "But got an unterminated object.");
                }
                if (currentToken.getType() == JsonTokenType.CLOSE_CURLY) break block11;
            } while (currentToken.getType() == JsonTokenType.COMMA);
            throw new JsonException("Expected a value or " + JsonTokenType.CLOSE_CURLY.getLabel() + " " + "on line: " + currentToken.getStartLine() + ", column: " + currentToken.getStartColumn() + ".\n" + "But got '" + currentToken.getText() + "' instead.");
        }
        return content;
    }
}

