/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.ScriptField;
import groovyjarjarasm.asm.Opcodes;
import java.util.Arrays;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class ScriptFieldASTTransformation
extends ClassCodeExpressionTransformer
implements ASTTransformation,
Opcodes {
    private static final Class MY_CLASS = ScriptField.class;
    private static final ClassNode MY_TYPE = new ClassNode(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private SourceUnit sourceUnit;
    private DeclarationExpression candidate;
    private boolean insideScriptBody;

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.sourceUnit = source;
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes));
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(node.getClassNode())) {
            return;
        }
        if (parent instanceof DeclarationExpression) {
            DeclarationExpression de = (DeclarationExpression)parent;
            ClassNode cNode = de.getDeclaringClass();
            if (!cNode.isScript()) {
                this.addError("Error: annotation " + MY_TYPE_NAME + " can only be used within a Script.", parent);
            }
            this.candidate = de;
            super.visitClass(cNode);
            VariableExpression ve = de.getVariableExpression();
            FieldNode fNode = new FieldNode(ve.getName(), ve.getModifiers(), ve.getType(), null, de.getRightExpression());
            fNode.setSourcePosition(de);
            cNode.addField(fNode);
        }
    }

    public Expression transform(Expression expr) {
        DeclarationExpression de;
        if (expr == null) {
            return null;
        }
        if (expr instanceof DeclarationExpression && (de = (DeclarationExpression)expr).getVariableExpression() == this.candidate.getVariableExpression()) {
            if (this.insideScriptBody) {
                return new ConstantExpression(null);
            }
            this.addError("Error: annotation " + MY_TYPE_NAME + " can only be used within a Script body.", expr);
        }
        return expr.transformExpression(this);
    }

    public void visitMethod(MethodNode node) {
        Boolean oldInsideScriptBody = this.insideScriptBody;
        if (node.isScriptBody()) {
            this.insideScriptBody = true;
        }
        super.visitMethod(node);
        this.insideScriptBody = oldInsideScriptBody;
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }
}

