/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import java.util.Arrays;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class LogASTTransformation
implements ASTTransformation {
    public void visit(ASTNode[] nodes, final SourceUnit source) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            this.addError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes), nodes[0], source);
        }
        AnnotatedNode targetClass = (AnnotatedNode)nodes[1];
        AnnotationNode logAnnotation = (AnnotationNode)nodes[0];
        final boolean isJUL = "groovy.util.logging.Log".equals(logAnnotation.getClassNode().getName());
        final boolean isLogBack = "groovy.util.logging.LogBack".equals(logAnnotation.getClassNode().getName());
        final boolean isLog4j = "groovy.util.logging.Log4j".equals(logAnnotation.getClassNode().getName());
        if (!(targetClass instanceof ClassNode)) {
            throw new GroovyBugError("Class annotation @Log annotated no Class, this must not happen.");
        }
        ClassNode classNode = (ClassNode)targetClass;
        ClassCodeExpressionTransformer transformer = new ClassCodeExpressionTransformer(){
            private FieldNode logNode;

            protected SourceUnit getSourceUnit() {
                return source;
            }

            public Expression transform(Expression exp) {
                if (exp == null) {
                    return null;
                }
                if (exp instanceof MethodCallExpression) {
                    return this.transformMethodCallExpression(exp);
                }
                return super.transform(exp);
            }

            public void visitClass(ClassNode node) {
                FieldNode logField = node.getField("log");
                if (logField != null) {
                    this.addError("Class annotated with Log annotation cannot have log field declared", logField);
                } else if (isJUL) {
                    this.logNode = node.addField("log", 154, new ClassNode("java.util.logging.Logger", 1, new ClassNode(Object.class)), new MethodCallExpression((Expression)new ClassExpression(new ClassNode("java.util.logging.Logger", 1, new ClassNode(Object.class))), "getLogger", (Expression)new ConstantExpression(node.getName())));
                } else if (isLogBack) {
                    this.logNode = node.addField("log", 154, new ClassNode("org.slf4j.Logger", 1, new ClassNode(Object.class)), new MethodCallExpression((Expression)new ClassExpression(new ClassNode("org.slf4j.LoggerFactory", 1, new ClassNode(Object.class))), "getLogger", (Expression)new ClassExpression(node)));
                } else if (isLog4j) {
                    this.logNode = node.addField("log", 154, new ClassNode("org.apache.log4j.Logger", 1, new ClassNode(Object.class)), new MethodCallExpression((Expression)new ClassExpression(new ClassNode("org.apache.log4j.Logger", 1, new ClassNode(Object.class))), "getLogger", (Expression)new ClassExpression(node)));
                }
                super.visitClass(node);
            }

            private Expression transformMethodCallExpression(Expression exp) {
                MethodCallExpression mce = (MethodCallExpression)exp;
                if (!(mce.getObjectExpression() instanceof VariableExpression)) {
                    return exp;
                }
                VariableExpression variableExpression = (VariableExpression)mce.getObjectExpression();
                if (!variableExpression.getName().equals("log") || !(variableExpression.getAccessedVariable() instanceof DynamicVariable)) {
                    return exp;
                }
                String methodName = mce.getMethodAsString();
                if (methodName == null) {
                    return exp;
                }
                if (this.usesSimpleMethodArgumentsOnly(mce)) {
                    return exp;
                }
                variableExpression.setAccessedVariable(this.logNode);
                ArgumentListExpression args = new ArgumentListExpression();
                if (isLog4j) {
                    MethodCallExpression condition;
                    if (!methodName.matches("fatal|error|warn|info|debug|trace")) {
                        return exp;
                    }
                    if (!"trace".equals(methodName)) {
                        ClassNode levelClass = new ClassNode("org.apache.log4j.Priority", 0, ClassHelper.OBJECT_TYPE);
                        AttributeExpression logLevelExpression = new AttributeExpression((Expression)new ClassExpression(levelClass), new ConstantExpression(methodName.toUpperCase()));
                        args.addExpression(logLevelExpression);
                        condition = new MethodCallExpression((Expression)variableExpression, "isEnabledFor", (Expression)args);
                    } else {
                        condition = new MethodCallExpression((Expression)variableExpression, "is" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1, methodName.length()) + "Enabled", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
                    }
                    return new TernaryExpression(new BooleanExpression(condition), exp, ConstantExpression.NULL);
                }
                if (isLogBack) {
                    if (!methodName.matches("error|warn|info|debug|trace")) {
                        return exp;
                    }
                    MethodCallExpression condition = new MethodCallExpression((Expression)variableExpression, "is" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1, methodName.length()) + "Enabled", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
                    return new TernaryExpression(new BooleanExpression(condition), exp, ConstantExpression.NULL);
                }
                if (isJUL) {
                    if (!methodName.matches("severe|warning|info|fine|finer|finest")) {
                        return exp;
                    }
                    ClassNode levelClass = new ClassNode("java.util.logging.Level", 0, ClassHelper.OBJECT_TYPE);
                    AttributeExpression logLevelExpression = new AttributeExpression((Expression)new ClassExpression(levelClass), new ConstantExpression(methodName.toUpperCase()));
                    args.addExpression(logLevelExpression);
                    MethodCallExpression condition = new MethodCallExpression((Expression)variableExpression, "isLoggable", (Expression)args);
                    return new TernaryExpression(new BooleanExpression(condition), exp, ConstantExpression.NULL);
                }
                return exp;
            }

            private boolean usesSimpleMethodArgumentsOnly(MethodCallExpression mce) {
                Expression arguments = mce.getArguments();
                if (arguments instanceof TupleExpression) {
                    TupleExpression tuple = (TupleExpression)arguments;
                    for (Expression exp : tuple.getExpressions()) {
                        if (this.isSimpleExpression(exp)) continue;
                        return false;
                    }
                    return true;
                }
                return !this.isSimpleExpression(arguments);
            }

            private boolean isSimpleExpression(Expression exp) {
                if (exp instanceof ConstantExpression) {
                    return true;
                }
                return exp instanceof VariableExpression;
            }
        };
        transformer.visitClass(classNode);
    }

    public void addError(String msg, ASTNode expr, SourceUnit source) {
        int line = expr.getLineNumber();
        int col = expr.getColumnNumber();
        source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', line, col), source));
    }
}

